# バッチ設計書 18-update-undici.sh

## 概要

本ドキュメントは、Node.jsプロジェクトの依存関係更新で使用されるundici更新スクリプト（update-undici.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Node.jsのdeps/undiciディレクトリに配置されているundiciライブラリ（HTTPクライアント）を最新バージョンに更新するスクリプトである。GitHub APIから最新リリースバージョンを取得し、ソースコードをダウンロード・ビルドした後、必要なファイルを配置する。

**業務上の目的・背景**：undiciはNode.jsの内蔵fetchおよびHTTPクライアントの実装に使用されている重要な依存ライブラリである。セキュリティ修正やパフォーマンス改善を取り込むため、定期的な更新が必要。本バッチにより、undiciの更新作業を自動化し、安全かつ確実にバージョンアップを行う。

**バッチの実行タイミング**：GitHub Actionsによる定期チェックまたは手動で実行する。新しいundiciバージョンがリリースされた際に自動検知・更新が可能。

**主要な処理内容**：
1. GitHub APIから最新リリースバージョンを取得
2. 現在のバージョンと比較（同一の場合はスキップ）
3. ソースコードをZIPでダウンロード
4. SHA256チェックサムを検証
5. 不要なファイル・ディレクトリを削除
6. npm install / build:wasm / build:node でビルド
7. undici_version.hを更新
8. maintaining-dependencies.mdのバージョン番号を更新

**前後の処理との関連**：更新後はテストスイートの実行が推奨される。ライセンス更新（license-builder.sh）が必要になる場合がある。

**影響範囲**：deps/undiciディレクトリ、src/undici_version.h、maintaining-dependencies.mdファイルに影響を与える。

## バッチ種別

依存関係更新（ライブラリ更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（新バージョンリリース時） / 定期チェック |
| 実行時刻 | 任意 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsのインストール | GitHub API呼び出し、ビルドに必要 |
| npmのインストール | パッケージインストール・ビルドに必要 |
| curlコマンドのインストール | ZIPダウンロードに必要 |
| unzipコマンドのインストール | ZIP展開に必要 |
| shasum（またはsha256sum）のインストール | チェックサム検証に必要 |
| mktempコマンドのインストール | 一時ディレクトリ作成に必要 |
| GITHUB_TOKEN環境変数（推奨） | GitHub API認証用（レート制限回避） |

### 実行可否判定

1. GitHub APIから最新バージョンを取得できること
2. 最新バージョンと現在のバージョンが異なること（同一の場合はスキップ）
3. 必要なコマンドがインストールされていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | string | No | out/Release/node または system node | Node.js実行ファイルパス（環境変数） |
| GITHUB_TOKEN | string | No | - | GitHub API認証トークン（環境変数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | 最新リリース情報 |
| deps/undici/src/package.json | JSON | 現在のバージョン情報 |
| GitHub | ZIP | undiciソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/undici | ディレクトリ | 更新されたundiciライブラリ |
| src/undici_version.h | C header | バージョン定義 |
| maintaining-dependencies.md | Markdown | バージョン番号の更新 |
| 標準出力 | テキスト | 処理ログ、NEW_VERSION出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | deps/undici/*, src/undici_version.h |
| 出力先 | deps/undici/, src/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 最新バージョンの取得
   └─ GitHub API /repos/nodejs/undici/releases/latest
2. 現在のバージョンの取得
   └─ package.jsonから読み取り
3. バージョン比較
   └─ 同一の場合はスキップ（exit 0）
4. 既存ファイルの削除
   └─ deps/undici/src, deps/undici/undici.js
5. 一時ワークスペースの作成
   └─ mktemp -d
6. ZIPファイルのダウンロード
   └─ curl -sL GitHub archive
7. SHA256チェックサムの検証
   └─ log_and_verify_sha256sum
8. ZIPの展開と配置
   └─ unzip → mv to deps/undici/src
9. 不要ファイルの削除
   └─ .husky, .github, test, benchmarks, docs-tmp
10. ビルド処理
    └─ npm install --ignore-scripts
    └─ npm run build:wasm
    └─ npm run build:node
    └─ npm prune --production
11. undici_version.hの更新
    └─ catでヘッダーファイル生成
12. ファイルの配置
    └─ undici-fetch.js → undici.js
    └─ LICENSE → deps/undici/LICENSE
13. バージョン情報の更新
    └─ finalize_version_update
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[最新バージョン取得]
    B --> C[現在バージョン取得]
    C --> D{バージョン比較}
    D -->|同一| E[スキップ exit 0]
    D -->|異なる| F[既存ファイル削除]
    F --> G[一時ワークスペース作成]
    G --> H[ZIPダウンロード]
    H --> I[SHA256検証]
    I --> J{検証成功?}
    J -->|いいえ| K[エラー終了]
    J -->|はい| L[ZIP展開・配置]
    L --> M[不要ファイル削除]
    M --> N[npm install]
    N --> O[npm run build:wasm]
    O --> P[npm run build:node]
    P --> Q[npm prune --production]
    Q --> R[undici_version.h更新]
    R --> S[ファイル配置]
    S --> T[バージョン情報更新]
    T --> U[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを操作しない。ファイルシステム操作のみ。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ディレクトリ削除 | deps/undici/src | DELETE | 既存ソースの削除 |
| ファイル削除 | deps/undici/undici.js | DELETE | 既存ビルド成果物の削除 |
| ディレクトリ作成 | deps/undici/src | INSERT | 新規ソースの配置 |
| ファイル更新 | src/undici_version.h | UPDATE | バージョン定義の更新 |
| ファイル更新 | maintaining-dependencies.md | UPDATE | バージョン番号の更新 |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API エラー | GitHub API失敗 | ネットワーク・GITHUB_TOKENを確認 |
| 0 | スキップ | バージョンが同一 | 正常終了（更新不要） |
| - | ダウンロードエラー | curlコマンド失敗 | ネットワーク接続を確認 |
| - | チェックサムエラー | SHA256検証失敗 | tarballの整合性を確認 |
| - | ビルドエラー | npm install/build失敗 | 依存関係・環境を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. GITHUB_TOKENが設定されているか確認（レート制限）
3. ネットワーク接続を確認
4. Node.js/npmのバージョンを確認
5. 一時ファイルが残っている場合は手動削除
6. cleanup関数により一時ワークスペースは自動削除

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | N/A（手動での復旧が必要） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 10分以内（ビルド含む） |
| メモリ使用量上限 | ビルド処理により変動 |

## 排他制御

- 同時実行は想定しない
- deps/undiciディレクトリの排他ロックは行わない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| バージョンログ | 処理開始時 | 現在バージョン、新バージョン |
| 進捗ログ | 各ステップ | Fetching..., Unzipping..., etc. |
| ビルドログ | ビルド時 | wasm_build_env.txt |
| 完了ログ | 処理完了時 | All done! |
| バージョンログ | 最終行 | NEW_VERSION=xxx |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 15分 | 標準出力 |

## 備考

- `set -e`オプションにより、エラー発生時は即座に終了する
- utils.shからユーティリティ関数をインポート
  - `compare_dependency_version`: バージョン比較
  - `log_and_verify_sha256sum`: SHA256チェックサムの検証
  - `finalize_version_update`: バージョン情報の更新
- 一時ワークスペースはtrapによりINT/TERM/EXIT時に自動削除
- 削除される不要ファイル：.husky, .github, test, benchmarks, docs-tmp
- docs/docsのみ残す（docs-tmpからmv）
- llhttp wasmをソースからリビルド
- build:wasmの出力をwasm_build_env.txtに記録
- npm prune --productionで開発依存を削除
- undici_version.hは自動生成ファイル
- GITHUB_TOKEN指定時はAuthorizationヘッダーを追加（レート制限回避）
