# バッチ設計書 19-update-libuv.sh

## 概要

本ドキュメントは、Node.jsプロジェクトの依存関係更新で使用されるlibuv更新スクリプト（update-libuv.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Node.jsのdeps/uvディレクトリに配置されているlibuvライブラリ（イベントループ・非同期I/O）を最新バージョンに更新するスクリプトである。GitHub APIから最新リリースバージョンを取得し、ソースコードをダウンロードした後、GYP/GNビルドファイルを保持しながら既存ソースを置き換える。

**業務上の目的・背景**：libuvはNode.jsのイベントループおよび非同期I/Oの中核を担う重要な依存ライブラリである。セキュリティ修正、バグ修正、パフォーマンス改善を取り込むため、定期的な更新が必要。本バッチにより、libuvの更新作業を自動化し、安全かつ確実にバージョンアップを行う。

**バッチの実行タイミング**：GitHub Actionsによる定期チェックまたは手動で実行する。新しいlibuvバージョンがリリースされた際に自動検知・更新が可能。

**主要な処理内容**：
1. GitHub APIから最新リリースバージョンを取得
2. version.hから現在のバージョン情報を抽出
3. バージョン比較（同一の場合はスキップ）
4. tarballをダウンロード
5. SHA256チェックサムを検証
6. GYP/GNビルドファイルを保存
7. 既存ディレクトリを削除し新ソースを配置
8. ビルドファイルを復元
9. maintaining-dependencies.mdのバージョン番号を更新

**前後の処理との関連**：更新後はフルビルドとテストスイートの実行が推奨される。ライセンス更新（license-builder.sh）が必要になる場合がある。

**影響範囲**：deps/uvディレクトリ全体、maintaining-dependencies.mdファイルに影響を与える。

## バッチ種別

依存関係更新（ライブラリ更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（新バージョンリリース時） / 定期チェック |
| 実行時刻 | 任意 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsのインストール | GitHub API呼び出しに必要 |
| curlコマンドのインストール | tarballダウンロードに必要 |
| gzip / tarコマンドのインストール | tarball展開に必要 |
| shasum（またはsha256sum）のインストール | チェックサム検証に必要 |
| mktempコマンドのインストール | 一時ディレクトリ作成に必要 |
| GITHUB_TOKEN環境変数（推奨） | GitHub API認証用（レート制限回避） |

### 実行可否判定

1. GitHub APIから最新バージョンを取得できること
2. 最新バージョンと現在のバージョンが異なること（同一の場合はスキップ）
3. 必要なコマンドがインストールされていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | string | No | out/Release/node または system node | Node.js実行ファイルパス（環境変数） |
| GITHUB_TOKEN | string | No | - | GitHub API認証トークン（環境変数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | 最新リリース情報 |
| deps/uv/include/uv/version.h | C header | 現在のバージョン情報 |
| GitHub | tar.gz | libuvソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/uv | ディレクトリ | 更新されたlibuvライブラリ |
| maintaining-dependencies.md | Markdown | バージョン番号の更新 |
| 標準出力 | テキスト | 処理ログ、NEW_VERSION出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | deps/uv/* |
| 出力先 | deps/uv/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 最新バージョンの取得
   └─ GitHub API /repos/libuv/libuv/releases/latest
2. 現在のバージョンの取得
   └─ version.hからMAJOR/MINOR/PATCH/IS_RELEASE/SUFFIXを抽出
3. バージョン比較
   └─ 同一の場合はスキップ（exit 0）
4. 一時ワークスペースの作成
   └─ mktemp -d
5. tarballのダウンロード
   └─ curl -sL GitHub API tarball
6. SHA256チェックサムの検証
   └─ log_and_verify_sha256sum
7. tarballの展開
   └─ gzip -dc | tar xf -
8. GYP/GNファイルの退避
   └─ mv *.gyp *.gypi *.gn *.gni to workspace
9. 既存uvディレクトリの削除
   └─ rm -rf "$DEPS_DIR/uv"
10. 新ディレクトリの配置
    └─ mv workspace/uv "$DEPS_DIR/"
11. バージョン情報の更新
    └─ finalize_version_update
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[最新バージョン取得]
    B --> C[version.hからバージョン抽出]
    C --> D{バージョン比較}
    D -->|同一| E[スキップ exit 0]
    D -->|異なる| F[一時ワークスペース作成]
    F --> G[tarballダウンロード]
    G --> H[SHA256検証]
    H --> I{検証成功?}
    I -->|いいえ| J[エラー終了]
    I -->|はい| K[tarball展開]
    K --> L[GYP/GNファイル退避]
    L --> M[既存uvディレクトリ削除]
    M --> N[新ディレクトリ配置]
    N --> O[バージョン情報更新]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを操作しない。ファイルシステム操作のみ。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル退避 | deps/uv/*.gyp等 | MOVE | GYP/GNファイルの一時退避 |
| ディレクトリ削除 | deps/uv | DELETE | 既存libuvの削除 |
| ディレクトリ作成 | deps/uv | INSERT | 新規libuvの配置 |
| ファイル更新 | maintaining-dependencies.md | UPDATE | バージョン番号の更新 |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API エラー | GitHub API失敗 | ネットワーク・GITHUB_TOKENを確認 |
| 0 | スキップ | バージョンが同一 | 正常終了（更新不要） |
| - | ダウンロードエラー | curlコマンド失敗 | ネットワーク接続を確認 |
| - | チェックサムエラー | SHA256検証失敗 | tarballの整合性を確認 |
| - | 展開エラー | gzip/tarコマンド失敗 | ディスク容量・権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. GITHUB_TOKENが設定されているか確認（レート制限）
3. ネットワーク接続を確認
4. ディスク容量・権限を確認
5. 一時ファイルが残っている場合は手動削除
6. cleanup関数により一時ワークスペースは自動削除
7. GYP/GNファイルが失われた場合はgitから復元

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | N/A（手動での復旧が必要） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 標準シェル環境 |

## 排他制御

- 同時実行は想定しない
- deps/uvディレクトリの排他ロックは行わない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ステップ | Making temporary workspace..., Fetching..., Replacing... |
| チェックサムログ | 検証時 | SHA256チェックサム値 |
| 完了ログ | 処理完了時 | All done! |
| バージョンログ | 最終行 | NEW_VERSION=xxx |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | 標準出力 |

## 備考

- `set -e`および`set -x`オプションにより、エラー発生時は即座に終了し、実行コマンドが表示される
- utils.shからユーティリティ関数をインポート
  - `compare_dependency_version`: バージョン比較
  - `log_and_verify_sha256sum`: SHA256チェックサムの検証
  - `finalize_version_update`: バージョン情報の更新
- 一時ワークスペースはtrapによりINT/TERM/EXIT時に自動削除
- バージョン文字列の構成：`MAJOR.MINOR.PATCH[-SUFFIX]`
  - UV_VERSION_IS_RELEASE=1かSUFFIXが空の場合はサフィックスなし
- GYP/GNビルドファイルは独自に管理されているため、更新時に保存・復元が必要
  - `*.gyp`, `*.gypi`, `*.gn`, `*.gni`
- GitHub APIからのtarballはlibuv-libuv-*形式で展開されるため、リネームが必要
- GITHUB_TOKEN指定時はAuthorizationヘッダーを追加（レート制限回避）
