# バッチ設計書 2-configure.py

## 概要

本ドキュメントは、Node.jsプロジェクトのビルド構成スクリプト「configure.py」の設計仕様を記載したものである。

### 本バッチの処理概要

configure.pyは、Node.jsをビルドするための設定を生成するPythonスクリプトである。GYP（Generate Your Projects）を使用して、各プラットフォーム向けのビルドファイル（Makefile、Visual Studioプロジェクト等）を生成する。

**業務上の目的・背景**：Node.jsは複数のプラットフォーム（Linux、macOS、Windows、FreeBSD等）と複数のアーキテクチャ（x64、arm64、ppc64等）をサポートするクロスプラットフォームプロジェクトである。各環境での最適なビルド設定を自動生成し、開発者がプラットフォーム固有の設定を意識することなくビルドできるようにするために、このスクリプトが必要である。また、OpenSSL、ICU、V8等の依存ライブラリの共有/静的リンク設定や、国際化対応の有無など、多様なビルドオプションを統一的に管理する。

**バッチの実行タイミング**：初回ビルド時、またはビルド設定を変更したい場合に手動実行される。vcbuild.bat（Windows）やMakefile（Unix系）から間接的に呼び出されることもある。

**主要な処理内容**：
1. コマンドライン引数の解析とバリデーション
2. ホストOSとターゲットプラットフォームの検出
3. コンパイラ（GCC、Clang）の検出とバージョン確認
4. 依存ライブラリ（OpenSSL、ICU、libuv等）の設定
5. config.gypiファイルの生成
6. GYPを実行してビルドファイルを生成
7. config.statusスクリプトの生成（再設定用）

**前後の処理との関連**：vcbuild.batまたはMakefileから呼び出され、生成されたconfig.gypiはビルド時に参照される。GYPが生成したMakefileまたはVisual Studioプロジェクトが後続のビルド処理で使用される。

**影響範囲**：生成されるconfig.gypiとビルドファイルは、Node.js本体のコンパイル、依存ライブラリのリンク方法、有効化される機能（国際化、暗号化等）に直接影響する。

## バッチ種別

ビルド構成生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（初回ビルド時、設定変更時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / vcbuild.bat / make |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3 | Python 3がインストールされていること |
| GCC/Clang | C/C++コンパイラがインストールされていること |
| GYP | tools/gyp配下にGYPが存在すること |

### 実行可否判定

- 無効なOSまたはアーキテクチャが指定された場合はエラー終了
- 必須の依存ライブラリが見つからない場合は警告またはエラー
- クロスコンパイル時の設定矛盾を検出

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --prefix | 文字列 | No | /usr/local | インストール先プレフィックス |
| --debug | フラグ | No | - | デバッグビルドを有効化 |
| --dest-cpu | 文字列 | No | ホストCPU | ターゲットCPUアーキテクチャ |
| --dest-os | 文字列 | No | ホストOS | ターゲットOS |
| --with-intl | 文字列 | No | full-icu | 国際化モード（none/small-icu/full-icu/system-icu） |
| --shared-openssl | フラグ | No | - | OpenSSLを共有ライブラリとしてリンク |
| --shared-libuv | フラグ | No | - | libuvを共有ライブラリとしてリンク |
| --shared-zlib | フラグ | No | - | zlibを共有ライブラリとしてリンク |
| --without-npm | フラグ | No | - | npmを含めない |
| --without-ssl | フラグ | No | - | OpenSSLを無効化 |
| --download | 文字列 | No | - | 依存ファイルのダウンロードモード |
| --enable-lto | フラグ | No | - | Link Time Optimizationを有効化 |
| --coverage | フラグ | No | - | カバレッジビルドを有効化 |
| --clang-cl | 文字列 | No | - | Clang-CLバージョン指定（Windows） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node.gyp | GYPファイル | メインビルド定義 |
| common.gypi | GYPファイル | 共通ビルド設定 |
| *.gyp | GYPファイル | 各モジュールのビルド定義 |
| node_version.h | ヘッダ | バージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| config.gypi | GYPi形式 | ビルド設定ファイル |
| config.mk | Makefile形式 | Make用設定ファイル |
| config.status | シェルスクリプト | 再設定用スクリプト |
| out/Makefile | Makefile | ビルド用Makefile |
| node.sln | VS Solution | Visual Studioソリューション（Windows） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | config.gypi |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（Python辞書形式） |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ argparseで全コマンドライン引数を解析
2. プラットフォーム検出
   └─ ホストOS、CPU、クロスコンパイル状態を判定
3. コンパイラ検出
   └─ CC/CXX環境変数、デフォルトコンパイラを確認
4. 依存ライブラリ設定
   └─ OpenSSL、ICU、libuv等の設定を決定
5. 変数辞書構築
   └─ GYP用のvariables辞書を構築
6. config.gypi生成
   └─ 設定をPython辞書形式で出力
7. GYP実行
   └─ gyp_node.pyを呼び出してビルドファイル生成
8. config.status生成
   └─ 再設定用のスクリプトを出力
```

### フローチャート

```mermaid
flowchart TD
    A[configure.py開始] --> B[引数解析]
    B --> C[プラットフォーム検出]
    C --> D[コンパイラ検出]
    D --> E{クロスコンパイル?}
    E -->|Yes| F[クロスコンパイル設定]
    E -->|No| G[ネイティブ設定]
    F --> H[依存ライブラリ設定]
    G --> H
    H --> I[変数辞書構築]
    I --> J[config.gypi生成]
    J --> K[GYP実行]
    K --> L{成功?}
    L -->|Yes| M[config.status生成]
    L -->|No| N[エラー終了]
    M --> O[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 無効なOS/アーキテクチャ指定 | 有効な値を指定 |
| 1 | 依存エラー | 必須ライブラリが見つからない | ライブラリをインストール |
| 1 | GYPエラー | ビルドファイル生成失敗 | エラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- エラーメッセージに従って不足している依存ライブラリをインストール
- --verboseオプションで詳細なログを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の設定生成 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの複数同時実行は非推奨。config.gypiが競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理ステップ | 設定内容の表示 |
| 警告ログ | 推奨されない設定時 | 警告メッセージ |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元スクリプト |

## 備考

- サポートされるOS: win, mac, solaris, freebsd, openbsd, linux, android, aix, cloudabi, os400, ios, openharmony
- サポートされるアーキテクチャ: arm, arm64, ia32, mips, mipsel, mips64el, ppc64, x64, x86, x86_64, s390x, riscv64, loong64
- ICUモード: none（国際化無効）、small-icu（基本データのみ）、full-icu（全データ）、system-icu（システムICU使用）
