# バッチ設計書 21-update-openssl.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるOpenSSL暗号ライブラリの更新バッチ `update-openssl.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるOpenSSLを最新バージョンに更新するためのシェルスクリプトである。OpenSSLはNode.jsのTLS/SSL通信、暗号化処理の基盤となる重要なセキュリティライブラリである。

**業務上の目的・背景**：OpenSSLはセキュリティ上の脆弱性が発見されると頻繁にアップデートが行われるライブラリである。Node.jsがセキュリティパッチを迅速に取り込むためには、OpenSSLの更新プロセスを自動化し、効率的に依存ライブラリを最新状態に保つ必要がある。本バッチはこの課題を解決し、Node.jsのセキュリティ品質を維持するために使用される。

**バッチの実行タイミング**：OpenSSLの新バージョンリリース時、またはセキュリティアドバイザリ発行時に手動で実行される。GitHub Actionsによる自動実行も可能である。

**主要な処理内容**：
1. GitHub APIを使用してOpenSSLの最新リリースタグを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. 一時ワークスペースを作成し、新バージョンのソースアーカイブをダウンロード
4. SHA256チェックサムを検証
5. 既存のOpenSSLソースを新バージョンで置換
6. プラットフォーム依存ファイルの再生成（regenerateサブコマンド使用時）

**前後の処理との関連**：本バッチ実行後、`make gen-openssl`コマンドによるプラットフォーム依存ファイルの生成が必要となる場合がある。regenerateサブコマンドはこれを自動的に実行する。

**影響範囲**：`deps/openssl/`ディレクトリ配下のソースファイル、`deps/openssl/config/archs/`配下のプラットフォーム依存設定ファイルに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | GitHub APIおよびOpenSSLリポジトリへのアクセスが可能であること |
| Docker環境（regenerate時） | プラットフォーム依存ファイル再生成時にDockerが必要 |
| make（regenerate時） | Makefileの実行に必要 |
| curl | アーカイブダウンロードに使用 |
| gzip/tar | アーカイブ展開に使用 |

### 実行可否判定

1. サブコマンド（download/regenerate/help）が指定されていること
2. downloadサブコマンドの場合、現在のバージョンと最新バージョンが異なること
3. regenerateサブコマンドの場合、dockerとmakeが利用可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| サブコマンド | string | Yes | なし | download / regenerate / help のいずれか |
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | OpenSSLリリース情報の取得元 |
| deps/openssl/config/archs/linux-x86_64/asm/include/openssl/opensslv.h | C Header | 現在のバージョン情報取得元 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/openssl/openssl/ | ディレクトリ | 更新されたOpenSSLソースコード |
| deps/openssl/config/archs/ | ディレクトリ | プラットフォーム依存設定（regenerate時） |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | OpenSSLソースファイル群 |
| 出力先 | deps/openssl/openssl/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR、NODE変数の設定
   └─ utils.shの読み込み
   └─ クリーンアップ用trapの設定

2. サブコマンド分岐
   └─ help: ヘルプメッセージ表示
   └─ download: ダウンロード処理実行
   └─ regenerate: 再生成処理実行

3. download処理
   └─ GitHub APIで最新タグ取得（openssl-3.5系）
   └─ バージョン文字列の正規化
   └─ 現在バージョンとの比較
   └─ 一時ワークスペース作成
   └─ tarballダウンロード
   └─ SHA256チェックサム検証
   └─ アーカイブ展開
   └─ 既存ディレクトリの置換
   └─ gitコマンド案内出力

4. regenerate処理
   └─ docker/make存在確認
   └─ 設定ファイルクリーンアップ
   └─ x86asm.plのプリプロセッサ互換対応
   └─ make gen-openssl実行
   └─ gitコマンド案内出力

5. 終了処理
   └─ 一時ワークスペース削除
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{サブコマンド判定}
    B -->|help| C[ヘルプ表示]
    B -->|download| D[GitHub APIで最新バージョン取得]
    B -->|regenerate| E{docker/make確認}

    D --> F{バージョン比較}
    F -->|同一| G[スキップ終了]
    F -->|更新あり| H[一時ワークスペース作成]
    H --> I[tarballダウンロード]
    I --> J[SHA256検証]
    J --> K[アーカイブ展開]
    K --> L[既存ディレクトリ置換]
    L --> M[完了メッセージ出力]

    E -->|OK| N[config clean]
    E -->|NG| O[エラー終了]
    N --> P[x86asm.pl修正]
    P --> Q[make gen-openssl]
    Q --> R[完了メッセージ出力]

    C --> S[バッチ終了]
    G --> S
    M --> S
    O --> S
    R --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コマンドエラー | 不明なサブコマンド指定 | helpで有効なサブコマンドを確認 |
| 1 | 環境エラー | dockerが未インストール（regenerate時） | Dockerをインストール |
| 1 | 環境エラー | makeが未インストール（regenerate時） | makeをインストール |
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | チェックサムエラー | SHA256検証失敗 | 再実行、ダウンロード元確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. 既存のOpenSSLディレクトリは新バージョンのコピー完了後に削除されるため、失敗時も既存ファイルは保持される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 全ファイルコピー完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | download: 5分以内、regenerate: 30分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。複数回同時実行した場合、一時ワークスペースは別々に作成されるが、deps/openssl/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace..." |
| 進捗ログ | ダウンロード時 | "Fetching OpenSSL source archive..." |
| 進捗ログ | 置換時 | "Replacing existing OpenSSL..." |
| 完了ログ | 処理完了時 | "All done!" + gitコマンド案内 |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| 処理時間 | 60分超過 | GitHub Actions |

## 備考

- OpenSSL 3.5系のリリースを対象としている（スクリプト内でopenssl-3.5でフィルタリング）
- QUIC対応バージョン（末尾がquic1）の特別処理がある
- regenerate処理はDockerを使用してクロスプラットフォームのビルド設定を生成する
- 32-bit Windows向けnasmとの互換性のため、x86asm.plの#ifdef/#endifを%ifdef/%endifに変換する処理が含まれる
