# バッチ設計書 22-update-zlib.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるzlib圧縮ライブラリの更新バッチ `update-zlib.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるzlibを最新バージョンに更新するためのシェルスクリプトである。zlibはデータ圧縮・解凍のための基盤ライブラリであり、Node.jsのzlibモジュールで使用されている。

**業務上の目的・背景**：zlibはリリースやタグの作成が稀であるため、Chromiumプロジェクトがメンテナンスしているzlibフォークのmainブランチの最新コミットを使用する。これにより、パフォーマンス改善やセキュリティ修正を継続的に取り込むことが可能となる。本バッチはこの特殊な更新フローを自動化し、Node.jsの圧縮機能の品質を維持するために使用される。

**バッチの実行タイミング**：週次（日曜日深夜UTC想定）でGitHub Actionsにより自動実行される。最新コミットが2日以内の場合は安定性確保のためスキップされる。

**主要な処理内容**：
1. Chromium zlibリポジトリから最新コミットを取得
2. 現在の依存バージョンとの差分を確認
3. 最終変更日が2日以上前であることを確認（安定性チェック）
4. 一時ワークスペースを作成し、新バージョンのソースをダウンロード
5. SHA256チェックサムを検証
6. Node.js固有のファイル（zlib.gyp、win32/zlib.def）を保持しつつ置換
7. zconf.hのchromeconf.h参照を無効化
8. src/zlib_version.hを更新

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/zlib/`ディレクトリ配下のソースファイル、`src/zlib_version.h`に影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 |
| 実行時刻 | 日曜日深夜（UTC） |
| 実行曜日 | 日曜日 |
| 実行日 | 毎週 |
| トリガー | GitHub Actions / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| git | Chromiumリポジトリからのfetch、diff比較に使用 |
| perl | zconf.hの編集に使用 |
| curl | アーカイブダウンロードに使用 |
| gzip/tar | アーカイブ展開に使用 |
| date -d オプション | 日付計算に使用（GNU date必須） |

### 実行可否判定

1. 現在のバージョンと最新コミットに差分が存在すること
2. 最新コミットが2日以上前であること（安定性確保）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Chromium zlib Git | Git Repository | zlibソースの取得元 |
| deps/zlib/zconf.h | C Header | 差分比較用 |
| deps/zlib/zlib.h | C Header | バージョン情報取得元 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/zlib/ | ディレクトリ | 更新されたzlibソースコード |
| src/zlib_version.h | C Header | バージョン情報ヘッダ |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | zlib_version.h |
| 出力先 | src/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ utils.shの読み込み

2. 差分確認
   └─ Chromiumリポジトリからfetch
   └─ zconf.hのchromeconf.h参照を一時的に有効化
   └─ git stashで現在の変更を退避
   └─ git diffで差分を確認
   └─ stash drop

3. 更新判定
   └─ 差分がなければスキップ終了
   └─ 最終コミット日が2日以内ならスキップ終了

4. ダウンロード処理
   └─ 一時ワークスペース作成
   └─ tarballダウンロード
   └─ SHA256チェックサム検証
   └─ アーカイブ展開

5. ファイル置換
   └─ 既存のzlib.gyp、win32/zlib.defを退避
   └─ 既存のdeps/zlibを削除
   └─ 新バージョンを配置
   └─ zlib.gyp、win32/zlib.defを復元
   └─ zconf.hのchromeconf.h参照を無効化

6. バージョン更新
   └─ zlib.hからバージョン番号取得
   └─ コミットハッシュと組み合わせてバージョン文字列生成
   └─ src/zlib_version.hを生成
   └─ maintaining-dependencies.md更新
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Chromiumリポジトリfetch]
    B --> C[zconf.h一時修正]
    C --> D[git stash]
    D --> E[git diff確認]
    E --> F{差分あり?}
    F -->|なし| G[スキップ終了]
    F -->|あり| H{最終コミット2日以上前?}
    H -->|いいえ| I[スキップ終了]
    H -->|はい| J[一時ワークスペース作成]
    J --> K[tarballダウンロード]
    K --> L[SHA256検証]
    L --> M[アーカイブ展開]
    M --> N[既存ファイル退避]
    N --> O[deps/zlib削除]
    O --> P[新バージョン配置]
    P --> Q[ファイル復元]
    Q --> R[zconf.h修正]
    R --> S[zlib_version.h生成]
    S --> T[finalize_version_update]
    T --> U[バッチ終了]
    G --> U
    I --> U
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | Chromiumリポジトリ接続失敗 | ネットワーク接続を確認 |
| 1 | チェックサムエラー | SHA256検証失敗 | 再実行、ダウンロード元確認 |
| 0 | スキップ | 差分なし | 正常終了（更新不要） |
| 0 | スキップ | 最終コミットが新しすぎる | 正常終了（安定性待機） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. 既存ファイルの退避はmvではなくcpを使用しているため、失敗時も既存ファイルは保持される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 全ファイルコピー完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。git stash操作があるため、同時実行するとstashの競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 差分確認時 | "Comparing latest upstream with current revision" |
| スキップログ | 差分なし時 | "Skipped because zlib is on the latest version." |
| スキップログ | コミット新しすぎ | "Skipped because the latest version is too recent." |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace..." |
| 進捗ログ | ダウンロード時 | "Fetching zlib source archive" |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X-xxxxxxx" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| 連続スキップ | 4週以上 | 手動確認推奨 |

## 備考

- Chromiumプロジェクトがメンテナンスしているzlibフォーク（https://chromium.googlesource.com/chromium/src/third_party/zlib.git）を使用
- 通常のzlibはリリース/タグが稀なため、mainブランチの最新コミットを使用する運用
- バージョン文字列は「zlibバージョン-短縮コミットハッシュ」形式（例：1.2.13-abc1234）
- zconf.hのchromeconf.h参照は、Node.js環境では不要なため無効化される
- 日曜日深夜実行で、金曜・土曜のコミットを避けることで安定性を確保
- GNU date の -d オプションを使用するため、macOSのデフォルトdateでは動作しない可能性がある
