# バッチ設計書 23-update-icu.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるICU（International Components for Unicode）ライブラリの更新バッチ `update-icu.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるICU（国際化ライブラリ）を最新バージョンに更新するためのシェルスクリプトである。ICUはNode.jsの国際化機能（Intl API）の基盤となる重要なライブラリである。

**業務上の目的・背景**：ICUは国際化機能を提供するライブラリであり、ロケール、日付・時刻フォーマット、数値フォーマット、照合順序などの機能に使用される。Unicodeの新バージョンや国際化機能の改善に追従するため、定期的な更新が必要である。本バッチはICUの更新プロセスを自動化し、Node.jsの国際化機能の品質を維持するために使用される。

**バッチの実行タイミング**：ICUの新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してICUの最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. リリースページからMD5チェックサムを取得し、ダウンロードしたアーカイブと照合
4. configureスクリプトで--with-intl=full-icuオプションを使用してビルド設定
5. shrink-icu-src.pyでICUソースを縮小（不要なファイルを除去）
6. tools/icu/current_ver.depのURL・MD5を更新

**前後の処理との関連**：configureスクリプトとshrink-icu-src.pyスクリプトに依存する。本バッチ実行後にNode.jsの再ビルドが必要。

**影響範囲**：`deps/icu-small/`ディレクトリ配下のソースファイル、`tools/icu/current_ver.dep`に影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| Python3 | configureスクリプト、shrink-icu-src.pyに使用 |
| ネットワーク接続 | GitHub APIおよびICUリリースページへのアクセスが可能であること |
| curl | チェックサム・アーカイブのダウンロードに使用 |
| md5sum | チェックサム検証に使用 |
| perl | current_ver.depの編集に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること
2. ダウンロードしたアーカイブのMD5チェックサムが公開値と一致すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | ICUリリース情報の取得元 |
| deps/icu-small/source/common/unicode/uvernum.h | C Header | 現在のバージョン情報取得元 |
| ICUリリースページ | MD5ファイル | チェックサム検証用 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/icu-small/ | ディレクトリ | 更新・縮小されたICUソースコード |
| tools/icu/current_ver.dep | JSON | ICUバージョン情報 |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | current_ver.dep |
| 出力先 | tools/icu/ |
| 文字コード | UTF-8 |
| 形式 | JSON（urlとmd5フィールド） |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR、TOOLS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン確認
   └─ GitHub APIで最新リリースバージョン取得
   └─ タグ名からバージョン文字列を抽出（release-XX-X → XX.X）
   └─ uvernum.hから現在バージョン取得
   └─ バージョン比較（同一ならスキップ終了）

3. チェックサム検証
   └─ リリースページからMD5ファイルをダウンロード
   └─ tarballをダウンロードしてMD5を計算
   └─ チェックサム照合（不一致ならスキップ終了）

4. ビルド設定
   └─ ./configure --with-intl=full-icu --with-icu-source=URL 実行
   └─ shrink-icu-src.py実行でソース縮小

5. クリーンアップ・更新
   └─ deps/icu削除
   └─ current_ver.depのURL更新
   └─ current_ver.depのMD5更新
   └─ out/ディレクトリ、deps/icu、deps/icu4c*削除

6. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub APIで最新バージョン取得]
    B --> C[uvernum.hから現在バージョン取得]
    C --> D{バージョン比較}
    D -->|同一| E[スキップ終了]
    D -->|更新あり| F[MD5ファイルダウンロード]
    F --> G[tarball MD5計算]
    G --> H{チェックサム一致?}
    H -->|不一致| I[スキップ終了]
    H -->|一致| J[configure実行]
    J --> K[shrink-icu-src.py実行]
    K --> L[deps/icu削除]
    L --> M[current_ver.dep更新]
    M --> N[out/, deps/icu, deps/icu4c*削除]
    N --> O[finalize_version_update]
    O --> P[バッチ終了]
    E --> P
    I --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | MD5ファイルダウンロード失敗 | ネットワーク接続を確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |
| 0 | スキップ | チェックサム不一致 | 正常終了（整合性エラー） |
| 1 | configureエラー | ビルド設定失敗 | 依存関係を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. チェックサム不一致時は警告メッセージを出力してスキップ
3. configure失敗時は既存のICUソースは保持される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 全処理完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。configure実行時にout/ディレクトリを使用するため、同時実行すると競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | チェックサム比較時 | "Comparing checksums: deposited 'X' with 'Y'" |
| スキップログ | チェックサム不一致時 | "Skipped because checksums do not match." |
| バージョンログ | 最終行 | "NEW_VERSION=XX.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| チェックサム不一致 | 発生時 | 手動確認推奨 |

## 備考

- ICUはフルサイズが大きいため、shrink-icu-src.pyで不要なデータを除去して「icu-small」として保持
- GITHUB_TOKEN環境変数を設定することでGitHub APIのレート制限を回避可能
- current_ver.depファイルはJSONフォーマットでICUのダウンロードURLとMD5チェックサムを保持
- リリースタグ名は「release-XX-X」形式、バージョン文字列は「XX.X」形式に変換される
- configureスクリプトは--with-icu-sourceオプションでリモートURLを直接指定可能
