# バッチ設計書 24-update-llhttp.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるllhttp HTTPパーサーライブラリの更新バッチ `update-llhttp.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるllhttp（HTTPパーサー）を最新バージョンに更新するためのシェルスクリプトである。llhttpはNode.jsのHTTP処理の中核を担う重要なライブラリである。

**業務上の目的・背景**：llhttpはNode.jsが使用する高性能なHTTPパーサーである。HTTPプロトコルの仕様変更やパフォーマンス改善、セキュリティ修正を取り込むために定期的な更新が必要である。本バッチはllhttpの更新プロセスを自動化し、Node.jsのHTTP処理機能の品質を維持するために使用される。

**バッチの実行タイミング**：llhttpの新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してllhttpの最新リリースバージョンを取得（またはLOCAL_COPYから取得）
2. 現在のバージョンと比較し、更新の必要性を判定
3. GYP/GNビルドファイルを一時退避
4. 新バージョンのソースを取得（複数の取得方法に対応）
5. deps/llhttp/を新バージョンで置換
6. ビルドファイルを復元

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/llhttp/`ディレクトリ配下のソースファイル、maintaining-dependencies.mdに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | GitHub APIおよびllhttpリポジトリへのアクセスが可能であること（リモート取得時） |
| curl | アーカイブダウンロードに使用 |
| gzip/tar | アーカイブ展開に使用 |
| npm | ローカルビルドまたはリポジトリクローン時に使用 |
| git | リポジトリクローン時に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| LOCAL_COPY | 環境変数 | No | なし | ローカルllhttpディレクトリのパス |
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |
| 第1引数 | string | No | なし | フォーク指定時のGitHubユーザー/リポジトリ |
| 第2引数 | string | No | main | フォーク指定時のブランチ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | llhttpリリース情報の取得元 |
| deps/llhttp/include/llhttp.h | C Header | 現在のバージョン情報取得元 |
| LOCAL_COPY/package.json | JSON | ローカルコピー時のバージョン取得元 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/llhttp/ | ディレクトリ | 更新されたllhttpソースコード |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | llhttpソースファイル群 |
| 出力先 | deps/llhttp/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン取得
   └─ LOCAL_COPYが設定されている場合：package.jsonからバージョン取得
   └─ それ以外：GitHub APIで最新リリースバージョン取得

3. バージョン比較
   └─ llhttp.hからMAJOR/MINOR/PATCHバージョン取得
   └─ バージョン比較（同一ならスキップ終了）

4. ビルドファイル退避
   └─ 一時ワークスペース作成
   └─ trapでクリーンアップ設定
   └─ *.gn、*.gniファイルを一時ディレクトリに退避

5. ソース取得（3パターン）
   A. LOCAL_COPYの場合
      └─ npm install実行
      └─ make release実行
      └─ releaseディレクトリをコピー
   B. フォーク指定（引数に/含む）の場合
      └─ git clone実行
      └─ 指定ブランチをcheckout
      └─ npm install + make release実行
      └─ releaseディレクトリをコピー
   C. リリースタグの場合（デフォルト）
      └─ tarballダウンロード
      └─ アーカイブ展開
      └─ ディレクトリをコピー

6. ビルドファイル復元
   └─ *.gn、*.gniファイルを復元

7. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{LOCAL_COPY設定?}
    B -->|はい| C[package.jsonからバージョン取得]
    B -->|いいえ| D[GitHub APIでバージョン取得]
    C --> E[llhttp.hから現在バージョン取得]
    D --> E
    E --> F{バージョン比較}
    F -->|同一| G[スキップ終了]
    F -->|更新あり| H[一時ワークスペース作成]
    H --> I[GYP/GNファイル退避]
    I --> J{ソース取得方法}
    J -->|LOCAL_COPY| K[npm install + make release]
    J -->|フォーク指定| L[git clone + npm install + make release]
    J -->|リリースタグ| M[tarballダウンロード + 展開]
    K --> N[deps/llhttp置換]
    L --> N
    M --> N
    N --> O[GYP/GNファイル復元]
    O --> P[finalize_version_update]
    P --> Q[バッチ終了]
    G --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | tarballダウンロード失敗 | ネットワーク接続を確認 |
| 1 | ビルドエラー | npm install失敗 | 依存関係を確認 |
| 1 | ビルドエラー | make release失敗 | ビルド環境を確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. GYP/GNファイルは事前に退避されているため、失敗時も復元可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 全ファイルコピー完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | ダウンロード: 3分以内、ビルド: 10分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/llhttp/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace ..." |
| 進捗ログ | ビルドファイル退避時 | "Replacing existing llhttp (except GYP and GN build files)" |
| 進捗ログ | ダウンロード時 | "Download llhttp release X ..." |
| 進捗ログ | ビルド時 | "Building llhttp ..." |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| 処理時間 | 20分超過 | GitHub Actions |

## 備考

- 3つのソース取得方法に対応：LOCAL_COPY（ローカルディレクトリ）、フォーク（git clone）、リリースタグ（tarball）
- LOCAL_COPYは開発・デバッグ用途で使用
- フォーク指定は「ユーザー名/リポジトリ名」形式で指定
- llhttpはNode.jsプロジェクト（nodejs/llhttp）が管理しているライブラリ
- バージョン番号はllhttp.hのLLHTTP_VERSION_MAJOR/MINOR/PATCHマクロから取得
- GYP（*.gyp）とGN（*.gn、*.gni）ビルドファイルはNode.js固有のため、更新時に保持される
