# バッチ設計書 25-update-nghttp2.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるnghttp2 HTTP/2ライブラリの更新バッチ `update-nghttp2.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるnghttp2（HTTP/2実装ライブラリ）を最新バージョンに更新するためのシェルスクリプトである。nghttp2はNode.jsのHTTP/2機能を提供する重要なライブラリである。

**業務上の目的・背景**：nghttp2はHTTP/2プロトコルの実装ライブラリであり、Node.jsのhttp2モジュールの基盤となっている。HTTP/2プロトコルの仕様変更やパフォーマンス改善、セキュリティ修正を取り込むために定期的な更新が必要である。本バッチはnghttp2の更新プロセスを自動化し、Node.jsのHTTP/2機能の品質を維持するために使用される。

**バッチの実行タイミング**：nghttp2の新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してnghttp2の最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. 公式リリースからtar.xzアーカイブをダウンロード
4. PGP署名を検証（nghttp.kbxキーリングを使用）
5. lib/ディレクトリとCOPYINGファイルのみを保持、その他を削除
6. 既存のconfig.h、gyp、gnファイルを保持しつつ置換

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/nghttp2/`ディレクトリ配下のソースファイル、maintaining-dependencies.mdに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | GitHub APIおよびnghttp2リリースページへのアクセスが可能であること |
| curl | アーカイブ・署名ファイルのダウンロードに使用 |
| tar | xz形式アーカイブの展開に使用 |
| gpgv | PGP署名検証に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること
2. ダウンロードしたアーカイブのPGP署名が有効であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | nghttp2リリース情報の取得元 |
| deps/nghttp2/lib/includes/nghttp2/nghttp2ver.h | C Header | 現在のバージョン情報取得元 |
| tools/dep_updaters/nghttp.kbx | GPGキーリング | PGP署名検証用公開鍵 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/nghttp2/ | ディレクトリ | 更新されたnghttp2ソースコード |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | nghttp2ソースファイル群（lib/のみ） |
| 出力先 | deps/nghttp2/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン取得
   └─ GitHub APIで最新リリースバージョン取得
   └─ タグ名から「v」プレフィックスを除去

3. バージョン比較
   └─ nghttp2ver.hからNGHTTP2_VERSIONを取得
   └─ バージョン比較（同一ならスキップ終了）

4. 一時ワークスペース作成
   └─ mktempでディレクトリ作成
   └─ trapでクリーンアップ設定

5. ダウンロードと検証
   └─ tar.xzアーカイブをダウンロード
   └─ .ascファイル（PGP署名）をダウンロード
   └─ gpgvで署名検証（nghttp.kbx使用）

6. アーカイブ展開と整理
   └─ tar xJfでアーカイブ展開
   └─ lib/とCOPYING以外のファイル/ディレクトリを削除

7. 既存ファイル保持・復元
   └─ config.hをコピー
   └─ nghttp2.gypをコピー
   └─ GNファイル（*.gn、*.gni）をコピー

8. 置換処理
   └─ deps/nghttp2を削除
   └─ 新バージョンをdeps/nghttp2に移動

9. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub APIで最新バージョン取得]
    B --> C[nghttp2ver.hから現在バージョン取得]
    C --> D{バージョン比較}
    D -->|同一| E[スキップ終了]
    D -->|更新あり| F[一時ワークスペース作成]
    F --> G[tar.xzアーカイブダウンロード]
    G --> H[.asc署名ファイルダウンロード]
    H --> I[gpgv署名検証]
    I --> J[アーカイブ展開]
    J --> K[lib/とCOPYING以外を削除]
    K --> L[config.h/gyp/gnファイルをコピー]
    L --> M[deps/nghttp2削除]
    M --> N[新バージョンを配置]
    N --> O[finalize_version_update]
    O --> P[バッチ終了]
    E --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | アーカイブダウンロード失敗 | ネットワーク接続を確認 |
| 1 | 署名検証エラー | PGP署名検証失敗 | nghttp.kbxの更新、リリース元確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. 既存のdeps/nghttp2は新バージョンの準備完了後に削除されるため、失敗時も既存ファイルは保持される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 全ファイルコピー完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/nghttp2/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace" |
| 進捗ログ | ダウンロード時 | "Fetching nghttp2 source archive" |
| 進捗ログ | 署名検証時 | "Verifying PGP signature" |
| 進捗ログ | 展開時 | "Unpacking archive" |
| 進捗ログ | クリーンアップ時 | "Removing everything, except lib/ and COPYING" |
| 進捗ログ | ファイルコピー時 | "Copying config.h file" / "Copying existing gyp files" / "Copying existing GN files" |
| 進捗ログ | 置換時 | "Replacing existing nghttp2" |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| PGP署名検証失敗 | 発生時 | 手動確認推奨 |

## 備考

- nghttp2リリースはPGP署名されており、nghttp.kbxキーリングを使用して検証を行う
- Node.jsではnghttp2のlib/ディレクトリのみを使用するため、その他のファイル（ドキュメント、テスト等）は削除される
- config.hはNode.js固有の設定を含むため、更新時に保持される（Issue #45572参照）
- GYP（nghttp2.gyp）とGN（*.gn、*.gni）ビルドファイルもNode.js固有のため保持される
- アーカイブはtar.xz形式で配布される
