# バッチ設計書 26-update-nghttp3.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるnghttp3 HTTP/3ライブラリの更新バッチ `update-nghttp3.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるnghttp3（HTTP/3実装ライブラリ）を最新バージョンに更新するためのシェルスクリプトである。nghttp3はNode.jsの次世代HTTP/3機能を提供する重要なライブラリである。

**業務上の目的・背景**：nghttp3はHTTP/3プロトコルの実装ライブラリであり、QUICプロトコル上でのHTTP通信を可能にする。HTTP/3プロトコルの仕様変更やパフォーマンス改善、セキュリティ修正を取り込むために定期的な更新が必要である。本バッチはnghttp3の更新プロセスを自動化し、Node.jsのHTTP/3機能の品質を維持するために使用される。

**バッチの実行タイミング**：nghttp3の新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してnghttp3の最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. 公式リリースからtar.xzアーカイブをダウンロード
4. PGP署名を検証（nghttp.kbxキーリングを使用）
5. autoreconfでビルドシステムを生成
6. configureで--enable-lib-onlyオプションを使用してビルド設定
7. lib/ディレクトリをreplace_dirで置換

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。ngtcp2ディレクトリ配下のnghttp3を更新する。

**影響範囲**：`deps/ngtcp2/nghttp3/lib/`ディレクトリ配下のソースファイル、maintaining-dependencies.mdに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | GitHub APIおよびnghttp3リリースページへのアクセスが可能であること |
| curl | アーカイブ・署名ファイルのダウンロードに使用 |
| tar | xz形式アーカイブの展開に使用 |
| gpgv | PGP署名検証に使用 |
| autoreconf | ビルドシステム生成に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること
2. ダウンロードしたアーカイブのPGP署名が有効であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | nghttp3リリース情報の取得元（ngtcp2/nghttp3リポジトリ） |
| deps/ngtcp2/nghttp3/lib/includes/nghttp3/version.h | C Header | 現在のバージョン情報取得元 |
| tools/dep_updaters/nghttp.kbx | GPGキーリング | PGP署名検証用公開鍵 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/ngtcp2/nghttp3/lib/ | ディレクトリ | 更新されたnghttp3ソースコード |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | nghttp3ソースファイル群（lib/のみ） |
| 出力先 | deps/ngtcp2/nghttp3/lib/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン取得
   └─ GitHub APIでリリース一覧取得
   └─ 最新リリースのタグ名から「v」プレフィックスを除去

3. バージョン比較
   └─ version.hからNGHTTP3_VERSIONを取得
   └─ バージョン比較（同一ならスキップ終了）

4. 一時ワークスペース作成
   └─ mktempでディレクトリ作成
   └─ trapでクリーンアップ設定

5. ダウンロードと検証
   └─ tar.xzアーカイブをダウンロード
   └─ .ascファイル（PGP署名）をダウンロード
   └─ gpgvで署名検証（nghttp.kbx使用）

6. アーカイブ展開とビルド
   └─ tar xJfでアーカイブ展開
   └─ autoreconf -i でビルドシステム生成
   └─ ./configure --prefix=... --enable-lib-only 実行

7. 置換処理
   └─ replace_dirでdeps/ngtcp2/nghttp3/lib/を置換

8. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub APIでリリース一覧取得]
    B --> C[最新バージョン抽出]
    C --> D[version.hから現在バージョン取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップ終了]
    E -->|更新あり| G[一時ワークスペース作成]
    G --> H[tar.xzアーカイブダウンロード]
    H --> I[.asc署名ファイルダウンロード]
    I --> J[gpgv署名検証]
    J --> K[アーカイブ展開]
    K --> L[autoreconf -i実行]
    L --> M[configure --enable-lib-only実行]
    M --> N[replace_dirでlib/置換]
    N --> O[finalize_version_update]
    O --> P[バッチ終了]
    F --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | アーカイブダウンロード失敗 | ネットワーク接続を確認 |
| 1 | 署名検証エラー | PGP署名検証失敗 | nghttp.kbxの更新、リリース元確認 |
| 1 | ビルドエラー | autoreconf失敗 | autotools環境を確認 |
| 1 | ビルドエラー | configure失敗 | 依存関係を確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. replace_dirは既存ディレクトリを削除してから移動するため、失敗時は手動復旧が必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | replace_dir完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/ngtcp2/nghttp3/lib/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ダウンロード時 | "Fetching nghttp3 source archive..." |
| 進捗ログ | 署名検証時 | "Verifying PGP signature..." |
| 進捗ログ | 展開時 | "Unpacking archive..." |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| PGP署名検証失敗 | 発生時 | 手動確認推奨 |

## 備考

- nghttp3はngtcp2プロジェクト（ngtcp2/nghttp3）が管理しているライブラリ
- nghttp3リリースはPGP署名されており、nghttp.kbxキーリングを使用して検証を行う（nghttp2と同じ鍵を使用）
- Node.jsではnghttp3のlib/ディレクトリのみを使用
- autoreconfでビルドシステムを生成する必要がある
- configureは--enable-lib-onlyオプションでライブラリのみをビルド対象とする
- nghttp3はdeps/ngtcp2/nghttp3/配下に配置される（ngtcp2の一部として管理）
- GitHub APIはリリース一覧を取得し、最初の要素（最新）を使用する（/releases/latestではなく/releasesを使用）
