# バッチ設計書 27-update-ngtcp2.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるngtcp2 QUIC実装ライブラリの更新バッチ `update-ngtcp2.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるngtcp2（QUICプロトコル実装ライブラリ）を最新バージョンに更新するためのシェルスクリプトである。ngtcp2はNode.jsの次世代ネットワーク機能（HTTP/3、QUIC）を提供する重要なライブラリである。

**業務上の目的・背景**：ngtcp2はQUICプロトコルの実装ライブラリであり、HTTP/3の基盤となるトランスポート層を提供する。QUICプロトコルの仕様変更やパフォーマンス改善、セキュリティ修正を取り込むために定期的な更新が必要である。本バッチはngtcp2の更新プロセスを自動化し、Node.jsのQUIC機能の品質を維持するために使用される。

**バッチの実行タイミング**：ngtcp2の新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してngtcp2の最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. git cloneで最新バージョンのソースを取得
4. git submodule update --initでサブモジュールを初期化
5. autoreconfでビルドシステムを生成
6. configureで--enable-lib-onlyオプションを使用してビルド設定
7. lib/、crypto/、examples/、third-partyディレクトリを置換
8. libev依存ライブラリも更新

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/ngtcp2/ngtcp2/`ディレクトリ配下のソースファイル、maintaining-dependencies.mdに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | GitHub APIおよびngtcp2リポジトリへのアクセスが可能であること |
| git | リポジトリのclone、submodule更新に使用 |
| curl | libevダウンロードに使用 |
| tar | libevアーカイブの展開に使用 |
| autoreconf | ビルドシステム生成に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | ngtcp2リリース情報の取得元（ngtcp2/ngtcp2リポジトリ） |
| deps/ngtcp2/ngtcp2/lib/includes/ngtcp2/version.h | C Header | 現在のバージョン情報取得元 |
| https://dist.schmorp.de/libev/libev-4.33.tar.gz | tarball | libev依存ライブラリ |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/ngtcp2/ngtcp2/lib/ | ディレクトリ | ngtcp2コアライブラリ |
| deps/ngtcp2/ngtcp2/crypto/ | ディレクトリ | 暗号化関連コード |
| deps/ngtcp2/ngtcp2/examples/ | ディレクトリ | サンプルコード |
| deps/ngtcp2/ngtcp2/third-party/ | ディレクトリ | サードパーティ依存 |
| deps/ngtcp2/ngtcp2/third-party/libev/ | ディレクトリ | libevライブラリ |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ngtcp2ソースファイル群 |
| 出力先 | deps/ngtcp2/ngtcp2/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン取得
   └─ GitHub APIでリリース一覧取得
   └─ 最新リリースのタグ名から「v」プレフィックスを除去

3. バージョン比較
   └─ version.hからNGTCP2_VERSIONを取得
   └─ バージョン比較（同一ならスキップ終了）

4. 一時ワークスペース作成
   └─ mktempでディレクトリ作成
   └─ trapでクリーンアップ設定

5. ソース取得とビルド準備
   └─ git clone --depth 1 --branch vX.X.X でリポジトリ取得
   └─ git submodule update --init --recursive でサブモジュール初期化
   └─ autoreconf -i でビルドシステム生成
   └─ ./configure --prefix=... --enable-lib-only 実行

6. ディレクトリ置換
   └─ replace_dirでlib/置換
   └─ replace_dirでcrypto/置換
   └─ replace_dirでexamples/置換
   └─ replace_dirでthird-party/置換

7. libev更新
   └─ libev-4.33.tar.gzをダウンロード
   └─ アーカイブ展開
   └─ replace_dirでthird-party/libev置換

8. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub APIでリリース一覧取得]
    B --> C[最新バージョン抽出]
    C --> D[version.hから現在バージョン取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップ終了]
    E -->|更新あり| G[一時ワークスペース作成]
    G --> H[git clone --depth 1]
    H --> I[git submodule update]
    I --> J[autoreconf -i実行]
    J --> K[configure --enable-lib-only実行]
    K --> L[replace_dirでlib/置換]
    L --> M[replace_dirでcrypto/置換]
    M --> N[replace_dirでexamples/置換]
    N --> O[replace_dirでthird-party/置換]
    O --> P[libevダウンロード]
    P --> Q[libev展開・置換]
    Q --> R[finalize_version_update]
    R --> S[バッチ終了]
    F --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | git clone失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | libevダウンロード失敗 | ネットワーク接続を確認 |
| 1 | ビルドエラー | autoreconf失敗 | autotools環境を確認 |
| 1 | ビルドエラー | configure失敗 | 依存関係を確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. replace_dirは既存ディレクトリを削除してから移動するため、失敗時は手動復旧が必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 各replace_dir完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 15分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/ngtcp2/ngtcp2/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | clone時 | "Fetching ngtcp2 source archive..." |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| 処理時間 | 30分超過 | GitHub Actions |

## 備考

- ngtcp2はngtcp2プロジェクト（ngtcp2/ngtcp2）が管理しているQUIC実装ライブラリ
- git clone --depth 1を使用して浅いクローンを行うことで、ダウンロード時間を短縮
- git submodule update --init --recursiveでサブモジュールも含めて取得
- autoreconfでビルドシステムを生成する必要がある
- configureは--enable-lib-onlyオプションでライブラリのみをビルド対象とする
- Mac環境でMacPortsのlibevを使用する場合は、LDFLAGS='-L/opt/local/lib'とCPPFLAGS='-I/opt/local/include'が必要（コメント記載）
- libevはexamplesの依存ライブラリであり、バージョン4.33を固定で使用
- lib/、crypto/、examples/、third-partyの4つのディレクトリを個別に置換
- GitHub APIはリリース一覧を取得し、最初の要素（最新）を使用する（/releases/latestではなく/releasesを使用）
