# バッチ設計書 28-update-sqlite.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるSQLiteライブラリの更新バッチ `update-sqlite.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるSQLite（軽量データベースエンジン）を最新バージョンに更新するためのシェルスクリプトである。SQLiteはNode.jsの組み込みデータベース機能を提供する重要なライブラリである。

**業務上の目的・背景**：SQLiteは軽量で高性能なデータベースエンジンであり、Node.jsの内部データストレージや各種アプリケーションで使用される。SQLiteのバグ修正、パフォーマンス改善、セキュリティ修正を取り込むために定期的な更新が必要である。本バッチはSQLiteの更新プロセスを自動化し、Node.jsのデータベース機能の品質を維持するために使用される。

**バッチの実行タイミング**：SQLiteの新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. SQLite公式ダウンロードページから最新バージョン情報を取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. 一時ワークスペースを作成し、amalgamation（統合）版zipをダウンロード
4. SHA256チェックサムを検証
5. sqlite3.c、sqlite3.h、sqlite3ext.hの3ファイルをdeps/sqlite/に配置

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/sqlite/`ディレクトリ配下のsqlite3.c、sqlite3.h、sqlite3ext.hに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | SQLite公式サイトへのアクセスが可能であること |
| curl | ダウンロードページ取得、アーカイブダウンロードに使用 |
| unzip | zipアーカイブの展開に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://sqlite.org/download.html | HTML | SQLiteバージョン情報・ダウンロードURL取得元 |
| deps/sqlite/sqlite3.h | C Header | 現在のバージョン情報取得元 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/sqlite/sqlite3.c | Cソース | SQLiteコアソースコード（amalgamation） |
| deps/sqlite/sqlite3.h | Cヘッダ | SQLiteパブリックヘッダ |
| deps/sqlite/sqlite3ext.h | Cヘッダ | SQLite拡張ヘッダ |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite3.c, sqlite3.h, sqlite3ext.h |
| 出力先 | deps/sqlite/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン情報取得
   └─ SQLite公式ダウンロードページをfetch
   └─ HTMLから機械可読コメントを解析
   └─ バージョンとamalgamationパスを抽出

3. バージョン比較
   └─ sqlite3.hからSQLITE_VERSIONを取得
   └─ バージョン比較（同一ならスキップ終了）

4. 一時ワークスペース作成
   └─ mktempでディレクトリ作成
   └─ trapでクリーンアップ設定

5. ダウンロードと検証
   └─ amalgamation zipをダウンロード
   └─ SHA256チェックサム検証

6. 展開とコピー
   └─ unzip -jで展開（ディレクトリ構造を無視）
   └─ sqlite3.cをコピー
   └─ sqlite3.hをコピー
   └─ sqlite3ext.hをコピー

7. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SQLite公式サイトからHTML取得]
    B --> C[HTMLから製品情報抽出]
    C --> D[バージョン・ダウンロードパス取得]
    D --> E[sqlite3.hから現在バージョン取得]
    E --> F{バージョン比較}
    F -->|同一| G[スキップ終了]
    F -->|更新あり| H[一時ワークスペース作成]
    H --> I[amalgamation zipダウンロード]
    I --> J[SHA256検証]
    J --> K[unzip -j展開]
    K --> L[sqlite3.cコピー]
    L --> M[sqlite3.hコピー]
    M --> N[sqlite3ext.hコピー]
    N --> O[finalize_version_update]
    O --> P[バッチ終了]
    G --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | SQLite公式サイト接続失敗 | ネットワーク接続を確認 |
| 1 | パースエラー | HTMLから製品情報が見つからない | ダウンロードページの形式変更を確認 |
| 1 | チェックサムエラー | SHA256検証失敗 | 再実行、ダウンロード元確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. 既存のdeps/sqlite/ファイルは上書きされるが、失敗時は元のファイルが残る可能性がある

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルコピー操作全体 |
| コミットタイミング | 各ファイルコピー完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 3分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/sqlite/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace" |
| 進捗ログ | ダウンロード時 | "Fetching SQLITE source archive..." |
| 進捗ログ | 展開時 | "Unzipping..." |
| 進捗ログ | コピー時 | "Copying new files to deps folder" |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| HTMLパースエラー | 発生時 | 手動確認推奨 |

## 備考

- SQLiteはamalgamation（統合）版を使用（単一のsqlite3.cファイルに全ソースが統合されている）
- 公式ダウンロードページ（https://sqlite.org/download.html）には機械可読なコメントが含まれており、これをパースしてバージョン情報を取得
- コメント形式：`PRODUCT,バージョン,ダウンロードパス,`
- zipファイルは`sqlite-amalgamation-XXXXXXXX.zip`形式
- unzip -j オプションでディレクトリ構造を無視して展開
- SQLiteの3ファイル（sqlite3.c、sqlite3.h、sqlite3ext.h）のみを更新
- バージョン番号はsqlite3.hの`#define SQLITE_VERSION`から取得
