# バッチ設計書 29-update-c-ares.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるc-ares DNS解決ライブラリの更新バッチ `update-c-ares.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるc-ares（非同期DNS解決ライブラリ）を最新バージョンに更新するためのシェルスクリプトである。c-aresはNode.jsのDNS解決機能を提供する重要なライブラリである。

**業務上の目的・背景**：c-aresは非同期のDNS解決機能を提供するライブラリであり、Node.jsのdnsモジュールで使用されている。DNSプロトコルの変更やセキュリティ修正、パフォーマンス改善を取り込むために定期的な更新が必要である。本バッチはc-aresの更新プロセスを自動化し、Node.jsのDNS機能の品質を維持するために使用される。

**バッチの実行タイミング**：c-aresの新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してc-aresの最新リリースバージョンとダウンロードURLを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. 一時ワークスペースを作成し、tar.gzアーカイブをダウンロード
4. SHA256チェックサムを検証
5. テストディレクトリを削除
6. 既存の.gitignore、config/、cares.gyp、GNファイルを保持しつつ置換
7. update-c-ares.mjsでcares.gypを自動更新

**前後の処理との関連**：update-c-ares.mjsスクリプトに依存してcares.gypを更新する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/cares/`ディレクトリ配下のソースファイル、cares.gypに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理、cares.gyp更新に使用） |
| ネットワーク接続 | GitHub APIおよびc-aresリリースページへのアクセスが可能であること |
| curl | アーカイブダウンロードに使用 |
| gzip/tar | アーカイブ展開に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | c-aresリリース情報・ダウンロードURL取得元 |
| deps/cares/include/ares_version.h | C Header | 現在のバージョン情報取得元 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |
| tools/dep_updaters/update-c-ares.mjs | JavaScript | cares.gyp更新スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/cares/ | ディレクトリ | 更新されたc-aresソースコード |
| deps/cares/cares.gyp | GYPファイル | 更新されたビルド設定 |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | c-aresソースファイル群 |
| 出力先 | deps/cares/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン情報取得
   └─ GitHub APIで最新リリース情報取得
   └─ tag_name、browser_download_url、nameを抽出
   └─ .tar.gzで終わるアセットを検索

3. バージョン比較
   └─ ares_version.hからARES_VERSION_STRを取得
   └─ バージョン比較（同一ならスキップ終了）

4. 一時ワークスペース作成
   └─ mktempでディレクトリ作成
   └─ trapでクリーンアップ設定

5. ダウンロードと検証
   └─ tar.gzアーカイブをダウンロード
   └─ SHA256チェックサム検証
   └─ gzip/tarでアーカイブ展開

6. クリーンアップと保持
   └─ テストディレクトリ削除
   └─ config/ディレクトリをコピー
   └─ .gitignoreをコピー
   └─ cares.gypをコピー
   └─ GNファイル（*.gn、*.gni）をコピー

7. 置換処理
   └─ replace_dirでdeps/caresを置換

8. GYP更新
   └─ update-c-ares.mjsを実行してcares.gypを更新

9. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub APIで最新リリース取得]
    B --> C[.tar.gzアセット検索]
    C --> D[ares_version.hから現在バージョン取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップ終了]
    E -->|更新あり| G[一時ワークスペース作成]
    G --> H[tar.gzダウンロード]
    H --> I[SHA256検証]
    I --> J[アーカイブ展開]
    J --> K[testディレクトリ削除]
    K --> L[config/.gitignore/cares.gyp/GNファイルコピー]
    L --> M[replace_dirでdeps/cares置換]
    M --> N[update-c-ares.mjs実行]
    N --> O[finalize_version_update]
    O --> P[バッチ終了]
    F --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | アーカイブダウンロード失敗 | ネットワーク接続を確認 |
| 1 | パースエラー | tarballが見つからない | リリースアセット形式を確認 |
| 1 | チェックサムエラー | SHA256検証失敗 | 再実行、ダウンロード元確認 |
| 1 | GYP更新エラー | update-c-ares.mjs失敗 | スクリプトを確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. replace_dirは既存ディレクトリを削除してから移動するため、失敗時は手動復旧が必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | replace_dir完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/cares/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace" |
| 進捗ログ | ダウンロード時 | "Fetching c-ares source archive" |
| 進捗ログ | テスト削除時 | "Removing tests" |
| 進捗ログ | ファイルコピー時 | "Copying existing .gitignore, config, gyp and gn files" |
| 進捗ログ | 置換時 | "Replacing existing c-ares" |
| 進捗ログ | GYP更新時 | "Updating cares.gyp" |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |
| tarballアセット未検出 | 発生時 | 手動確認推奨 |

## 備考

- c-aresはc-ares/c-aresリポジトリで管理されている非同期DNS解決ライブラリ
- GitHub APIの/releases/latestエンドポイントを使用
- リリースアセットから.tar.gzで終わるファイルを自動検出
- テストディレクトリはNode.jsでは不要なため削除
- config/ディレクトリはプラットフォーム固有の設定を含むため保持
- cares.gypはNode.js固有のビルド設定を含むため保持
- update-c-ares.mjsはcares.gypのソースファイルリストを自動更新する
- バージョン番号はares_version.hのARES_VERSION_STRマクロから取得
