# バッチ設計書 3-Makefile

## 概要

本ドキュメントは、Node.jsプロジェクトのUnix系ビルドファイル「Makefile」の設計仕様を記載したものである。

### 本バッチの処理概要

MakefileはUnix系システム（Linux、macOS、FreeBSD等）においてNode.jsのビルド、テスト、インストール、リント、ドキュメント生成等を統合的に管理するビルドファイルである。GNU MakeまたはNinjaと連携して動作する。

**業務上の目的・背景**：Unix系環境はNode.jsの主要な開発・運用プラットフォームであり、標準的なMakeベースのビルドシステムを提供することで、開発者が慣れ親しんだ`make`コマンドでビルド操作を行えるようにしている。CI/CDパイプラインでの自動化にも適しており、再現性のあるビルドプロセスを実現する。また、多数のターゲットを提供することで、ビルド・テスト・ドキュメント生成・パッケージングなど様々な開発タスクを統一的なインターフェースで実行できる。

**バッチの実行タイミング**：開発者による手動実行（make, make test等）、またはCI/CDパイプラインでの自動実行。

**主要な処理内容**：
1. Node.js本体のコンパイル（Release/Debug）
2. ネイティブアドオンのビルドとテスト
3. テストスイートの実行（jstest、cctest、V8テスト等）
4. リント処理（C++、JavaScript、Markdown、Python、YAML）
5. ドキュメントの生成とプレビュー
6. インストールとアンインストール
7. パッケージング（tarball、binary tarball）
8. カバレッジレポートの生成
9. クリーンアップ処理

**前後の処理との関連**：configure.pyが生成したconfig.gypiとout/Makefileを使用してビルドを実行。tools/test.pyを呼び出してテストを実行し、tools/install.pyでインストールを行う。

**影響範囲**：Unix系プラットフォームでのNode.js本体、アドオン、ドキュメント、パッケージの全ての生成物に影響を与える。

## バッチ種別

ビルド / テスト / インストール / ドキュメント生成 / パッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時）/ CI/CDパイプライン実行時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行（make コマンド）/ CIジョブ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| configure済み | ./configure が実行されconfig.gypiが存在すること |
| GNU Make | GNU MakeまたはNinjaがインストールされていること |
| Python 3 | テスト実行時に必要 |
| C/C++コンパイラ | GCCまたはClangがインストールされていること |

### 実行可否判定

- config.gypiが存在しない場合、configureを実行するよう促すメッセージを表示
- 必要なツールが見つからない場合は警告を表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BUILDTYPE | 環境変数 | No | Release | ビルドタイプ（Release/Debug） |
| JOBS / -j | 環境変数/引数 | No | CPU数 | 並列ジョブ数 |
| V | 環境変数 | No | 0 | 詳細出力（1で有効） |
| PREFIX | 環境変数 | No | /usr/local | インストール先プレフィックス |
| DESTDIR | 環境変数 | No | - | パッケージング用インストール先 |
| TEST_CI_ARGS | 環境変数 | No | - | CIテスト用追加引数 |
| FLAKY_TESTS | 環境変数 | No | run | フレーキーテストの扱い |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| config.gypi | GYPi形式 | ビルド設定 |
| out/Makefile | Makefile | GYP生成ビルドファイル |
| ソースコード | ファイル | Node.jsソースコード一式 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out/Release/node | 実行ファイル | Node.js本体（Release） |
| out/Debug/node | 実行ファイル | Node.js本体（Debug） |
| node | シンボリックリンク | out/Release/nodeへのリンク |
| out/doc/api/ | HTML/JSON | APIドキュメント |
| node-v*.tar.gz | アーカイブ | ソースtarball |
| node-v*-*.tar.gz | アーカイブ | バイナリtarball |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | node-v{VERSION}-{PLATFORM}-{ARCH}.tar.{gz,xz} |
| 出力先 | プロジェクトルート |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. ターゲット解析
   └─ makeコマンドで指定されたターゲットを解析
2. 依存関係解決
   └─ ターゲットの依存関係を解決
3. config.gypi確認
   └─ 設定ファイルの存在と整合性を確認
4. ビルド実行
   └─ out/Makefileを呼び出してコンパイル
5. リンク作成
   └─ node実行ファイルへのシンボリックリンクを作成
6. 後処理
   └─ ターゲット固有の後処理を実行
```

### フローチャート

```mermaid
flowchart TD
    A[make実行] --> B{ターゲット?}
    B -->|all| C[ビルド実行]
    B -->|test| D[ビルド後テスト実行]
    B -->|install| E[ビルド後インストール]
    B -->|clean| F[クリーンアップ]
    B -->|doc| G[ドキュメント生成]
    C --> H[シンボリックリンク作成]
    D --> I[test.py実行]
    E --> J[install.py実行]
    H --> K[完了]
    I --> K
    J --> K
    F --> K
    G --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 設定エラー | config.gypiが存在しない | ./configure を実行 |
| 1 | ビルドエラー | コンパイル失敗 | エラーメッセージを確認して修正 |
| 1 | テストエラー | テスト失敗 | 失敗したテストを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- `make clean`で中間ファイルを削除して再ビルド
- `make distclean`で設定ファイルを含めて完全クリーン
- `make testclean`でテスト一時ファイルを削除

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド |
| 目標処理時間 | 環境依存 |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの複数同時実行は非推奨。ビルド成果物が競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | ビルド中 | コンパイラ出力 |
| テストログ | テスト実行時 | テスト結果（test.tap） |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |

## 備考

### 主要なMakeターゲット一覧

| ターゲット | 説明 |
|-----------|------|
| all | デフォルト。Node.jsをビルド |
| test | ビルド後、全テストを実行 |
| test-only | リンターやドキュメントビルドなしでテスト |
| install | システムにインストール |
| uninstall | システムからアンインストール |
| clean | ビルド成果物を削除 |
| distclean | 設定ファイル含め完全削除 |
| doc | ドキュメントをビルド |
| lint | 全リンターを実行 |
| lint-cpp | C++コードをリント |
| lint-js | JavaScriptコードをリント |
| lint-md | Markdownをリント |
| coverage | カバレッジテストを実行 |
| binary | バイナリtarballを作成 |
| tar | ソースtarballを作成 |
| cctest | C++ユニットテストを実行 |
