# バッチ設計書 30-update-brotli.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるBrotli圧縮ライブラリの更新バッチ `update-brotli.sh` の設計仕様を定義するものである。

### 本バッチの処理概要

本バッチは、Node.jsの依存ライブラリであるBrotli（圧縮アルゴリズムライブラリ）を最新バージョンに更新するためのシェルスクリプトである。BrotliはNode.jsのzlibモジュールで使用される高効率な圧縮アルゴリズムである。

**業務上の目的・背景**：BrotliはGoogleが開発した高圧縮率の圧縮アルゴリズムであり、HTTP圧縮などで広く使用されている。Node.jsではzlibモジュールを通じてBrotli圧縮・展開機能を提供している。パフォーマンス改善やセキュリティ修正を取り込むために定期的な更新が必要である。本バッチはBrotliの更新プロセスを自動化し、Node.jsの圧縮機能の品質を維持するために使用される。

**バッチの実行タイミング**：Brotliの新バージョンリリース時、またはGitHub Actionsによる自動実行で随時実行される。

**主要な処理内容**：
1. GitHub APIを使用してBrotliの最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新の必要性を判定
3. 一時ワークスペースを作成し、tar.gzアーカイブをダウンロード
4. SHA256チェックサムを検証
5. 既存のbrotli.gypとGNファイルを保持
6. c/ディレクトリとLICENSEファイルのみをコピー

**前後の処理との関連**：本バッチ単独で完結する。maintaining-dependencies.mdのバージョン情報も自動更新される。

**影響範囲**：`deps/brotli/`ディレクトリ配下のc/ディレクトリ、LICENSEファイルに影響する。

## バッチ種別

依存関係更新（外部ライブラリソース更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsがインストールされていること（バージョン取得処理に使用） |
| ネットワーク接続 | GitHub APIおよびBrotliリリースページへのアクセスが可能であること |
| curl | アーカイブダウンロードに使用 |
| gzip/tar | アーカイブ展開に使用 |
| GITHUB_TOKEN（オプション） | GitHub APIのレート制限回避に使用 |

### 実行可否判定

1. 現在のバージョンと最新バージョンが異なること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | Node.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | Brotliリリース情報の取得元 |
| deps/brotli/c/common/version.h | C Header | 現在のバージョン情報取得元 |
| tools/dep_updaters/utils.sh | Shell Script | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/brotli/c/ | ディレクトリ | Brotli Cソースコード |
| deps/brotli/LICENSE | テキスト | ライセンスファイル |
| deps/brotli/brotli.gyp | GYPファイル | ビルド設定（保持） |
| deps/brotli/*.gn, *.gni | GNファイル | ビルド設定（保持） |
| 標準出力 | テキスト | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Brotliソースファイル群（c/のみ） |
| 出力先 | deps/brotli/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ BASE_DIR、DEPS_DIR変数の設定
   └─ NODE変数の設定
   └─ utils.shの読み込み

2. バージョン取得
   └─ GitHub APIで最新リリース情報取得
   └─ タグ名から「v」プレフィックスを除去

3. バージョン比較
   └─ version.hからMAJOR/MINOR/PATCHバージョン取得
   └─ バージョン比較（同一ならスキップ終了）

4. 一時ワークスペース作成
   └─ mktempでディレクトリ作成
   └─ trapでクリーンアップ設定

5. ダウンロードと検証
   └─ tar.gzアーカイブをダウンロード
   └─ SHA256チェックサム検証
   └─ gzip/tarでアーカイブ展開

6. 既存ファイル保持
   └─ brotli.gypをコピー
   └─ GNファイル（*.gn、*.gni）をコピー

7. 置換処理
   └─ deps/brotli削除
   └─ deps/brotli作成（空ディレクトリ）
   └─ GNファイル、c/、LICENSE、brotli.gypを移動

8. 完了処理
   └─ finalize_version_update呼び出し
   └─ NEW_VERSION出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub APIで最新バージョン取得]
    B --> C[version.hから現在バージョン取得]
    C --> D{バージョン比較}
    D -->|同一| E[スキップ終了]
    D -->|更新あり| F[一時ワークスペース作成]
    F --> G[tar.gzダウンロード]
    G --> H[SHA256検証]
    H --> I[アーカイブ展開]
    I --> J[brotli.gyp保持コピー]
    J --> K[GNファイル保持コピー]
    K --> L[deps/brotli削除]
    L --> M[deps/brotli作成（空）]
    M --> N[GNファイル/c/LICENSE/brotli.gyp移動]
    N --> O[finalize_version_update]
    O --> P[バッチ終了]
    E --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub API接続失敗 | ネットワーク接続を確認 |
| 1 | ネットワークエラー | アーカイブダウンロード失敗 | ネットワーク接続を確認 |
| 1 | チェックサムエラー | SHA256検証失敗 | 再実行、ダウンロード元確認 |
| 0 | スキップ | バージョン同一 | 正常終了（更新不要） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトはset -eにより、エラー発生時に即座に終了する
2. trapによるクリーンアップで一時ワークスペースが自動削除される
3. deps/brotli削除後にエラーが発生した場合、ディレクトリが空になる可能性がある

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 全ファイル移動完了時 |
| ロールバック条件 | set -eによりエラー発生時は中断（自動ロールバックなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1バージョン更新 |
| 目標処理時間 | 3分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一環境での同時実行は想定していない。一時ワークスペースは別々に作成されるが、deps/brotli/への書き込みで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バージョン比較時 | "Comparing X with Y" |
| 進捗ログ | ワークスペース作成時 | "Making temporary workspace" |
| 進捗ログ | ダウンロード時 | "Fetching brotli source archive" |
| 進捗ログ | GYPファイルコピー時 | "Copying existing gyp file" |
| 進捗ログ | GNファイルコピー時 | "Copying existing GN files" |
| 進捗ログ | 削除時 | "Deleting existing brotli" |
| 進捗ログ | 更新時 | "Update c and LICENSE" |
| バージョンログ | 最終行 | "NEW_VERSION=X.X.X" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | exit code != 0 | GitHub Actions |

## 備考

- BrotliはGoogleが開発した圧縮アルゴリズムライブラリ（google/brotliリポジトリ）
- Node.jsではBrotliのCソースコード（c/ディレクトリ）のみを使用
- バージョン番号はversion.hのBROTLI_VERSION_MAJOR/MINOR/PATCHマクロから取得
- brotli.gypとGNファイル（*.gn、*.gni）はNode.js固有のビルド設定のため保持
- リリースタグは「vX.X.X」形式
- deps/brotli削除後に空ディレクトリを作成してからファイルを配置する方式を採用
- LICENSEファイルはライセンス要件のため必ず含める
