# バッチ設計書 39-update-histogram.sh

## 概要

本ドキュメントは、Node.jsプロジェクトの依存ライブラリであるHdrHistogram_cヒストグラムライブラリを最新バージョンに更新するシェルスクリプト `update-histogram.sh` の設計仕様を記述したものである。

### 本バッチの処理概要

本バッチは、高精度ヒストグラム（HdrHistogram）のC言語実装ライブラリであるHdrHistogram_cをNode.jsの依存ライブラリとして最新バージョンに更新する処理を自動化するものである。

**業務上の目的・背景**：Node.jsはパフォーマンス測定やレイテンシ分析においてHdrHistogramライブラリを活用している。精度の向上、バグ修正、パフォーマンス改善などの理由から、定期的に最新バージョンへの追従が必要である。手動での更新作業は煩雑でエラーが発生しやすいため、自動化スクリプトによって一貫した更新プロセスを提供する。

**バッチの実行タイミング**：手動実行または依存関係更新のCI/CDパイプラインからトリガーされる。新バージョンがリリースされた際に開発者が必要に応じて実行する。

**主要な処理内容**：
1. GitHub APIを使用してHdrHistogram_cの最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新が必要か判定
3. 一時ワークスペースを作成してソースアーカイブをダウンロード
4. SHA256チェックサムの検証を実施
5. 必要なヘッダーファイルとソースファイルのみを選択的にコピー
6. maintaining-dependencies.mdのバージョン情報を更新

**前後の処理との関連**：本バッチは単独で実行可能であるが、更新後はNode.js全体のビルドとテストが必要となる。更新結果はGitコミットとして記録され、PRを通じてレビューされる。

**影響範囲**：`deps/histogram/include/hdr/` および `deps/histogram/src/` ディレクトリ配下のファイル、`doc/contributing/maintaining/maintaining-dependencies.md` のバージョン記載に影響を与える。

## バッチ種別

依存関係更新 / ライブラリ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（新バージョンリリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | `out/Release/node` または `node` コマンドが利用可能であること |
| ネットワーク接続 | GitHub API および GitHubリリースページへのアクセスが可能であること |
| utils.sh | `tools/dep_updaters/utils.sh` が存在すること |
| curl | curlコマンドが利用可能であること |
| gzip/tar | gzip および tar コマンドが利用可能であること |

### 実行可否判定

GitHub APIから取得した最新バージョンと `deps/histogram/include/hdr/hdr_histogram_version.h` に定義されている現在のバージョン（HDR_HISTOGRAM_VERSION）を比較する。バージョンが同一の場合はスクリプトを終了し、異なる場合は更新処理を続行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | `$BASE_DIR/out/Release/node` または `node` | 使用するNode.js実行ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | `https://api.github.com/repos/HdrHistogram/HdrHistogram_c/releases/latest` から最新バージョン情報を取得 |
| deps/histogram/include/hdr/hdr_histogram_version.h | C Header | 現在のバージョン情報（HDR_HISTOGRAM_VERSION）を取得 |
| GitHub Releases | tar.gz | `https://github.com/HdrHistogram/HdrHistogram_c/archive/refs/tags/{VERSION}.tar.gz` からソースアーカイブを取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/histogram/include/hdr/hdr_histogram_version.h | C Header | バージョン定義ヘッダー |
| deps/histogram/include/hdr/hdr_histogram.h | C Header | メインヘッダーファイル |
| deps/histogram/src/hdr_atomic.h | C Header | アトミック操作ヘッダー |
| deps/histogram/src/hdr_malloc.h | C Header | メモリ割り当てヘッダー |
| deps/histogram/src/hdr_tests.h | C Header | テストヘッダー |
| deps/histogram/src/hdr_histogram.c | C Source | メイン実装ファイル |
| 標準出力 | テキスト | `NEW_VERSION={version}` の形式で新バージョンを出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | hdr_histogram関連のソース・ヘッダーファイル |
| 出力先 | deps/histogram/include/hdr/、deps/histogram/src/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ BASE_DIR, DEPS_DIR, NODE変数の設定
   └─ utils.shの読み込み
2. 最新バージョン取得
   └─ GitHub APIでHdrHistogram/HdrHistogram_cの最新リリースを取得
   └─ tag_nameから'v'プレフィックスを除去してバージョン番号を取得
3. 現在バージョン取得
   └─ deps/histogram/include/hdr/hdr_histogram_version.hからHDR_HISTOGRAM_VERSIONを抽出
4. バージョン比較
   └─ compare_dependency_version関数でバージョンを比較
   └─ 同一の場合はスクリプト終了
5. 一時ワークスペース作成
   └─ mktemp -dで一時ディレクトリを作成
   └─ trapでクリーンアップ関数を設定
6. ソースアーカイブダウンロード
   └─ curlでtar.gzファイルをダウンロード
7. チェックサム検証
   └─ SHA256チェックサムを検証
8. アーカイブ展開
   └─ gzip -dc と tar xf で展開
9. ヘッダーファイル配置
   └─ include/hdr/hdr_histogram_version.hをコピー
   └─ include/hdr/hdr_histogram.hをコピー
10. ソースファイル配置
    └─ src/hdr_atomic.hをコピー
    └─ src/hdr_malloc.hをコピー
    └─ src/hdr_tests.hをコピー
    └─ src/hdr_histogram.cをコピー
11. バージョン情報更新
    └─ finalize_version_update関数でドキュメント更新
    └─ 新バージョンを標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数・utils.sh読み込み]
    B --> C[GitHub APIで最新バージョン取得]
    C --> D[現在バージョンをhdr_histogram_version.hから取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップして終了]
    E -->|異なる| G[一時ワークスペース作成]
    G --> H[tar.gzダウンロード]
    H --> I[SHA256チェックサム検証]
    I --> J[アーカイブ展開]
    J --> K[histogramディレクトリにリネーム]
    K --> L[ヘッダーファイルコピー]
    L --> M[ソースファイルコピー]
    M --> N[バージョン情報更新]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | GitHub APIへの接続失敗 | ネットワーク接続を確認し、再実行 |
| 1 | API エラー | GitHub APIがエラーレスポンスを返却 | 時間をおいて再実行（レート制限の可能性） |
| 1 | チェックサムエラー | SHA256検証失敗 | ダウンロードを再試行、ファイル破損を確認 |
| 1 | ファイル操作エラー | ファイルコピー失敗 | 権限を確認し、手動でクリーンアップ後に再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトは `set -e` によりエラー発生時に即座に終了する
2. 一時ワークスペースは `trap cleanup INT TERM EXIT` により自動クリーンアップされる
3. 失敗した場合は `deps/histogram/` ディレクトリの状態を確認し、必要に応じてgit checkoutで復元する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作） |
| コミットタイミング | N/A |
| ロールバック条件 | スクリプト失敗時はgit checkoutで復元可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1ライブラリを更新 |
| 目標処理時間 | 数分以内（ネットワーク速度に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一のdeps/histogramディレクトリに対する同時実行は想定されていない。複数プロセスからの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理ステップ | "Making temporary workspace", "Fetching histogram source archive" 等 |
| 比較ログ | バージョン比較時 | "Comparing {new_version} with {current_version}" |
| スキップログ | バージョン同一時 | "Skipped because histogram is on the latest version." |
| 完了ログ | 処理完了時 | "All done!" および gitコマンド例 |
| バージョンログ | 最終行 | "NEW_VERSION={version}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム通知 |
| GitHub APIレート制限 | 残り回数が少ない場合 | 時間をおいて再実行 |

## 備考

- HdrHistogramは高精度ヒストグラムのC言語実装であり、レイテンシ測定などに使用される
- 本スクリプトはGITHUB_TOKENによる認証を使用していないため、GitHub APIのレート制限に注意が必要
- 全てのファイルをコピーするのではなく、必要なファイルのみを選択的にコピーしている
  - ヘッダー: hdr_histogram_version.h, hdr_histogram.h
  - ソース: hdr_atomic.h, hdr_malloc.h, hdr_tests.h, hdr_histogram.c
- 更新後は `git add -A deps/histogram && git commit -m "deps: update histogram to {version}"` でコミットする
