# バッチ設計書 4-install.py

## 概要

本ドキュメントは、Node.jsプロジェクトのインストールスクリプト「tools/install.py」の設計仕様を記載したものである。

### 本バッチの処理概要

install.pyは、ビルドされたNode.jsバイナリ、ヘッダファイル、npm、corepack、ドキュメント等をシステムにインストールするためのPythonスクリプトである。また、アンインストール機能も提供する。

**業務上の目的・背景**：Node.jsをソースからビルドした後、システム全体で利用可能にするためにはバイナリやライブラリを適切なディレクトリ（/usr/local/bin等）に配置する必要がある。このスクリプトは、プラットフォーム固有のインストールパスや共有ライブラリの配置を適切に処理し、ネイティブアドオン開発に必要なヘッダファイルもインストールする。パッケージングツールとの連携のため、DESTDIRをサポートしてステージングディレクトリへのインストールも可能である。

**バッチの実行タイミング**：`make install`コマンド実行時にMakefileから呼び出される。手動で直接実行することも可能。

**主要な処理内容**：
1. node実行ファイルのインストール
2. 共有ライブラリ（libnode）のインストール（--shared指定時）
3. npmパッケージのインストール
4. corepackパッケージのインストール
5. ヘッダファイルのインストール（V8、libuv、OpenSSL、zlib等）
6. manページのインストール
7. デバッグツール（gdbinit、lldb_commands.py）のインストール
8. シンボリックリンクの作成（npm、npx、corepack）

**前後の処理との関連**：Makefileの`install`ターゲットから呼び出され、config.gypiから設定を読み込む。vcbuild.batからもパッケージング時に呼び出される。

**影響範囲**：システムディレクトリ（PREFIX配下）へのファイル配置、シンボリックリンクの作成に影響を与える。

## バッチ種別

インストール / アンインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（インストール時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | make install / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド済み | Node.jsがビルドされていること |
| config.gypi | 設定ファイルが存在すること |
| 書き込み権限 | インストール先への書き込み権限があること |

### 実行可否判定

- config.gypiが存在しない場合はエラー
- インストール先への書き込み権限がない場合はエラー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| command | 文字列 | Yes | - | install または uninstall |
| --dest-dir | 文字列 | No | カレントディレクトリ | パッケージング用プレフィックス（DESTDIR） |
| --prefix | 文字列 | No | /usr/local | インストール先プレフィックス |
| --headers-only | フラグ | No | - | ヘッダファイルのみインストール |
| --root-dir | 文字列 | No | カレントディレクトリ | ソースコードのルートディレクトリ |
| --build-dir | 文字列 | No | out/Release | ビルド成果物のディレクトリ |
| --v8-dir | 文字列 | No | deps/v8 | V8ソースディレクトリ |
| --config-gypi-path | 文字列 | No | config.gypi | 設定ファイルのパス |
| --silent | フラグ | No | - | ログ出力を抑制 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| config.gypi | GYPi形式 | ビルド設定 |
| out/Release/node | 実行ファイル | Node.jsバイナリ |
| deps/npm/ | ディレクトリ | npmパッケージ |
| deps/corepack/ | ディレクトリ | corepackパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| PREFIX/bin/node | 実行ファイル | Node.js本体 |
| PREFIX/bin/npm | シンボリックリンク | npmへのリンク |
| PREFIX/bin/npx | シンボリックリンク | npxへのリンク |
| PREFIX/bin/corepack | シンボリックリンク | corepackへのリンク |
| PREFIX/lib/node_modules/npm | ディレクトリ | npmパッケージ |
| PREFIX/lib/node_modules/corepack | ディレクトリ | corepackパッケージ |
| PREFIX/include/node/ | ディレクトリ | ヘッダファイル |
| PREFIX/share/man/man1/node.1 | ファイル | manページ |
| PREFIX/share/doc/node/ | ディレクトリ | ドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（node、npm等） |
| 出力先 | DESTDIR + PREFIX |
| 文字コード | バイナリ/UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ argparseでコマンドライン引数を解析
2. 設定読み込み
   └─ config.gypiから設定を読み込み
3. インストールパス計算
   └─ DESTDIR + PREFIXからインストール先を決定
4. ファイルインストール
   └─ headers-onlyの場合はヘッダのみ、それ以外は全ファイル
5. npmインストール
   └─ deps/npm配下のファイルをコピー
6. corepackインストール
   └─ deps/corepack配下のファイルをコピー
7. シンボリックリンク作成
   └─ npm、npx、corepackへのリンクを作成
8. ヘッダインストール
   └─ V8、libuv、OpenSSL等のヘッダをコピー
```

### フローチャート

```mermaid
flowchart TD
    A[install.py開始] --> B[引数解析]
    B --> C[config.gypi読み込み]
    C --> D{headers-only?}
    D -->|Yes| E[ヘッダファイルインストール]
    D -->|No| F[nodeバイナリインストール]
    F --> G{node_shared?}
    G -->|Yes| H[共有ライブラリインストール]
    G -->|No| I[npmインストール]
    H --> I
    I --> J[corepackインストール]
    J --> K[シンボリックリンク作成]
    K --> E
    E --> L[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正なコマンド指定 | install または uninstall を指定 |
| 1 | ファイルエラー | コピー/削除失敗 | 権限を確認 |
| RuntimeError | 設定エラー | 必要な設定が不足 | config.gypiを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- 権限エラーの場合はsudo付きで再実行
- 中途半端なインストール状態は`make uninstall`でクリーン

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（uninstallで手動ロールバック） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のインストール |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一インストール先への複数同時実行は非推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ファイル処理時 | installing {path} |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元 |

## 備考

- OpenBSDではmanページが`man/man1/`に配置される（他は`share/man/man1/`）
- z/OSでは追加のシンボリックリンク（node-gyp、libnode.x）が作成される
- AIX/OS400ではnode.expファイルもインストールされる
- npmが既にシンボリックリンクとしてインストールされている場合はスキップ（開発版npm対応）
