# バッチ設計書 40-update-postject.sh

## 概要

本ドキュメントは、Node.jsプロジェクトの依存ライブラリであるpostject SEA（Single Executable Application）インジェクターを最新バージョンに更新するシェルスクリプト `update-postject.sh` の設計仕様を記述したものである。

### 本バッチの処理概要

本バッチは、Node.jsのSingle Executable Application機能で使用されるpostjectライブラリを最新バージョンに更新する処理を自動化するものである。

**業務上の目的・背景**：Node.jsはSingle Executable Application（SEA）機能においてpostjectライブラリを使用して、実行ファイルにリソースを埋め込む処理を行っている。SEA機能の改善、バグ修正、新しいプラットフォームへの対応などの理由から、定期的に最新バージョンへの追従が必要である。手動での更新作業は煩雑でエラーが発生しやすいため、自動化スクリプトによって一貫した更新プロセスを提供する。

**バッチの実行タイミング**：手動実行または依存関係更新のCI/CDパイプラインからトリガーされる。新バージョンがリリースされた際に開発者が必要に応じて実行する。

**主要な処理内容**：
1. npm registryを使用してpostjectの最新バージョンを取得
2. 現在のバージョンと比較し、更新が必要か判定
3. 一時ワークスペースを作成してnpm installでパッケージをインストール
4. 既存のGNビルドファイルを保持しつつ、ライブラリファイルを置換
5. LICENSEとpostject-api.hのみを抽出
6. maintaining-dependencies.mdのバージョン情報を更新

**前後の処理との関連**：本バッチは単独で実行可能であるが、更新後はNode.js全体のビルドとテストが必要となる。更新結果はGitコミットとして記録され、PRを通じてレビューされる。

**影響範囲**：`deps/postject/` ディレクトリ配下のファイル、`doc/contributing/maintaining/maintaining-dependencies.md` のバージョン記載に影響を与える。

## バッチ種別

依存関係更新 / ライブラリ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（新バージョンリリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | `out/Release/node` または `node` コマンドが利用可能であること |
| npm | `deps/npm/bin/npm-cli.js` が存在すること |
| ネットワーク接続 | npm registryへのアクセスが可能であること |
| utils.sh | `tools/dep_updaters/utils.sh` が存在すること |

### 実行可否判定

npm viewで取得した最新バージョン（dist-tags.latest）と `test/fixtures/postject-copy/node_modules/postject/package.json` に定義されている現在のバージョンを比較する。バージョンが同一の場合はスクリプトを終了し、異なる場合は更新処理を続行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | `$BASE_DIR/out/Release/node` または `node` | 使用するNode.js実行ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| npm registry | JSON | `npm view postject dist-tags.latest` から最新バージョン情報を取得 |
| test/fixtures/postject-copy/node_modules/postject/package.json | JSON | 現在のバージョン情報を取得 |
| npm install | npmパッケージ | `npm install postject@{VERSION}` でパッケージをインストール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/postject/LICENSE | テキスト | MITライセンスファイル |
| deps/postject/postject-api.h | C Header | postject APIヘッダーファイル |
| deps/postject/*.gn, *.gni | GN | GNビルドファイル（既存を維持） |
| 標準出力 | テキスト | `NEW_VERSION={version}` の形式で新バージョンを出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | LICENSE, postject-api.h |
| 出力先 | deps/postject/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ BASE_DIR, DEPS_DIR, NODE, NPM変数の設定
   └─ utils.shの読み込み
2. 最新バージョン取得
   └─ npm view postject dist-tags.latestで最新バージョンを取得
3. 現在バージョン取得
   └─ test/fixtures/postject-copy/node_modules/postject/package.jsonからバージョンを取得
4. バージョン比較
   └─ compare_dependency_version関数でバージョンを比較
   └─ 同一の場合はスクリプト終了
5. 一時ワークスペース作成
   └─ mktemp -dで一時ディレクトリを作成
   └─ trapでクリーンアップ関数を設定
6. パッケージ初期化・インストール
   └─ npm init --yesでpackage.jsonを作成
   └─ npm install --no-bin-links --ignore-scripts postject@{VERSION}
7. GNビルドファイル保持
   └─ 既存の*.gn, *.gniをワークスペースに移動
8. 既存ディレクトリ削除・再作成
   └─ deps/postjectを削除
   └─ deps/postjectを作成
9. ファイル配置
   └─ GNビルドファイルを復元
   └─ node_modules/postject/LICENSEを配置
   └─ node_modules/postject/dist/postject-api.hを配置
10. バージョン情報更新
    └─ finalize_version_update関数でドキュメント更新
    └─ 新バージョンを標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数・utils.sh読み込み]
    B --> C[npm viewで最新バージョン取得]
    C --> D[現在バージョンをpackage.jsonから取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップして終了]
    E -->|異なる| G[一時ワークスペース作成]
    G --> H[npm init]
    H --> I[npm installでパッケージインストール]
    I --> J[既存GNファイル保持]
    J --> K[deps/postject削除・再作成]
    K --> L[GNファイル復元]
    L --> M[LICENSE配置]
    M --> N[postject-api.h配置]
    N --> O[バージョン情報更新]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | npm registryへの接続失敗 | ネットワーク接続を確認し、再実行 |
| 1 | npm エラー | npm install失敗 | npmキャッシュをクリアして再実行 |
| 1 | ファイル操作エラー | ディレクトリ作成・削除失敗 | 権限を確認し、手動でクリーンアップ後に再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. スクリプトは `set -ex` によりエラー発生時に即座に終了し、実行コマンドを表示する
2. 一時ワークスペースは `trap cleanup INT TERM EXIT` により自動クリーンアップされる
3. 失敗した場合は `deps/postject/` ディレクトリの状態を確認し、必要に応じてgit checkoutで復元する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作） |
| コミットタイミング | N/A |
| ロールバック条件 | スクリプト失敗時はgit checkoutで復元可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1ライブラリを更新 |
| 目標処理時間 | 数分以内（ネットワーク速度に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一のdeps/postjectディレクトリに対する同時実行は想定されていない。複数プロセスからの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行コマンドログ | 各コマンド実行時 | set -xにより実行コマンドを表示 |
| 進捗ログ | 各処理ステップ | "Making temporary workspace...", "Installing postject npm package...", "Replacing existing postject" 等 |
| 比較ログ | バージョン比較時 | "Comparing {new_version} with {current_version}" |
| スキップログ | バージョン同一時 | "Skipped because postject is on the latest version." |
| 完了ログ | 処理完了時 | "All done!" および gitコマンド例 |
| バージョンログ | 最終行 | "NEW_VERSION={version}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム通知 |

## 備考

- postjectはNode.jsのSingle Executable Application（SEA）機能で使用されるリソースインジェクターである
- npm installで取得するが、deps/postjectにはLICENSEとpostject-api.hのみを配置する
- npm installオプション：`--no-bin-links --ignore-scripts` でバイナリリンク作成とスクリプト実行をスキップ
- 現在のバージョンはdeps/postjectではなくtest/fixtures/postject-copy/node_modules/postject/から取得する点に注意
- GNビルドファイルはNode.js固有のカスタマイズが含まれるため、更新時に保持される
- 更新後は `git add -A deps/postject && git commit -m "deps: update postject to {version}"` でコミットする
