# バッチ設計書 42-update-nbytes.sh

## 概要

本ドキュメントは、Node.jsプロジェクトの依存関係であるnbytes（バイト操作ライブラリ）を最新バージョンに更新するシェルスクリプト `update-nbytes.sh` の設計書です。

### 本バッチの処理概要

このバッチは、Node.jsで使用されるバイト操作ユーティリティライブラリnbytesを、GitHub上の最新リリースバージョンに自動更新します。

**業務上の目的・背景**：nbytesはNode.jsの内部でバイトデータの操作に使用されるC++ヘッダーライブラリです。バッファ操作やエンコーディング処理において効率的なバイト操作を提供します。セキュリティ修正やパフォーマンス改善に対応するため、定期的な更新が必要です。自動化されたスクリプトにより、手動作業のミスを防ぎ、一貫した更新プロセスを実現します。

**バッチの実行タイミング**：随時実行（新バージョンリリース時）または定期的なメンテナンス時に手動実行されます。GitHub Actionsによる自動実行も可能です。

**主要な処理内容**：
1. GitHub APIを使用してnbytesの最新リリースバージョンを取得
2. 現在のバージョンと比較し、更新が必要かどうかを判定
3. 一時ワークスペースを作成し、最新ソースアーカイブをダウンロード
4. SHA256チェックサムでアーカイブの整合性を検証
5. GYP/GNビルドファイルとREADMEを保持しながら既存ディレクトリを置換
6. `maintaining-dependencies.md`のバージョン情報を更新

**前後の処理との関連**：このバッチは単独で実行可能ですが、更新後はNode.jsのビルド（`make`または`vcbuild.bat`）が必要です。

**影響範囲**：`deps/nbytes`ディレクトリ全体、`doc/contributing/maintaining/maintaining-dependencies.md`

## バッチ種別

依存関係更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | スクリプト実行にNode.jsが必要（ビルド済みまたはシステムインストール） |
| curl | ソースアーカイブのダウンロードに必要 |
| gzip | tarballの展開に必要 |
| tar | アーカイブの展開に必要 |
| shasum | チェックサム検証に必要 |
| GITHUB_TOKEN（任意） | API レート制限を緩和するための認証トークン |

### 実行可否判定

GitHub APIから取得した最新バージョンと、`deps/nbytes/nbytes.h`内の`NBYTES_VERSION`マクロを比較し、バージョンが異なる場合のみ更新処理を実行します。同一バージョンの場合はスクリプトを終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NODE | 環境変数 | No | out/Release/node または system node | 使用するNode.js実行ファイルのパス |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub API認証用トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | JSON | `https://api.github.com/repos/nodejs/nbytes/releases/latest` から最新バージョン情報を取得 |
| deps/nbytes/nbytes.h | C Header | 現在のnbytesバージョン情報を取得 |
| GitHub Tarball | tar.gz | `https://api.github.com/repos/nodejs/nbytes/tarball/v{version}` からソースアーカイブを取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/nbytes/ | Directory | 更新されたnbytesソースコード |
| 標準出力 | Text | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | deps/nbytes/配下の全ファイル |
| 出力先 | プロジェクトルート/deps/nbytes/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境変数・パス設定
   └─ BASE_DIR、DEPS_DIR、NODEパスを設定
2. utils.shの読み込み
   └─ 共通ユーティリティ関数をロード
3. 最新バージョン取得
   └─ GitHub APIを使用してnbytesの最新リリースタグを取得
4. 現在バージョン取得
   └─ nbytes.hからNBYTES_VERSIONマクロの値を抽出
5. バージョン比較
   └─ compare_dependency_version関数で新旧バージョンを比較
6. 一時ワークスペース作成
   └─ mktemp -dで一時ディレクトリを作成
7. クリーンアップ関数設定
   └─ trapでINT/TERM/EXIT時の後処理を登録
8. ソースアーカイブダウンロード
   └─ curlでtar.gzファイルをダウンロード
9. チェックサム検証
   └─ log_and_verify_sha256sum関数でアーカイブの整合性を検証
10. アーカイブ展開
    └─ gzip -dc と tar xf でソースを展開
11. ビルドファイル移動
    └─ *.gyp、*.gn、*.gni、README.mdを新ディレクトリに移動
12. ディレクトリ置換
    └─ 既存のdeps/nbytesを削除し、新しいソースで置換
13. バージョン情報更新
    └─ finalize_version_update関数でドキュメント更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境設定]
    B --> C[GitHub APIで最新バージョン取得]
    C --> D[nbytes.hから現在バージョン取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップして終了]
    E -->|異なる| G[一時ワークスペース作成]
    G --> H[ソースアーカイブダウンロード]
    H --> I[SHA256チェックサム検証]
    I --> J{検証成功?}
    J -->|No| K[エラー終了]
    J -->|Yes| L[アーカイブ展開]
    L --> M[ビルドファイル・README移動]
    M --> N[既存ディレクトリ削除]
    N --> O[新ソースを配置]
    O --> P[バージョン情報更新]
    P --> Q[バッチ終了]
    F --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | API Error | GitHub APIへのアクセス失敗 | ネットワーク接続確認、GITHUB_TOKENの設定 |
| 1 | Download Error | ソースアーカイブのダウンロード失敗 | ネットワーク接続確認、URLの有効性確認 |
| 1 | Checksum Error | SHA256チェックサムの不一致 | アーカイブの再ダウンロード、ミラーの確認 |
| 1 | Permission Error | ファイル操作権限不足 | 実行ユーザーの権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e`によりエラー発生時は即座にスクリプトが終了
2. `trap cleanup`により一時ワークスペースは自動的にクリーンアップされる
3. チェックサム検証によりアーカイブの整合性が保証される
4. 障害発生時は既存の`deps/nbytes`ディレクトリへの影響を最小限に抑制
5. 部分的に更新された場合は、gitで変更を破棄し再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 処理完了時（gitコミットは手動） |
| ロールバック条件 | スクリプト途中でのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1ライブラリを更新 |
| 目標処理時間 | 2分以内（ネットワーク速度に依存） |
| メモリ使用量上限 | 特になし |

## 排他制御

同一プロジェクトディレクトリに対する複数同時実行は非推奨です。ファイルシステムの競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理ステップ | "Making temporary workspace..."、"Fetching nbytes source archive..."等 |
| バージョンログ | バージョン比較時 | 新旧バージョンの比較結果 |
| チェックサムログ | 検証時 | BSD形式のチェックサム情報 |
| 完了ログ | 処理完了時 | "All done!"、gitコマンドの案内 |
| 環境変数出力 | 最終行 | "NEW_VERSION={version}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分 | CI/CDログ |
| エラー発生 | 1件以上 | GitHub Actions通知 |

## 備考

- nbytesはNode.js組織（nodejs）が管理するバイト操作ユーティリティライブラリです
- 更新後は必ずビルドとテストを実行してください
- GYP/GNビルドファイル（*.gyp、*.gn、*.gni）およびREADME.mdは更新時に保持されます
- SHA256チェックサム検証によりダウンロードしたアーカイブの整合性が保証されます
