# バッチ設計書 46-update-inspector-protocol.sh

## 概要

本ドキュメントは、Node.jsプロジェクトの依存関係であるinspector_protocol（デバッガプロトコル）をV8と同じバージョンに更新するシェルスクリプト `update-inspector-protocol.sh` の設計書です。

### 本バッチの処理概要

このバッチは、Node.jsのデバッガ機能で使用されるChrome DevTools Protocol（CDP）の実装であるinspector_protocolを、upstreamの最新リビジョンに自動更新します。

**業務上の目的・背景**：inspector_protocolはNode.jsのデバッガ機能（`--inspect`フラグ）の基盤となるプロトコル実装です。Chrome DevToolsやVS Codeなどのデバッガツールとの互換性を維持し、新しいデバッグ機能をサポートするために定期的な更新が必要です。V8エンジンとの整合性を保つことで、安定したデバッグ体験を提供します。

**バッチの実行タイミング**：随時実行（V8更新時）または定期的なメンテナンス時に手動実行されます。GitHub Actionsによる自動実行も可能です。

**主要な処理内容**：
1. 一時ワークスペースを作成し、upstream（chromium.googlesource.com）からリポジトリをクローン
2. `tools/inspector_protocol/roll.py`スクリプトを使用して差分をチェック
3. 差分がある場合、`--force`オプションで更新を実行
4. `README.node`から新しいリビジョンを取得
5. `maintaining-dependencies.md`のバージョン情報を更新

**前後の処理との関連**：このバッチは単独で実行可能ですが、V8の更新と連携して実行することが推奨されます。更新後はNode.jsのビルドとデバッガ機能のテストが必要です。

**影響範囲**：`deps/inspector_protocol`ディレクトリ全体、`doc/contributing/maintaining/maintaining-dependencies.md`、Node.jsのデバッガ機能

## バッチ種別

依存関係更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Git | リポジトリのクローンに必要 |
| Python | roll.pyスクリプトの実行に必要 |

### 実行可否判定

`tools/inspector_protocol/roll.py`スクリプトを実行し、差分がない場合（終了コード0）はスクリプトを終了します。差分がある場合（終了コード非0）のみ更新処理を実行します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Chromium Git | Git Repository | `https://chromium.googlesource.com/deps/inspector_protocol.git` からソースを取得 |
| deps/inspector_protocol | Directory | 現在のinspector_protocolソースコード |
| tools/inspector_protocol/roll.py | Python Script | 更新処理を実行するスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/inspector_protocol/ | Directory | 更新されたinspector_protocolソースコード |
| deps/inspector_protocol/README.node | Text | 更新されたリビジョン情報 |
| 標準出力 | Text | 処理進捗メッセージ、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | deps/inspector_protocol/配下の全ファイル |
| 出力先 | プロジェクトルート/deps/inspector_protocol/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境変数・パス設定
   └─ BASE_DIR、DEPS_DIRを設定
2. utils.shの読み込み
   └─ 共通ユーティリティ関数をロード
3. 一時ワークスペース作成
   └─ mktemp -dで一時ディレクトリを作成
4. upstreamリポジトリクローン
   └─ git cloneでinspector_protocolをクローン
5. 差分チェック（ドライラン）
   └─ roll.pyを実行して差分を確認
6. 更新判定
   └─ 終了コード0ならスキップ、非0なら続行
7. 強制更新実行
   └─ roll.py --forceで更新を実行
8. 新バージョン取得
   └─ README.nodeからRevisionを抽出
9. バージョン情報更新
   └─ finalize_version_update関数でドキュメント更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境設定]
    B --> C[一時ワークスペース作成]
    C --> D[upstreamリポジトリクローン]
    D --> E[roll.py実行（ドライラン）]
    E --> F{差分あり?}
    F -->|No: 終了コード0| G[スキップして終了]
    F -->|Yes: 終了コード非0| H[roll.py --force実行]
    H --> I[README.nodeから新バージョン取得]
    I --> J[バージョン情報更新]
    J --> K[バッチ終了]
    G --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Clone Error | git clone失敗 | ネットワーク接続確認、Chromiumリポジトリアクセス確認 |
| 1 | Python Error | roll.py実行失敗 | Python環境確認、スクリプトの依存関係確認 |
| 1 | Permission Error | ファイル操作権限不足 | 実行ユーザーの権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e`によりエラー発生時は即座にスクリプトが終了
2. 一時ワークスペースは自動的にはクリーンアップされない（手動削除が必要）
3. roll.pyスクリプトが差分チェックと更新を分離して実行
4. 障害発生時は既存の`deps/inspector_protocol`ディレクトリへの影響を確認し、必要に応じてgitで変更を破棄

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 処理完了時（gitコミットは手動） |
| ロールバック条件 | スクリプト途中でのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1ライブラリを更新 |
| 目標処理時間 | 5分以内（ネットワーク速度に依存） |
| メモリ使用量上限 | 特になし |

## 排他制御

同一プロジェクトディレクトリに対する複数同時実行は非推奨です。ファイルシステムの競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理ステップ | "Making temporary workspace..."、"Comparing latest upstream with current revision" |
| スキップログ | スキップ時 | "Skipped because inspector_protocol is on the latest version." |
| 完了ログ | 処理完了時 | "All done!"、gitコマンドの案内 |
| 環境変数出力 | 最終行 | "NEW_VERSION={revision}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | CI/CDログ |
| エラー発生 | 1件以上 | GitHub Actions通知 |

## 備考

- inspector_protocolはChromiumプロジェクトが管理するChrome DevTools Protocolの実装です
- upstreamはChromiumのGitリポジトリ（chromium.googlesource.com）にホストされています
- roll.pyスクリプトは差分チェックと強制更新の両方の機能を持ちます
- バージョンはコミットハッシュ（36文字）で管理されます
- README.nodeファイルにリビジョン情報が記録されます
- 更新後は必ずデバッガ機能のテストを実行してください
- V8の更新と同期して実行することが推奨されます
