# バッチ設計書 47-update-nixpkgs-pin.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのNix環境で使用されるnixpkgsのピン留めバージョンを最新のunstableチャンネルに更新するシェルスクリプト `update-nixpkgs-pin.sh` の設計書です。

### 本バッチの処理概要

このバッチは、NixOS/nixpkgsリポジトリのnixpkgs-unstableブランチの最新コミットに、`tools/nix/pkgs.nix`ファイルのピン留めを更新します。

**業務上の目的・背景**：Nix環境はNode.jsの再現可能なビルド環境を提供するために使用されます。nixpkgsのピン留めにより、特定のバージョンのツールチェーンと依存関係を確実に使用できます。nixpkgs-unstableブランチの最新版に追従することで、最新のツールやセキュリティ修正を利用しながら、ビルドの再現性を維持します。

**バッチの実行タイミング**：随時実行または定期的なメンテナンス時に手動実行されます。GitHub Actionsによる自動実行も可能です。

**主要な処理内容**：
1. `tools/nix/pkgs.nix`から現在のリポジトリURLとリビジョンを取得
2. git ls-remoteでnixpkgs-unstableブランチの最新コミットを取得
3. バージョンを比較し、更新が必要か判定
4. nix-prefetch-urlで新しいアーカイブのSHA256ハッシュを計算
5. sedで`pkgs.nix`ファイルのリビジョンとハッシュを更新
6. gitコマンドの案内を出力

**前後の処理との関連**：このバッチは単独で実行可能です。更新後はNix環境でのビルドテストが推奨されます。

**影響範囲**：`tools/nix/pkgs.nix`ファイル、Nix環境でのビルド

## バッチ種別

依存関係更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Git | リポジトリ参照に必要 |
| Nix | nix-prefetch-urlコマンドの実行に必要 |
| awk | 設定ファイルのパースに必要 |
| sed | 設定ファイルの更新に必要 |

### 実行可否判定

git ls-remoteで取得した最新のnixpkgs-unstableコミットSHA1と、`pkgs.nix`ファイル内の現在のリビジョンを比較し、異なる場合のみ更新処理を実行します。同一の場合はスクリプトを終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tools/nix/pkgs.nix | Nix | 現在のnixpkgsピン留め情報（repo URL、rev、sha256） |
| GitHub Git | SHA1 | git ls-remoteでnixpkgs-unstableブランチの最新コミットを取得 |
| nix-prefetch-url | SHA256 | 新しいアーカイブのハッシュを計算 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| tools/nix/pkgs.nix | Nix | 更新されたnixpkgsピン留め情報 |
| 標準出力 | Text | 処理完了メッセージ、gitコマンドの案内、NEW_VERSION環境変数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | tools/nix/pkgs.nix |
| 出力先 | プロジェクトルート/tools/nix/pkgs.nix |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境変数・パス設定
   └─ BASE_DIR、NIXPKGS_PIN_FILEを設定
2. 現在設定の取得
   └─ pkgs.nixからrepo、rev、sha256を抽出
3. 最新コミット取得
   └─ git ls-remoteでnixpkgs-unstableの最新SHA1を取得
4. utils.shの読み込み
   └─ 共通ユーティリティ関数をロード
5. バージョン比較
   └─ compare_dependency_version関数で新旧リビジョンを比較
6. 新しいハッシュ計算
   └─ nix-prefetch-url --unpackで新アーカイブのSHA256を計算
7. 設定ファイル更新
   └─ sedでrev、sha256を置換し、一時ファイル経由で更新
8. 完了メッセージ出力
   └─ gitコマンドの案内を表示
9. 環境変数出力
   └─ NEW_VERSION={version}を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境設定]
    B --> C[pkgs.nixから現在の設定を取得]
    C --> D[git ls-remoteで最新コミット取得]
    D --> E{バージョン比較}
    E -->|同一| F[スキップして終了]
    E -->|異なる| G[nix-prefetch-urlで新ハッシュ計算]
    G --> H[sedでpkgs.nixを更新]
    H --> I[完了メッセージ出力]
    I --> J[バッチ終了]
    F --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Git Error | git ls-remote失敗 | ネットワーク接続確認、GitHubアクセス確認 |
| 1 | Nix Error | nix-prefetch-url失敗 | Nixのインストール確認、ネットワーク接続確認 |
| 1 | Parse Error | pkgs.nixのパース失敗 | ファイル形式確認 |
| 1 | Permission Error | ファイル操作権限不足 | 実行ユーザーの権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -ex`によりエラー発生時は即座にスクリプトが終了し、実行コマンドが表示される
2. 一時ファイルを経由してpkgs.nixを更新するため、途中失敗時は元ファイルが保持される
3. 部分的に更新された場合は、gitで変更を破棄し再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作全体 |
| コミットタイミング | 処理完了時（gitコミットは手動） |
| ロールバック条件 | スクリプト途中でのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1ファイルを更新 |
| 目標処理時間 | 5分以内（ネットワーク速度に依存、nix-prefetch-urlが時間を要する） |
| メモリ使用量上限 | 特になし |

## 排他制御

同一プロジェクトディレクトリに対する複数同時実行は非推奨です。ファイルシステムの競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コマンドログ | 各コマンド実行時 | set -xにより実行コマンドが表示される |
| 完了ログ | 処理完了時 | "All done!"、gitコマンドの案内 |
| 環境変数出力 | 最終行 | "NEW_VERSION={version}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | CI/CDログ |
| エラー発生 | 1件以上 | GitHub Actions通知 |

## 備考

- Nix環境はNode.jsの再現可能なビルド環境を提供します
- nixpkgs-unstableブランチは最新の安定パッケージを提供します
- nix-prefetch-url --unpackはアーカイブをダウンロードして展開し、ハッシュを計算します
- バージョン番号は35文字に短縮されたコミットハッシュです（NEW_VERSION用）
- このスクリプトはfinalize_version_update関数を使用せず、独自のメッセージを出力します
- 更新後はNix環境でのビルドテストを実行してください
- Nixがインストールされていない環境では実行できません
