# バッチ設計書 48-cpplint.py

## 概要

本ドキュメントは、Node.jsプロジェクトのC++ソースコードに対してGoogleスタイルガイドに基づくリントチェックを実行するPythonスクリプト `cpplint.py` の設計書です。

### 本バッチの処理概要

このバッチは、C/C++ソースファイルに対してGoogleスタイルガイドへの準拠をチェックし、スタイル違反を検出・報告します。Node.jsのC++コードの品質と一貫性を維持するために使用されます。

**業務上の目的・背景**：Node.jsプロジェクトには大量のC++コード（V8統合、libuv統合、ネイティブモジュール等）が含まれています。コードスタイルの一貫性は、可読性、保守性、バグ検出の効率化に直結します。cpplintはGoogleスタイルガイドに基づく自動チェックを提供し、コードレビューの効率化とコード品質の向上に貢献します。

**バッチの実行タイミング**：CI/CDパイプライン（プルリクエスト時、コミット時）、開発者によるローカル実行、プレコミットフック等で実行されます。

**主要な処理内容**：
1. コマンドライン引数のパース（フィルタ、出力形式、詳細度等）
2. 設定ファイル（CPPLINT.cfg）の読み込みとオプションのオーバーライド
3. 各C++ソースファイルに対してスタイルチェックを実行
4. 著作権表記、ヘッダーガード、インクルード順序、空白、命名規則等のチェック
5. エラー・警告の集計と出力

**前後の処理との関連**：このスクリプトはMakefileやvcbuild.batから呼び出されます（`make lint-cpp`）。CIパイプラインの一部として実行されることが多いです。

**影響範囲**：C++ソースファイル（.h、.cc、.cpp等）のスタイルチェック結果、CIの成功/失敗

## バッチ種別

コード品質

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CD / プレコミットフック |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3 | スクリプト実行に必要 |
| C++ソースファイル | チェック対象のファイルが存在すること |

### 実行可否判定

指定されたファイルまたはディレクトリにC++ソースファイル（対応する拡張子）が存在する場合に実行されます。ファイルが存在しない場合やサポート外の拡張子の場合はスキップされます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --verbose | 整数 | No | 1 | 詳細度レベル（0-5、低い値ほど信頼度の低い警告も表示） |
| --output | 文字列 | No | emacs | 出力形式（emacs/eclipse/vs7/junit/sed/gsed） |
| --filter | 文字列 | No | なし | カテゴリフィルタ（-x,+y,...形式） |
| --counting | 文字列 | No | total | エラーカウント表示（total/toplevel/detailed） |
| --root | 文字列 | No | 自動検出 | ヘッダーガード用ルートディレクトリ |
| --repository | 文字列 | No | 自動検出 | リポジトリルートディレクトリ |
| --linelength | 整数 | No | 80 | 許容行長 |
| --headers | 文字列 | No | h,hh,hpp,hxx,h++,cuh | ヘッダーファイル拡張子 |
| --extensions | 文字列 | No | c,cc,cpp,cxx,c++,h,... | チェック対象拡張子 |
| --recursive | フラグ | No | false | 再帰的にファイルを検索 |
| --exclude | 文字列 | No | なし | 除外パス |
| --quiet | フラグ | No | false | エラーがない場合に出力を抑制 |
| --config | 文字列 | No | CPPLINT.cfg | 設定ファイル名 |
| file | 文字列 | Yes | - | チェック対象のファイルまたはディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| C++ソースファイル | Text | チェック対象のソースコード（.h、.cc、.cpp等） |
| CPPLINT.cfg | INI-like | プロジェクト固有の設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準エラー出力 | Text | エラー・警告メッセージ |
| 終了コード | Integer | 0=成功（エラーなし）、1=失敗（エラーあり） |

### 出力ファイル仕様

本バッチはファイル出力を行いません。結果は標準エラー出力に出力されます。

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数パース
   └─ getoptでオプションを解析
2. グローバル状態初期化
   └─ _cpplint_stateオブジェクトをリセット
3. ファイルごとの処理ループ
   └─ 各ファイルに対してProcessFileを実行
4. 設定ファイル読み込み
   └─ CPPLINT.cfgがあれば設定をオーバーライド
5. ファイル読み込み
   └─ ソースコードをUTF-8で読み込み
6. 行ごとのチェック
   └─ 各行に対して複数のルールをチェック
7. ファイル全体のチェック
   └─ ヘッダーガード、インクルード順序等
8. エラー報告
   └─ 検出されたエラーを指定形式で出力
9. 集計・終了
   └─ エラー数を集計し、終了コードを返す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[コマンドライン引数パース]
    B --> C[グローバル状態初期化]
    C --> D{ファイルあり?}
    D -->|No| E[終了コード1で終了]
    D -->|Yes| F[次のファイルを取得]
    F --> G[設定ファイル読み込み]
    G --> H[ファイル内容読み込み]
    H --> I[行ごとのチェック]
    I --> J[ファイル全体のチェック]
    J --> K[エラー報告]
    K --> L{次のファイルあり?}
    L -->|Yes| F
    L -->|No| M[エラー数集計]
    M --> N{エラーあり?}
    N -->|Yes| O[終了コード1で終了]
    N -->|No| P[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Lint Error | スタイル違反が検出された | コードを修正するか、NOLINTコメントで抑制 |
| 1 | File Error | ファイルが読み込めない | ファイルパス・権限を確認 |
| 1 | Encoding Error | ファイルのエンコーディングエラー | ファイルをUTF-8で保存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エンコーディングエラーは置換文字を使用して継続
2. ファイル読み込みエラーは該当ファイルをスキップ
3. エラー詳細は標準エラー出力に出力

## トランザクション仕様

本バッチは読み取り専用であり、トランザクション管理は不要です。

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千ファイル |
| 目標処理時間 | 大規模プロジェクトで数分以内 |
| メモリ使用量上限 | ファイルサイズに依存 |

## 排他制御

読み取り専用のため、排他制御は不要です。複数プロセスでの同時実行が可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 違反検出時 | ファイル名、行番号、カテゴリ、メッセージ |
| 集計ログ | 処理完了時 | カテゴリ別エラー数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | 0件以上 | CI/CDログ |
| 処理時間 | 10分 | CI/CDタイムアウト |

## 備考

- cpplintはGoogleが開発したC++スタイルチェッカーのフォークです
- バージョン: 2.0.3-dev0
- NOLINTコメントで特定の警告を抑制できます
  - `// NOLINT` - その行の全警告を抑制
  - `// NOLINT(category)` - 特定カテゴリを抑制
  - `// NOLINTNEXTLINE` - 次の行の警告を抑制
  - `// NOLINTBEGIN` / `// NOLINTEND` - ブロック範囲を抑制
- 主なチェックカテゴリ:
  - build/include_order - インクルード順序
  - legal/copyright - 著作権表記
  - readability/braces - 波括弧の使用
  - runtime/references - 参照の使用
  - whitespace/indent - インデント
- 設定ファイル（CPPLINT.cfg）でプロジェクト固有の設定が可能です
- JUnit形式の出力でCI/CDツールとの統合が容易です
