# バッチ設計書 49-lint-sh.mjs

## 概要

本ドキュメントは、Node.jsプロジェクトのシェルスクリプト（.shファイル）に対してスタイルチェックを実行するNode.jsスクリプト `lint-sh.mjs` の設計書です。

### 本バッチの処理概要

このバッチは、プロジェクト内のシェルスクリプトファイルに対して、shellcheckツールを使用したリントチェックとハッシュバン（shebang）の検証を実行します。

**業務上の目的・背景**：Node.jsプロジェクトには多数のシェルスクリプト（ビルドスクリプト、テストスクリプト、CI/CDスクリプト等）が含まれています。シェルスクリプトの品質と一貫性を維持することで、ビルドの安定性とメンテナンス性が向上します。shellcheckは広く使用されているシェルスクリプト静的解析ツールであり、潜在的なバグやスタイルの問題を検出します。

**バッチの実行タイミング**：CI/CDパイプライン、開発者によるローカル実行、プレコミットフック等で実行されます。

**主要な処理内容**：
1. 指定されたディレクトリまたはファイルからシェルスクリプトを再帰的に検索
2. 各ファイルのハッシュバン（`#!/bin/sh`）を検証
3. shellcheckコマンドを使用してシェルスクリプトのリントチェックを実行
4. `--fix`オプション使用時は、shellcheckの差分出力を`git apply`で適用して自動修正
5. GitHub Actions環境ではJSON形式で出力し、アノテーションを生成

**前後の処理との関連**：このスクリプトはMakefileから呼び出されます（`make lint-sh`）。CIパイプラインの一部として実行されることが多いです。

**影響範囲**：シェルスクリプトファイル（.sh）のスタイルチェック結果、`--fix`オプション使用時はファイルの自動修正

## バッチ種別

コード品質

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CD / プレコミットフック |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | スクリプト実行に必要 |
| shellcheck | リントチェックに必要（システムインストールまたはnpx経由） |
| git | `--fix`オプション使用時に必要（git apply） |

### 実行可否判定

指定されたパスにシェルスクリプト（.sh拡張子）が存在する場合に実行されます。特定のディレクトリ（build、changelogs、deps、fixtures、gyp、inspector_protocol、node_modules、out、tmp）は自動的に除外されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| path | 文字列 | Yes | - | チェック対象のディレクトリまたはファイルパス |
| --fix | フラグ | No | false | 自動修正モードを有効化 |
| --from-npx | フラグ | No | false | npx経由でshellcheckを実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| シェルスクリプトファイル | Text | チェック対象の.shファイル |

### 環境変数

| 変数名 | 必須 | 説明 |
|-------|------|------|
| SHELLCHECK | No | shellcheck実行ファイルの絶対パス |
| GIT | No | git実行ファイルの絶対パス |
| GITHUB_ACTIONS | No | GitHub Actions環境の場合に設定される |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Text | 処理進捗メッセージ |
| 標準エラー出力 | Text/JSON | エラー・警告メッセージ（GitHub Actionsではアノテーション形式） |
| 終了コード | Integer | 0=成功、1=エラーあり |
| ファイル（--fix時） | Text | 自動修正されたシェルスクリプト |

### 出力ファイル仕様

`--fix`オプション使用時のみファイルを変更します。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ.shファイル |
| 出力先 | 元のファイルパス |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数パース
   └─ parseArgsでオプションと位置引数を解析
2. 入力パス検証
   └─ ファイルまたはディレクトリの存在確認
3. ファイル検索
   └─ ディレクトリの場合は再帰的に.shファイルを検索（除外ディレクトリをスキップ）
4. ハッシュバン検証
   └─ 各ファイルの先頭が「#!/bin/sh」であることを確認
5. ハッシュバン修正（--fix時）
   └─ 不正なハッシュバンを「#!/bin/sh」に置換
6. shellcheck実行
   └─ --shell=sh --severity=info --enable=allオプションで実行
7. 結果処理
   └─ --fix時: shellcheckの差分出力をgit applyで適用
   └─ 通常時: エラーを標準出力/エラーに出力
8. GitHub Actionsアノテーション
   └─ GITHUB_ACTIONS環境ではJSON形式で出力し、アノテーションを生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[コマンドライン引数パース]
    B --> C{パス存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E{ディレクトリ?}
    E -->|Yes| F[再帰的にファイル検索]
    E -->|No| G[単一ファイル処理]
    F --> H[checkFiles実行]
    G --> H
    H --> I[ハッシュバン検証]
    I --> J{--fix?}
    J -->|Yes| K[ハッシュバン修正]
    J -->|No| L[エラー報告]
    K --> M[shellcheck実行]
    L --> M
    M --> N{--fix?}
    N -->|Yes| O[git apply実行]
    N -->|No| P{GITHUB_ACTIONS?}
    O --> Q[バッチ終了]
    P -->|Yes| R[JSONパース＆アノテーション出力]
    P -->|No| S[標準出力に結果表示]
    R --> Q
    S --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Lint Error | shellcheckがスタイル違反を検出 | --fixで自動修正するか、手動で修正 |
| 1 | Hashbang Error | 不正なハッシュバン | --fixで自動修正するか、手動で修正 |
| 1 | Path Error | 指定されたパスが存在しない | 正しいパスを指定 |
| 1 | shellcheck Error | shellcheckが見つからない | shellcheckをインストールするか--from-npxを使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. shellcheckが見つからない場合は`--from-npx`オプションを使用
2. git applyエラー時は手動で修正を確認
3. エラー詳細は標準エラー出力に出力

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（--fix時はファイル単位） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | 特になし |

## 排他制御

`--fix`オプション使用時は同一ファイルへの同時アクセスを避ける必要があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | "Running Shell scripts checker..." |
| エラーログ | 違反検出時 | ファイル名、行番号、メッセージ |
| アノテーション | GITHUB_ACTIONS環境 | `::error file=...` 形式 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | 0件以上 | CI/CDログ |
| 処理時間 | 5分 | CI/CDタイムアウト |

## 備考

- shellcheckオプション:
  - `--shell=sh` - POSIX sh互換モード
  - `--severity=info` - 情報レベルの警告も表示
  - `--enable=all` - 全てのチェックを有効化
- 除外されるディレクトリ:
  - build, changelogs, deps, fixtures, gyp, inspector_protocol, node_modules, out, tmp
- ハッシュバンは`#!/bin/sh`に統一されます（bash等は使用不可）
- GitHub Actions環境ではJSON形式で出力し、PRにアノテーションが表示されます
- `--fix`オプションはshellcheckの`--format=diff`出力を`git apply`で適用します
- npx経由でshellcheckを実行する場合はインターネット接続が必要になる場合があります
