# バッチ設計書 5-test.py

## 概要

本ドキュメントは、Node.jsプロジェクトのテストランナー「tools/test.py」の設計仕様を記載したものである。

### 本バッチの処理概要

test.pyは、Node.jsのテストスイートを実行するためのPythonスクリプトである。並列テスト実行、テスト結果のレポート生成、フレーキーテストの処理、Valgrind連携など、多様なテスト機能を提供する。

**業務上の目的・背景**：Node.jsは大規模なオープンソースプロジェクトであり、品質保証のために数千のテストケースを持つ。test.pyは、これらのテストを効率的に実行し、CI/CDパイプラインと統合することで、コードの品質を継続的に検証する。複数のプログレスインジケータ（verbose、dots、color、TAP形式等）をサポートし、テスト結果を様々な形式で出力できる。また、アーキテクチャやモードごとのタイムアウト調整、フレーキーテストの特別処理など、実用的なテスト運用機能を提供する。

**バッチの実行タイミング**：`make test`、`make test-ci`コマンド実行時、またはvcbuild.batのテストオプション指定時に呼び出される。

**主要な処理内容**：
1. テストスイートの検出と収集
2. テストの分類（parallel、sequential、pummel等）
3. .statusファイルによるテスト期待値の設定
4. 並列/逐次テストの実行
5. テスト結果の集計とレポート生成
6. フレーキーテストの処理
7. タイムアウト管理
8. カバレッジやValgrindとの連携

**前後の処理との関連**：Makefileやvcbuild.batから呼び出され、各テストスイートディレクトリのtestcfg.pyを読み込んでテストを実行する。

**影響範囲**：テスト結果の判定、CI/CDの合否判定に直接影響を与える。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時）/ CI/CDパイプライン実行時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | make test / vcbuild test / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド済み | Node.jsがビルドされていること |
| Python 3 | Python 3がインストールされていること |
| テストスイート | test/ディレクトリにテストが存在すること |

### 実行可否判定

- node実行ファイルが見つからない場合はエラー
- 指定されたテストスイートが存在しない場合はスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -m, --mode | 文字列 | No | release | ビルドモード（release/debug） |
| -p, --progress | 文字列 | No | mono | 進捗表示（verbose/dots/color/tap/mono） |
| -t, --timeout | 整数 | No | 120 | タイムアウト秒数 |
| -j | 整数 | No | CPU数 | 並列ジョブ数 |
| --arch | 文字列 | No | none | アーキテクチャ |
| --flaky-tests | 文字列 | No | run | フレーキーテスト処理（run/skip/dontcare/keep_retrying） |
| --shell | 文字列 | No | - | node実行ファイルのパス |
| --valgrind | フラグ | No | - | Valgrind経由で実行 |
| --check-deopts | フラグ | No | - | 脱最適化をチェック |
| --worker | フラグ | No | - | Workerコンテキストで実行 |
| --logfile | 文字列 | No | - | ログ出力ファイル |
| --skip-tests | 文字列 | No | - | スキップするテスト（カンマ区切り） |
| テストスイート | 引数 | No | default | 実行するテストスイート名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/*/testcfg.py | Python | テストスイート設定 |
| test/*/*.status | テキスト | テスト期待値設定 |
| test/*/*.js | JavaScript | テストファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト結果 |
| test.tap | TAP形式 | TAP形式テスト結果 |
| --logfile | テキスト | ログファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | test.tap（TAP形式時） |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ argparseでコマンドライン引数を解析
2. 環境設定
   └─ NODE_OPTIONS除去、umask設定
3. テストスイート検出
   └─ test/配下のtestcfg.pyを持つディレクトリを検出
4. テスト収集
   └─ 各スイートからテストケースを収集
5. テスト分類
   └─ .statusファイルでテストを分類（pass/fail/skip/flaky）
6. 並列実行準備
   └─ parallelキューとsequentialキューを作成
7. テスト実行
   └─ 複数スレッドでテストを並列実行
8. 結果集計
   └─ 成功/失敗/クラッシュ/タイムアウトを集計
9. レポート出力
   └─ 指定形式で結果を出力
```

### フローチャート

```mermaid
flowchart TD
    A[test.py開始] --> B[引数解析]
    B --> C[テストスイート検出]
    C --> D[テストケース収集]
    D --> E[.statusで分類]
    E --> F{スキップ対象?}
    F -->|Yes| G[スキップ]
    F -->|No| H[キューに追加]
    H --> I[並列実行]
    I --> J{テスト成功?}
    J -->|Yes| K[成功カウント]
    J -->|No| L{フレーキー?}
    L -->|Yes| M[フレーキー処理]
    L -->|No| N[失敗記録]
    K --> O[結果集計]
    M --> O
    N --> O
    G --> O
    O --> P[レポート出力]
    P --> Q[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | テストが失敗 | 失敗したテストを修正 |
| 1 | node未検出 | node実行ファイルが見つからない | ビルドを実行 |
| - | クラッシュ | テストがクラッシュ | コードを確認 |
| - | タイムアウト | テストがタイムアウト | タイムアウト値を調整 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | フレーキーテストで最大99回（keep_retrying時） |
| リトライ間隔 | なし（即座にリトライ） |
| リトライ対象エラー | フレーキーとマークされたテストの失敗 |

### 障害時対応

- 失敗したテストのコマンドラインが出力されるので個別に再実行可能
- --flaky-tests=skip でフレーキーテストをスキップ

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千テストケース |
| 目標処理時間 | 環境依存（数分〜数十分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一テスト環境での複数同時実行は非推奨。テストポートの競合等が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | テスト実行中 | テスト名と結果 |
| TAP形式 | 全テスト終了後 | TAP形式の結果 |
| エラーログ | テスト失敗時 | stdout/stderr/コマンド |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |
| 失敗テスト数 | 1以上 | CI/CDシステム |

## 備考

### プログレスインジケータ一覧

| インジケータ | 説明 |
|-------------|------|
| verbose | 各テストの開始・終了を詳細表示 |
| dots | テスト結果を . (成功) / F (失敗) / C (クラッシュ) / T (タイムアウト) で表示 |
| color | カラー表示付きコンパクト表示 |
| tap | TAP形式で出力 |
| mono | モノクロのコンパクト表示 |
| deopts | 脱最適化チェック用 |
| actions | GitHub Actions形式のアノテーション |

### テストスイート一覧

| スイート | 説明 |
|---------|------|
| parallel | 並列実行可能なテスト |
| sequential | 逐次実行が必要なテスト |
| pummel | 負荷テスト |
| internet | ネットワーク接続が必要なテスト |
| addons | ネイティブアドオンテスト |
| js-native-api | JS Native APIテスト |
| node-api | Node-APIテスト |
| benchmark | ベンチマークテスト |
| doctool | ドキュメントツールテスト |
| wpt | Web Platform Tests |

### タイムアウトスケールファクター

| アーキテクチャ | Debug | Release |
|--------------|-------|---------|
| arm | 8倍 | 3倍 |
| riscv64 | 8倍 | 3倍 |
| loong64 | 4倍 | 1倍 |
| その他 | 4倍 | 1倍 |
