# バッチ設計書 51-lint-pr-url.mjs

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるPR URL整合性チェックスクリプト（lint-pr-url.mjs）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsプロジェクトのMarkdownドキュメントに記載されたPR（Pull Request）URLが、現在のPRのURLと一致しているかを検証するリントツールである。コントリビューターがドキュメント内でPR参照を記載する際の形式的な整合性を自動的にチェックし、ドキュメントの品質維持に貢献する。

**業務上の目的・背景**：Node.jsプロジェクトでは、変更履歴やAPIドキュメントにPR URLを記載するルールがある。手動で記載するとURLの誤記や形式の不統一が発生しやすい。このスクリプトはCI/CDパイプラインで自動実行され、PRマージ前にドキュメントの整合性を担保することで、ドキュメント品質の低下を防止する。

**バッチの実行タイミング**：PRが作成・更新されたタイミングでGitHub Actionsにより自動実行される。git diffの出力をパイプで受け取り、変更されたMarkdownファイル内のpr-url記載をチェックする。

**主要な処理内容**：
1. 標準入力からgit diffの出力を行単位で読み込む
2. ファイル区切り（+++ b/）を検出して現在処理中のファイル名を追跡
3. チャンク区切り（@@）を検出して行番号を追跡
4. `pr-url:` 定義行を検出し、期待されるPR URLとの一致をチェック
5. 不一致の場合はGitHub Actionsの警告形式でエラーを出力

**前後の処理との関連**：git diffコマンドの出力を入力として受け取るため、事前にgitリポジトリ内で差分を生成する必要がある。本スクリプトの結果はCIパイプラインの成否判定に使用される。

**影響範囲**：Markdownドキュメント（*.md）のpr-url記載に影響。ビルドやランタイムには影響しない。

## バッチ種別

コード品質チェック / リント処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PRイベント発生時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js実行環境が必要 |
| gitリポジトリ | gitリポジトリ内で実行する必要がある |
| upstream/main | 比較対象となるupstream/mainブランチが存在すること |

### 実行可否判定

git diff出力がパイプで渡される場合に実行可能。入力がない場合は何も出力せずに正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| expected-pr-url | string | Yes | - | 期待されるPR URL（コマンドライン引数で指定） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 標準入力（stdin） | git diff出力 | git diffコマンドの出力をパイプで受け取る |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理中のファイル名を表示 |
| 標準エラー出力 | GitHub Actions警告形式 | PR URL不一致時の警告メッセージ |

### 出力ファイル仕様

ファイル出力なし。標準出力に処理状況を出力。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数からexpected-pr-urlを取得
   └─ process.argv[2]から期待されるPR URLを取得
2. 標準入力のreadlineインターフェースを作成
   └─ process.stdinを入力としてreadlineを構成
3. 行単位でgit diff出力を解析
   └─ 各行をパターンマッチングで分類
4. ファイル区切りの検出
   └─ +++ b/(*.md)パターンで現在ファイルを更新
5. チャンク区切りの検出
   └─ @@ -x,y +z,w @@パターンで行番号を更新
6. pr-url定義行の検出と検証
   └─ +\s+pr-url: (.+)パターンで抽出し比較
7. 不一致時は警告を出力
   └─ GitHub Actions形式で::warning出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[expected-pr-url引数取得]
    B --> C[stdin readline作成]
    C --> D{次の行を読み込み}
    D -->|行あり| E{行種別判定}
    E -->|ファイル区切り| F[currentFile更新]
    E -->|チャンク区切り| G[currentLine更新]
    E -->|pr-url定義| H{URL検証}
    E -->|その他の追加行| I[currentLine++]
    E -->|削除行| D
    F --> D
    G --> D
    H -->|一致| I
    H -->|不一致| J[警告出力]
    J --> I
    I --> D
    D -->|EOF| K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | pr-urlが期待値と不一致 | PRのドキュメント内pr-url記載を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時はCIジョブが失敗する。PR作成者がドキュメントを修正して再プッシュする必要がある。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用処理） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | PR差分の行数（通常数十〜数百行） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限（ストリーム処理） |

## 排他制御

同時実行可能。ファイルへの書き込みがないため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ファイル解析時 | Parsing changes in {ファイル名}. |
| 警告ログ | URL不一致時 | ::warning file={file},line={line},col={col}::pr-url doesn't match |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CIジョブ結果 | 失敗時 | GitHub PR |

## 備考

- 使用例: `git diff upstream/main...HEAD -G"pr-url:" -- "*.md" | ./tools/lint-pr-url.mjs <expected-pr-url>`
- GitHub Actions環境で実行されることを前提とした警告形式（::warning）を使用
