# バッチ設計書 52-lint-readme-lists.mjs

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるREADME内コントリビューターリスト検証スクリプト（lint-readme-lists.mjs）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsプロジェクトのREADME.mdファイルに記載されたコントリビューターリスト（TSCメンバー、Collaborators、Triagers等）の整合性を検証するリントツールである。リストがアルファベット順にソートされているか、GitHubハンドルとURL形式が正しいか、実際のGitHubチームメンバーシップと一致しているかを自動的にチェックする。

**業務上の目的・背景**：Node.jsプロジェクトでは多数のコントリビューターが参加しており、README.mdにはTSCメンバー、Collaborators、Triagersなどの公式リストが記載されている。これらのリストは手動で管理されるため、追加・削除時にソート順の乱れやフォーマット不整合が発生しやすい。このスクリプトはCIで自動実行され、リストの品質を担保する。

**バッチの実行タイミング**：PRが作成・更新されたタイミングでGitHub Actionsにより自動実行される。また、定期的なチェックとしてスケジュール実行されることもある。

**主要な処理内容**：
1. README.mdファイルを読み込み、行単位で解析
2. セクションヘッダー（###, ####）を検出してリスト種別を判定
3. GitHubハンドル行のフォーマットと順序を検証
4. メンバー情報行のフォーマットを検証
5. TSCメンバーがCollaboratorsにも記載されているか確認
6. オプションでGitHubチームの実際のメンバーシップと比較検証

**前後の処理との関連**：単独で実行可能。オプションとしてGitHub APIから取得したチームメンバー情報（JSON形式）を引数で渡すことで、実際のチームメンバーシップとの整合性もチェックできる。

**影響範囲**：README.mdのコントリビューターリストセクションに影響。ビルドやランタイムには影響しない。

## バッチ種別

コード品質チェック / リント処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PRイベント発生時）/ 定期 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js実行環境が必要 |
| README.md | プロジェクトルートにREADME.mdが存在すること |

### 実行可否判定

README.mdが存在する場合に実行可能。ファイルが存在しない場合はエラーで終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| team-members | JSON string | No | {} | GitHubチームメンバー情報（省略時はチームチェックをスキップ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| README.md | Markdown | プロジェクトルートのREADMEファイル |
| コマンドライン引数 | JSON | オプションでGitHubチームメンバー情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証成功メッセージ |
| 標準エラー出力 | テキスト | 検証失敗時のエラーメッセージ |

### 出力ファイル仕様

ファイル出力なし。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. README.mdファイルをオープン
   └─ tools/../README.mdのパスを構築してオープン
2. 行単位でファイルを読み込み
   └─ readLines()で非同期イテレーション
3. セクションヘッダーの検出
   └─ ### または #### で始まる行を検出してcurrentListを更新
4. GitHubハンドル行の検証
   └─ * [handle](url) - 形式のパターンマッチング
5. アルファベット順のチェック
   └─ 前のハンドルと比較して順序を検証
6. メンバー情報行の検証
   └─ **名前** <email> 形式のパターンマッチング
7. TSCメンバーの重複チェック
   └─ TSCメンバーがCollaboratorsにも記載されているか確認
8. GitHubチームとの照合（オプション）
   └─ 引数で渡されたチームメンバー情報と比較
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[README.md オープン]
    B --> C{次の行を読み込み}
    C -->|行あり| D{行種別判定}
    D -->|セクションヘッダー| E[currentList更新]
    D -->|GitHubハンドル行| F[フォーマット検証]
    D -->|メンバー情報行| G[情報フォーマット検証]
    D -->|その他| C
    E --> C
    F --> H{アルファベット順?}
    H -->|Yes| I[ハンドル記録]
    H -->|No| J[エラー throw]
    I --> K{TSC/Collaborator?}
    K -->|TSC| L[tscMembersに追加]
    K -->|Collaborator| M[tscMembersから削除]
    K -->|その他| C
    L --> C
    M --> C
    G --> C
    C -->|EOF| N[TSC重複チェック]
    N --> O{チーム引数あり?}
    O -->|Yes| P[チームメンバー照合]
    O -->|No| Q[警告出力]
    P --> R[バッチ終了]
    Q --> R
    J --> S[異常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | GitHubハンドルがアルファベット順でない | リストをソートして修正 |
| - | Error | ハンドル行のフォーマットが不正 | フォーマットを修正 |
| - | Error | メンバー情報行のフォーマットが不正 | フォーマットを修正 |
| - | AssertionError | TSCメンバーがCollaboratorsにない | Collaboratorsリストに追加 |
| - | AssertionError | チームメンバーシップが不一致 | READMEまたはチームを更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時はCIジョブが失敗する。エラーメッセージに従ってREADME.mdを修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用処理） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | README.mdの行数（通常数百〜数千行） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限（ストリーム処理） |

## 排他制御

同時実行可能。ファイルへの書き込みがないため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | 検証完了時 | Lists are in the alphabetical order. |
| 警告ログ | チーム引数なし | Skipping the check of GitHub teams membership. |
| エラーログ | 検証失敗時 | {ハンドル} should be listed before {前ハンドル} in the {リスト} list |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CIジョブ結果 | 失敗時 | GitHub PR |

## 備考

- 対象リスト: TSC voting members, TSC regular members, TSC emeriti members, Collaborators, Collaborator emeriti, Triagers
- GitHubチームとの照合はオプションであり、引数が空の場合はスキップされる
- nodejs-github-botはcollaboratorsチームに含まれるがREADMEには記載されない特別扱い
