# バッチ設計書 53-generate.mjs

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるAPIドキュメント生成スクリプト（generate.mjs）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsのAPIドキュメント（Markdown形式）をHTMLおよびJSON形式に変換するドキュメント生成ツールである。unified/remarkエコシステムを活用してMarkdownをパースし、カスタムプラグインでNode.js固有の処理（目次生成、APIリンク解決、バージョン情報挿入等）を行った後、HTMLとJSONを出力する。

**業務上の目的・背景**：Node.jsプロジェクトでは、APIドキュメントはMarkdown形式で管理されている。これをWebサイトで公開可能なHTML形式や、プログラムから利用可能なJSON形式に変換する必要がある。このスクリプトはビルドプロセスの一部として実行され、公式ドキュメントサイト用のコンテンツを生成する。

**バッチの実行タイミング**：ビルド時に実行される。Makefileやvcbuild.batからドキュメントビルドターゲット経由で呼び出される。リリース前やドキュメント更新PRのCI検証時にも実行される。

**主要な処理内容**：
1. コマンドライン引数を解析（入力ファイル、出力ディレクトリ、バージョン情報等）
2. 入力Markdownファイルを読み込む
3. unified/remark/rehypeパイプラインで変換処理を実行
4. frontmatter処理、GFM拡張、リンク置換、テキスト前処理
5. JSON API抽出、目次生成、HTML変換
6. HTMLファイルとJSONファイルを出力ディレクトリに書き込み

**前後の処理との関連**：ビルドプロセスの一部として、doc/api/配下のMarkdownファイルに対して実行される。生成されたHTMLはdoc/api/out/に出力され、Webサイト公開に使用される。apilinksやversionsファイルが事前に生成されていることが望ましい。

**影響範囲**：doc/api/配下のMarkdownファイルの変換に影響。ランタイムには影響しない。

## バッチ種別

ドキュメント生成 / データ変換処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | Makefile / vcbuild.bat / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js実行環境が必要 |
| 依存パッケージ | unified, remark-*, rehype-*等がインストールされていること |
| 入力ファイル | 変換対象のMarkdownファイルが存在すること |
| 出力ディレクトリ | 書き込み可能な出力ディレクトリが指定されること |

### 実行可否判定

入力ファイルと出力ディレクトリの両方が指定されている場合に実行可能。どちらかが欠けている場合はエラーで終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| filename | string | Yes | - | 入力Markdownファイルパス（引数で直接指定） |
| --node-version | string | No | process.version | Node.jsバージョン文字列 |
| --output-directory | string | Yes | - | 出力ディレクトリパス |
| --apilinks | string | No | {} | APIリンク定義JSONファイルパス |
| --versions-file | string | No | [] | バージョン一覧JSONファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Markdownファイル | .md | APIドキュメントのソースファイル |
| apilinks.json | JSON | API間のリンク定義 |
| versions.json | JSON | Node.jsバージョン一覧 |
| links-mapper.json | JSON | リンク置換マッピング定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {basename}.html | HTML | 変換後のHTMLドキュメント |
| {basename}.json | JSON | 抽出されたAPI情報（構造化データ） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {入力ファイルのbasename}.html / .json |
| 出力先 | --output-directoryで指定されたディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数のパース
   └─ process.argv.slice(2)をループして各オプションを取得
2. 入力ファイルの読み込み
   └─ fs.readFileでMarkdownコンテンツを取得
3. unifiedパイプラインの構築と実行
   └─ 以下のプラグインを順次適用:
      a. frontmatter - YAMLフロントマター処理
      b. replaceLinks - links-mapper.jsonに基づくリンク置換
      c. markdown (remark-parse) - Markdownパース
      d. gfm (remark-gfm) - GitHub Flavored Markdown拡張
      e. preprocessText - テキスト前処理（バージョン挿入等）
      f. jsonAPI - JSON形式のAPI情報抽出
      g. firstHeader - 最初のヘッダー処理
      h. preprocessElements - 要素前処理
      i. buildToc - 目次生成
      j. remark2rehype - Markdown AST→HTML AST変換
      k. raw (rehype-raw) - 生HTML処理
      l. htmlStringify (rehype-stringify) - HTML文字列化
4. HTML生成
   └─ html.toHTML()でテンプレートと結合
5. ファイル出力
   └─ Promise.allSettledでHTMLとJSONを並列書き込み
6. 結果確認と終了
   └─ エラーがあればログ出力してexit(1)、なければexit(0)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数パース]
    B --> C{filename指定?}
    C -->|No| D[Error: No input file]
    C -->|Yes| E{outputDir指定?}
    E -->|No| F[Error: No output directory]
    E -->|Yes| G[入力ファイル読み込み]
    G --> H[unifiedパイプライン実行]
    H --> I[frontmatter処理]
    I --> J[リンク置換]
    J --> K[Markdownパース]
    K --> L[GFM拡張]
    L --> M[テキスト前処理]
    M --> N[JSON API抽出]
    N --> O[目次生成]
    O --> P[HTML変換]
    P --> Q[HTML生成]
    Q --> R[ファイル出力]
    R --> S{エラーあり?}
    S -->|Yes| T[エラーログ出力]
    T --> U[exit 1]
    S -->|No| V[exit 0]
    D --> U
    F --> U
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | 入力ファイル未指定 | filenameを指定する |
| - | Error | 出力ディレクトリ未指定 | --output-directoryを指定する |
| - | Error | apilinksファイルが空 | apilinksファイルの内容を確認 |
| - | Error | versionsファイルが空 | versionsファイルの内容を確認 |
| - | Error | ファイル書き込み失敗 | 出力ディレクトリの権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時はビルドが失敗する。エラーログを確認し、入力ファイルや設定を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル/実行（複数ファイルは複数回実行） |
| 目標処理時間 | 数秒/ファイル |
| メモリ使用量上限 | unified処理に依存（通常100MB未満） |

## 排他制御

同一出力ファイルへの同時書き込みを避けるため、並列実行時は異なる入力ファイルを処理すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 処理失敗時 | エラーオブジェクトの内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド結果 | 失敗時 | CI/ビルドシステム |

## 備考

- unified/remark/rehypeエコシステムを使用したプラグインベースのアーキテクチャ
- html.mjs, json.mjs, markdown.mjsの補助モジュールに依存
- links-mapper.jsonはtools/doc/配下に配置
- Promise.allSettledを使用して部分的な成功も許容する設計
