# バッチ設計書 54-addon-verify.mjs

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるアドオンドキュメント検証スクリプト（addon-verify.mjs）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsのC++アドオンドキュメント（doc/api/addons.md）からコードサンプルを抽出し、テスト用のアドオンプロジェクトを自動生成するツールである。ドキュメント内のC++コード（.cc/.h）とJavaScriptコード（.js）を解析・抽出し、test/addons/ディレクトリにbinding.gypファイルと共に配置することで、実際にコンパイル・実行可能なテストケースを生成する。

**業務上の目的・背景**：Node.jsのアドオンドキュメントには多数のコードサンプルが含まれている。これらのサンプルが実際にコンパイル・動作することを検証するため、ドキュメントからコードを抽出してテスト環境を自動構築する必要がある。手動でのコピー＆ペーストはエラーの原因となり、ドキュメント更新時の同期も困難なため、この自動化スクリプトが必要となる。

**バッチの実行タイミング**：ビルド時のbuild-addonsターゲット経由で実行される。Makefileやvcbuild.batから呼び出される。CIパイプラインでもアドオンテストの前段階として実行される。

**主要な処理内容**：
1. doc/api/addons.mdファイルを読み込む
2. unified/remarkでMarkdownをパースしてAST化
3. ヘッダー（見出し）とコードブロックを解析
4. ファイル名コメント（// filename.cc等）を検出してコードを分類
5. .ccと.jsの両方を含むセクションをテスト対象として抽出
6. test/addons/配下に連番ディレクトリを作成
7. 抽出したコードファイルとbinding.gypを書き出し

**前後の処理との関連**：このスクリプトで生成されたテストアドオンは、node-gypでコンパイルされ、テストランナーで実行される。build_addons.pyやテストスイートの前提条件として機能する。

**影響範囲**：test/addons/ディレクトリ配下のファイル生成に影響。ドキュメント内容の変更がテストケースに自動反映される。

## バッチ種別

コード生成 / テスト準備処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | Makefile / vcbuild.bat / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js実行環境が必要 |
| 依存パッケージ | unified, remark-parse, remark-gfm, to-vfileがインストールされていること |
| ソースファイル | doc/api/addons.mdが存在すること |
| 出力ディレクトリ | test/addons/が書き込み可能であること |

### 実行可否判定

doc/api/addons.mdが存在する場合に実行可能。ファイルが存在しない場合はエラーで終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| doc/api/addons.md | Markdown | アドオンドキュメント |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| test/addons/{nn}_{name}/ | ディレクトリ | 各アドオンテスト用ディレクトリ |
| test/addons/{nn}_{name}/*.cc | C++ | 抽出されたC++ソースコード |
| test/addons/{nn}_{name}/*.h | C++ヘッダー | 抽出されたヘッダーファイル |
| test/addons/{nn}_{name}/*.js | JavaScript | 抽出されたテストスクリプト |
| test/addons/{nn}_{name}/binding.gyp | JSON | GYPビルド定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {連番2桁}_{セクション名（スネークケース）}/ |
| 出力先 | test/addons/ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. パス定義
   └─ rootDir, doc, verifyDirをURL形式で定義
2. addons.mdファイル読み込み
   └─ to-vfileのreadSyncでファイル内容を取得
3. Markdownパース
   └─ unified().use(remarkParse).use(gfm).parse()でAST化
4. ASTノード走査
   └─ tree.children.forEach()で各ノードを処理
5. ヘッダー検出
   └─ node.type === 'heading'でセクション名を取得
6. コードブロック検出
   └─ node.type === 'code'でコード内容を取得
7. ファイル名抽出
   └─ validNames正規表現でファイル名コメントを検出
8. テスト対象判定
   └─ .ccと.jsの両方を含むセクションを抽出
9. ディレクトリ作成
   └─ mkdirで{nn}_{name}ディレクトリを作成
10. ファイル書き出し
    └─ 抽出したコードとbinding.gypを書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[addons.md読み込み]
    B --> C[Markdownパース]
    C --> D[ASTノード走査]
    D --> E{ノード種別}
    E -->|heading| F[セクション名記録]
    E -->|code| G{ファイル名コメントあり?}
    E -->|その他| D
    F --> D
    G -->|Yes| H[ファイル内容記録]
    G -->|No| D
    H --> D
    D -->|走査完了| I[各セクション処理]
    I --> J{.ccと.jsあり?}
    J -->|No| K[スキップ]
    J -->|Yes| L[ディレクトリ作成]
    L --> M[コードファイル書き出し]
    M --> N[test.js修正]
    N --> O[binding.gyp生成]
    O --> P[ファイル書き出し]
    P --> Q[バッチ終了]
    K --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | addons.mdが存在しない | ファイルの存在を確認 |
| - | Error | ディレクトリ作成失敗 | 権限を確認 |
| - | Error | ファイル書き込み失敗 | 権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時はビルドが失敗する。エラーログを確認し、ソースファイルや権限を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | addons.md内のセクション数（数十件） |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限（ストリーム処理） |

## 排他制御

test/addons/ディレクトリへの同時書き込みを避けるため、並列実行は非推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | ログ出力なし（エラー時のみ例外） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド結果 | 失敗時 | CI/ビルドシステム |

## 備考

- test.jsのrequireパスは`'./build/Release/addon'`から`\`./build/${common.buildType}/addon\``に自動変換される
- binding.gypはtarget_name: 'addon'で固定、includes: ['../common.gypi']を参照
- ディレクトリ名は連番（01, 02, ...）+セクション名（小文字、スペースは_、非英数字は削除）
- Promise.all()で全ファイルの書き込みを並列実行
