# バッチ設計書 55-gyp_node.py

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるGYPラッパースクリプト（gyp_node.py）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsのビルドシステムで使用されるGYP（Generate Your Projects）のラッパースクリプトである。node.gypファイルを処理し、プラットフォーム固有のビルドファイル（Makefile、Visual Studioプロジェクト等）を生成する。configure.pyから呼び出され、ビルド環境の初期化を担当する。

**業務上の目的・背景**：Node.jsはC++で書かれたネイティブモジュールを含むため、クロスプラットフォームのビルドシステムが必要である。GYPはChromiumプロジェクトで開発されたメタビルドシステムで、.gypファイルからプラットフォーム固有のビルドファイルを生成する。このラッパーはNode.js固有の設定（common.gypi、config.gypi）を自動的に適用し、出力ディレクトリを適切に設定する。

**バッチの実行タイミング**：configure実行時に呼び出される。ビルド前の準備段階として、Makefile等の生成に使用される。

**主要な処理内容**：
1. スクリプトディレクトリからnode_rootパスを計算
2. GYPモジュールのパスを設定してインポート
3. V8 GYPファイル用のパスを設定
4. プラットフォームに応じてnode.gypへのパスを調整
5. common.gypi、config.gypiが存在すれば自動的にinclude
6. 出力ディレクトリ（out/）を設定
7. 静的ライブラリビルドのフラグを追加
8. gyp.main()を実行してビルドファイルを生成

**前後の処理との関連**：configure.pyから呼び出され、生成されたMakefile等はmakeコマンドで使用される。GYPの実行結果としてビルドファイルが生成される。

**影響範囲**：out/ディレクトリ配下のビルドファイル生成に影響。

## バッチ種別

ビルド準備 / コード生成処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（configure時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | configure.py / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python環境 | Python 2.7または3.x実行環境が必要 |
| GYP | tools/gyp/配下にGYPがインストールされていること |
| node.gyp | プロジェクトルートにnode.gypが存在すること |

### 実行可否判定

GYPモジュールがインポート可能な場合に実行可能。GYPが存在しない場合はインポートエラーで終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| args | list | No | [] | GYPに渡すコマンドライン引数（sys.argv[1:]） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node.gyp | GYP | ビルド定義ファイル |
| common.gypi | GYP include | 共通ビルド設定 |
| config.gypi | GYP include | 構成固有のビルド設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out/ | 各種ビルドファイル | Makefile、.vcxproj等のビルドファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | プラットフォーム依存 |
| 出力先 | out/（--generator-outputで指定） |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. パス設定
   └─ script_dir（現在のスクリプトディレクトリ）を取得
   └─ node_root（プロジェクトルート）を計算
2. GYPパス設定
   └─ tools/gyp/pylibをsys.pathに追加
   └─ gypモジュールをインポート
3. V8 GYPパス設定
   └─ tools/v8_gypfilesをsys.pathに追加
4. 出力ディレクトリ設定
   └─ output_dirをnode_root/outに設定
5. run_gyp関数実行
   └─ node.gypへのパスを引数に追加
6. common.gypiチェック
   └─ 存在すれば-Iオプションで追加
7. config.gypiチェック
   └─ 存在すれば-Iオプションで追加
8. depthオプション設定
   └─ --depth=node_rootを追加
9. プラットフォーム判定
   └─ Windowsでなくninja以外の場合のみ出力ディレクトリを設定
10. 静的ライブラリフラグ設定
    └─ component=static_library、library=static_libraryを追加
11. GYP実行
    └─ gyp.main(args)を呼び出し
12. 終了コード処理
    └─ 0以外の場合はエラー出力してsys.exit
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パス設定]
    B --> C[GYPインポート]
    C --> D[V8 GYPパス追加]
    D --> E[run_gyp呼び出し]
    E --> F[node.gypパス追加]
    F --> G{common.gypi存在?}
    G -->|Yes| H[-I common.gypi追加]
    G -->|No| I{config.gypi存在?}
    H --> I
    I -->|Yes| J[-I config.gypi追加]
    I -->|No| K[--depth追加]
    J --> K
    K --> L{Windows?}
    L -->|Yes| M[出力Dir設定スキップ]
    L -->|No| N{ninja?}
    N -->|Yes| M
    N -->|No| O[--generator-output追加]
    O --> P[-Goutput_dir追加]
    M --> Q[静的ライブラリフラグ追加]
    P --> Q
    Q --> R[gyp.main実行]
    R --> S{rc == 0?}
    S -->|Yes| T[正常終了]
    S -->|No| U[エラー出力]
    U --> V[sys.exit rc]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | GYPエラー | GYP実行が失敗 | エラーログを確認し.gypファイルを修正 |
| - | ImportError | GYPモジュールが見つからない | tools/gyp/を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時はconfigureが失敗する。GYPのエラーメッセージを確認し、.gypファイルや環境設定を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/configure |
| 目標処理時間 | 数秒〜数十秒（プロジェクトサイズ依存） |
| メモリ使用量上限 | GYP処理に依存 |

## 排他制御

同一プロジェクトでの同時実行は非推奨。out/ディレクトリへの競合書き込みを避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | GYP失敗時 | Error running GYP |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0時 | コンソール出力 |

## 備考

- Windows環境ではGYPバグ回避のため相対パスを使用
- Mac/make環境では絶対パスを使用
- ninjaビルド時は出力ディレクトリ設定をスキップ
- pymod_do_mainの検索パス設定のためv8_gypfilesを先頭に追加
- 常に静的ライブラリとしてビルド（component=static_library）
