# バッチ設計書 56-getnodeversion.py

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるバージョン取得スクリプト（getnodeversion.py）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsのバージョン情報をsrc/node_version.hヘッダーファイルから抽出し、標準出力にセマンティックバージョン形式（major.minor.patch）で出力するユーティリティスクリプトである。ビルドスクリプトやCIパイプラインでNode.jsのバージョンを取得する際に使用される。

**業務上の目的・背景**：Node.jsのビルドプロセスやリリース作業では、現在のソースコードのバージョン番号を正確に取得する必要がある。バージョン情報はsrc/node_version.hに定義されているため、このスクリプトで一元的に取得することで、バージョン取得ロジックの重複を防ぎ、一貫性を確保する。

**バッチの実行タイミング**：ビルド時、リリース時、またはバージョン情報が必要な各種スクリプトから呼び出される。configure.pyやMakefile等から使用される。

**主要な処理内容**：
1. src/node_version.hファイルのパスを計算
2. ファイルを読み込む
3. NODE_MAJOR_VERSION、NODE_MINOR_VERSION、NODE_PATCH_VERSIONの定義行を検索
4. 各バージョン番号を抽出
5. major.minor.patch形式で標準出力に出力

**前後の処理との関連**：他のビルドスクリプトやツールから呼び出され、バージョン文字列を提供する。単体で完結するユーティリティスクリプト。

**影響範囲**：読み取り専用で、ファイルシステムへの変更なし。

## バッチ種別

ユーティリティ / 情報取得処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（呼び出し時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 他スクリプト / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python環境 | Python 2.7または3.x実行環境が必要 |
| node_version.h | src/node_version.hが存在すること |

### 実行可否判定

src/node_version.hが存在し、読み取り可能な場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/node_version.h | C++ヘッダー | バージョン定義を含むヘッダーファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | major.minor.patch形式のバージョン文字列 |

### 出力ファイル仕様

ファイル出力なし。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | ドット（.） |

## 処理フロー

### 処理シーケンス

```
1. パス計算
   └─ __file__からscript_dirを取得
   └─ ../src/node_version.hのパスを構築
2. ファイル読み込み
   └─ node_version.hを開いて全文を読み込む
3. get_major_minor_patch関数実行
   └─ テキストを行単位で分割
4. MAJOR検索
   └─ #define NODE_MAJOR_VERSIONで始まる行を検出
   └─ 3番目のトークン（数値）を抽出
5. MINOR検索
   └─ #define NODE_MINOR_VERSIONで始まる行を検出
   └─ 3番目のトークン（数値）を抽出
6. PATCH検索
   └─ #define NODE_PATCH_VERSIONで始まる行を検出
   └─ 3番目のトークン（数値）を抽出
7. 結果出力
   └─ major.minor.patch形式でprint
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パス計算]
    B --> C[node_version.h読み込み]
    C --> D[get_major_minor_patch呼び出し]
    D --> E[行単位でループ]
    E --> F{NODE_MAJOR_VERSION?}
    F -->|Yes| G[major抽出]
    F -->|No| H{NODE_MINOR_VERSION?}
    G --> H
    H -->|Yes| I[minor抽出]
    H -->|No| J{NODE_PATCH_VERSION?}
    I --> J
    J -->|Yes| K[patch抽出]
    J -->|No| E
    K --> L[major.minor.patch出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFoundError | node_version.hが存在しない | ファイルパスを確認 |
| - | UnboundLocalError | バージョン定義が見つからない | node_version.hの内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時は呼び出し元スクリプトが失敗する。node_version.hの存在と内容を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/呼び出し |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 最小限（ファイル1つ読み込み） |

## 排他制御

同時実行可能。読み取り専用のため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | ログ出力なし（結果のみ標準出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

- node_version.hの形式例:
  ```c
  #define NODE_MAJOR_VERSION 20
  #define NODE_MINOR_VERSION 10
  #define NODE_PATCH_VERSION 0
  ```
- 出力例: `20.10.0`
- Python 2/3両対応（from __future__ import print_function使用）
