# バッチ設計書 57-getmoduleversion.py

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるモジュールバージョン取得スクリプト（getmoduleversion.py）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsのモジュールバージョン（NODE_MODULE_VERSION）をsrc/node_version.hヘッダーファイルから抽出し、標準出力に出力するユーティリティスクリプトである。このバージョン番号はABI（Application Binary Interface）バージョンとも呼ばれ、ネイティブアドオンの互換性判定に使用される。

**業務上の目的・背景**：Node.jsのネイティブアドオンは特定のNODE_MODULE_VERSIONでコンパイルされ、異なるバージョンのNode.jsでは動作しない。ビルドシステムやnode-gypでは、このバージョン番号を取得してアドオンの互換性を判断する。このスクリプトで一元的にバージョンを取得することで、各種ツール間の一貫性を確保する。

**バッチの実行タイミング**：ビルド時、アドオンビルド時、またはABIバージョン情報が必要な各種スクリプトから呼び出される。

**主要な処理内容**：
1. src/node_version.hファイルのパスを計算
2. ファイルを開いて行単位で読み込む
3. NODE_MODULE_VERSIONの定義行を正規表現で検索
4. バージョン番号を抽出
5. 標準出力に出力

**前後の処理との関連**：他のビルドスクリプトやnode-gyp等から呼び出され、ABIバージョン情報を提供する。単体で完結するユーティリティスクリプト。

**影響範囲**：読み取り専用で、ファイルシステムへの変更なし。

## バッチ種別

ユーティリティ / 情報取得処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（呼び出し時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 他スクリプト / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python環境 | Python 2.7または3.x実行環境が必要 |
| node_version.h | src/node_version.hが存在すること |

### 実行可否判定

src/node_version.hが存在し、NODE_MODULE_VERSION定義を含む場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/node_version.h | C++ヘッダー | モジュールバージョン定義を含むヘッダーファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | NODE_MODULE_VERSION値（整数） |

### 出力ファイル仕様

ファイル出力なし。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. パス計算
   └─ __file__からscript_dirを取得
   └─ ../src/node_version.hのパスを構築
2. ファイルオープン
   └─ node_version.hを開く
3. 正規表現パターン定義
   └─ ^#define NODE_MODULE_VERSION [0-9]+
4. 行単位ループ
   └─ 各行をパターンとマッチング
5. マッチ検出
   └─ マッチした行から3番目のトークンを抽出
   └─ 即座にreturn
6. 結果出力
   └─ get_version()の結果をprint
7. 例外処理
   └─ パターンが見つからない場合はException
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パス計算]
    B --> C[node_version.hオープン]
    C --> D[正規表現パターン定義]
    D --> E[行単位でループ]
    E --> F{パターンマッチ?}
    F -->|Yes| G[バージョン抽出]
    G --> H[return]
    F -->|No| I{次の行あり?}
    I -->|Yes| E
    I -->|No| J[Exception発生]
    H --> K[結果出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFoundError | node_version.hが存在しない | ファイルパスを確認 |
| - | Exception | NODE_MODULE_VERSION定義が見つからない | node_version.hの内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時は呼び出し元スクリプトが失敗する。node_version.hの存在と内容を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/呼び出し |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 最小限（ファイル1行ずつ読み込み） |

## 排他制御

同時実行可能。読み取り専用のため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | ログ出力なし（結果のみ標準出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

- node_version.hの形式例:
  ```c
  #define NODE_MODULE_VERSION 108
  ```
- 出力例: `108`
- NODE_MODULE_VERSIONはNode.jsのメジャーバージョンごとにインクリメントされる
- ネイティブアドオンのABI互換性判定に使用される
- Python 2/3両対応（from __future__ import print_function使用）
- 正規表現でマッチング、見つかり次第即座にreturnする効率的な実装
