# バッチ設計書 58-getnapibuildversion.py

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるN-APIビルドバージョン取得スクリプト（getnapibuildversion.py）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsのN-API（Node-API）サポートバージョン（NODE_API_SUPPORTED_VERSION_MAX）をsrc/node_version.hヘッダーファイルから抽出し、標準出力に出力するユーティリティスクリプトである。N-APIはNode.jsのネイティブアドオン向けのABI安定なAPIであり、このバージョン番号はサポートされるN-API機能の範囲を示す。

**業務上の目的・背景**：N-API（Node-API）はNode.jsのバージョン間でABI互換性を維持するAPIレイヤーである。各Node.jsバージョンでサポートされるN-APIの最大バージョンを取得することで、ネイティブアドオン開発者は使用可能なAPI機能を判断できる。このスクリプトはビルドシステムやnode-addon-api等から利用される。

**バッチの実行タイミング**：ビルド時、アドオンビルド時、またはN-APIバージョン情報が必要な各種スクリプトから呼び出される。

**主要な処理内容**：
1. src/node_version.hファイルのパスを計算
2. ファイルを開いて行単位で読み込む
3. NODE_API_SUPPORTED_VERSION_MAXの定義行を正規表現で検索
4. バージョン番号を抽出
5. 標準出力に出力

**前後の処理との関連**：他のビルドスクリプトやnode-addon-api等から呼び出され、N-APIバージョン情報を提供する。単体で完結するユーティリティスクリプト。

**影響範囲**：読み取り専用で、ファイルシステムへの変更なし。

## バッチ種別

ユーティリティ / 情報取得処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（呼び出し時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 他スクリプト / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python環境 | Python 2.7または3.x実行環境が必要 |
| node_version.h | src/node_version.hが存在すること |

### 実行可否判定

src/node_version.hが存在し、NODE_API_SUPPORTED_VERSION_MAX定義を含む場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/node_version.h | C++ヘッダー | N-APIバージョン定義を含むヘッダーファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | NODE_API_SUPPORTED_VERSION_MAX値（整数） |

### 出力ファイル仕様

ファイル出力なし。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. パス計算
   └─ __file__からscript_dirを取得
   └─ ../src/node_version.hのパスを構築
2. ファイルオープン
   └─ node_version.hを開く
3. 正規表現パターン定義
   └─ ^#define NODE_API_SUPPORTED_VERSION_MAX
4. 行単位ループ
   └─ 各行をパターンとマッチング
5. マッチ検出
   └─ マッチした行から3番目のトークンを抽出
   └─ 即座にreturn
6. 結果出力
   └─ get_napi_version()の結果をprint
7. 例外処理
   └─ パターンが見つからない場合はException
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パス計算]
    B --> C[node_version.hオープン]
    C --> D[正規表現パターン定義]
    D --> E[行単位でループ]
    E --> F{パターンマッチ?}
    F -->|Yes| G[バージョン抽出]
    G --> H[return]
    F -->|No| I{次の行あり?}
    I -->|Yes| E
    I -->|No| J[Exception発生]
    H --> K[結果出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFoundError | node_version.hが存在しない | ファイルパスを確認 |
| - | Exception | NODE_API_SUPPORTED_VERSION_MAX定義が見つからない | node_version.hの内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

スクリプト実行失敗時は呼び出し元スクリプトが失敗する。node_version.hの存在と内容を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/呼び出し |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 最小限（ファイル1行ずつ読み込み） |

## 排他制御

同時実行可能。読み取り専用のため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | ログ出力なし（結果のみ標準出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

- node_version.hの形式例:
  ```c
  #define NODE_API_SUPPORTED_VERSION_MAX 9
  ```
- 出力例: `9`
- N-API（Node-API）はNode.js v8.0.0で導入されたABI安定なネイティブアドオンAPI
- バージョン番号はNode.jsのリリースごとに増加する可能性がある
- Python 2/3両対応（from __future__ import print_function使用）
- getmoduleversion.pyと類似の構造だが、検索対象が異なる
