# バッチ設計書 59-make-v8.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるV8ビルドスクリプト（make-v8.sh）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsに組み込まれるV8 JavaScriptエンジンを単独でビルドするシェルスクリプトである。deps/v8ディレクトリ内のV8ソースコードをビルドし、d8（V8のスタンドアロンシェル）、cctest（C++テスト）、inspector-test（インスペクタテスト）のバイナリを生成する。アーキテクチャ（x64、s390x、ppc64le等）に応じてビルド設定を自動調整する。

**業務上の目的・背景**：Node.jsの開発やデバッグにおいて、V8エンジン単体でのテストやデバッグが必要な場合がある。このスクリプトを使用することで、Node.js全体をビルドせずにV8のみを効率的にビルドできる。特にV8の新機能テストやパフォーマンス検証に有用である。

**バッチの実行タイミング**：V8のテストやデバッグが必要な場合に手動で実行される。CI/CDパイプラインでのV8固有のテストにも使用される可能性がある。

**主要な処理内容**：
1. deps/v8ディレクトリに移動
2. .gitディレクトリを削除してクリーンな状態にする
3. fetch_deps.pyで依存関係を取得
4. アーキテクチャを検出（x64、s390x、ppc64le等）
5. s390x/ppc64le: gnコマンドでビルド設定を生成、ninjaでビルド
6. その他: depot_toolsを使用してv8gen.pyでビルド設定を生成、ninjaでビルド
7. d8、cctest、inspector-testのバイナリを生成

**前後の処理との関連**：deps/v8にV8ソースが配置されていることが前提。生成されたバイナリはout.gn/{BUILD_ARCH_TYPE}/に出力される。

**影響範囲**：deps/v8/out.gn/ディレクトリ配下のビルド成果物に影響。

## バッチ種別

ビルド処理 / コンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 / CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | bash/sh実行環境が必要 |
| deps/v8 | V8ソースコードが配置されていること |
| gn | ビルド設定生成ツール（s390x/ppc64le） |
| ninja | ビルドツール |
| depot_tools | Chromium開発ツール（x64等） |
| Python | fetch_deps.py実行用 |

### 実行可否判定

deps/v8ディレクトリが存在し、必要なツール（gn、ninja等）がインストールされている場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BUILD_ARCH_TYPE | string | Yes | - | ビルドタイプ（例: x64.release） |
| V8_BUILD_OPTIONS | string | No | - | 追加のビルドオプション |
| JOBS | number | No | - | 並列ジョブ数 |
| CXX | string | No | - | C++コンパイラ（ccache/clang検出用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| deps/v8/ | ソースコード | V8エンジンのソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| deps/v8/out.gn/{BUILD_ARCH_TYPE}/d8 | バイナリ | V8スタンドアロンシェル |
| deps/v8/out.gn/{BUILD_ARCH_TYPE}/cctest | バイナリ | C++テストバイナリ |
| deps/v8/out.gn/{BUILD_ARCH_TYPE}/inspector-test | バイナリ | インスペクタテストバイナリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | d8, cctest, inspector-test |
| 出力先 | deps/v8/out.gn/{BUILD_ARCH_TYPE}/ |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. エラー時即終了設定
   └─ set -xe
2. 引数取得
   └─ BUILD_ARCH_TYPE=$1, V8_BUILD_OPTIONS=$2
3. ディレクトリ移動
   └─ cd deps/v8
4. .gitディレクトリ削除
   └─ find . -type d -name .git -print0 | xargs -0 rm -rf
5. 依存関係取得
   └─ ../../tools/v8/fetch_deps.py .
6. JOBS引数構築
   └─ JOBS環境変数があれば-j ${JOBS}を設定
7. アーキテクチャ検出
   └─ arch コマンドで現在のアーキテクチャを取得
8. s390x/ppc64leの場合
   └─ a. TARGET_ARCH設定（ppc64le→ppc64に変換）
   └─ b. ccache検出してCC_WRAPPER設定
   └─ c. clang検出してGN_COMPILER_OPTS設定
   └─ d. gn genでビルド設定生成
   └─ e. ninjaでビルド実行
9. その他アーキテクチャの場合
   └─ a. depot_toolsパス設定
   └─ b. v8gen.pyでビルド設定生成
   └─ c. ninjaでビルド実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[set -xe]
    B --> C[引数取得]
    C --> D[cd deps/v8]
    D --> E[.git削除]
    E --> F[fetch_deps.py実行]
    F --> G[JOBS引数構築]
    G --> H[アーキテクチャ検出]
    H --> I{s390x or ppc64le?}
    I -->|Yes| J[TARGET_ARCH設定]
    J --> K{ccache使用?}
    K -->|Yes| L[CC_WRAPPER設定]
    K -->|No| M{clang使用?}
    L --> M
    M -->|Yes| N[GN_COMPILER_OPTS clang設定]
    M -->|No| O[GN_COMPILER_OPTS 標準設定]
    N --> P[gn gen実行]
    O --> P
    P --> Q[ninja ビルド]
    I -->|No| R[depot_tools PATH設定]
    R --> S[v8gen.py実行]
    S --> T[ninja ビルド]
    Q --> U[バッチ終了]
    T --> U
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | cd失敗 | deps/v8が存在しない | V8ソースを配置 |
| 非0 | fetch_deps失敗 | 依存関係取得失敗 | ネットワーク/権限確認 |
| 非0 | gn gen失敗 | ビルド設定生成失敗 | gnツール/設定確認 |
| 非0 | ninja失敗 | コンパイル失敗 | エラーログ確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

set -eにより最初のエラーで即座に終了。エラーログを確認し、依存関係やツールの設定を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 数分〜数十分（マシンスペック依存） |
| メモリ使用量上限 | コンパイル処理に依存（数GB） |

## 排他制御

同一deps/v8ディレクトリでの同時実行は非推奨。ビルド成果物の競合を避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | 全処理 | set -xにより全コマンドをエコー |
| コンパイルログ | ninja実行時 | コンパイル進捗と結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0時 | コンソール出力 |

## 備考

- set -xeによりデバッグ出力とエラー時即終了を有効化
- ppc64leはTARGET_ARCHとしてppc64に変換される
- ccache使用時はcc_wrapper="ccache"を設定
- clang使用時はis_clang=true等の追加オプションを設定
- depot_toolsはChromiumプロジェクトのツールチェーン
- ビルドターゲット: d8（シェル）、cctest（テスト）、inspector-test（デバッガテスト）
