# バッチ設計書 6-build_addons.py

## 概要

本ドキュメントは、Node.jsプロジェクトのネイティブアドオンビルドスクリプト「tools/build_addons.py」の設計仕様を記載したものである。

### 本バッチの処理概要

build_addons.pyは、Node.jsのテスト用ネイティブアドオンをビルドするPythonスクリプトである。node-gypを使用して、C/C++で書かれたネイティブモジュールをコンパイルする。

**業務上の目的・背景**：Node.jsはネイティブアドオン（C/C++拡張モジュール）のサポートを提供しており、そのAPIの品質を保証するためにテスト用アドオンが必要である。build_addons.pyは、これらのテストアドオン（test/addons、test/js-native-api、test/node-api等）を並列でビルドし、テスト実行の準備を行う。ThreadPoolExecutorを使用した並列ビルドにより、多数のアドオンを効率的にコンパイルできる。

**バッチの実行タイミング**：`make build-addons`、`make test`コマンド実行時、またはvcbuild.batのbuild-addonsオプション指定時に呼び出される。

**主要な処理内容**：
1. ヘッダファイルの生成（必要な場合）
2. ビルド対象アドオンの検出
3. node-gypを使用した並列ビルド
4. ビルドエラーの集約と報告

**前後の処理との関連**：Makefileやvcbuild.batから呼び出され、install.pyを使用してヘッダファイルを生成する。ビルドされたアドオンはtest.pyによるテスト実行で使用される。

**影響範囲**：テスト用ネイティブアドオンのビルド成果物に影響を与える。

## バッチ種別

ビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（テスト実行前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | make build-addons / vcbuild build-addons / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsビルド済み | node実行ファイルが存在すること |
| node-gyp | deps/npm/node_modules/node-gypが存在すること |
| Python 3 | Python 3がインストールされていること |
| C/C++コンパイラ | GCCまたはMSVCがインストールされていること |

### 実行可否判定

- node実行ファイルが見つからない場合はエラー
- binding.gypを持たないディレクトリはスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| target | 文字列 | Yes | - | ビルド対象ディレクトリ |
| --headers-dir | 文字列 | No | - | ヘッダディレクトリ（未指定時は自動生成） |
| --out-dir | 文字列 | No | out/Release | ビルド出力ディレクトリ |
| --loglevel | 文字列 | No | silent | node-gypのログレベル |
| --skip-tests | 文字列 | No | - | スキップするテスト（カンマ区切り） |
| --only-tests | 文字列 | No | - | 指定テストのみビルド（カンマ区切り） |
| --node-gyp | 文字列 | No | deps/npm/.../node-gyp.js | node-gypのパス |
| --is-win | フラグ | No | 自動検出 | Windows環境かどうか |
| --config | 文字列 | No | Release | ビルド設定（Release/Debug） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| target/*/binding.gyp | GYPファイル | アドオンビルド定義 |
| ヘッダファイル | C/C++ヘッダ | Node.jsヘッダ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| target/*/build/ | ディレクトリ | ビルド出力 |
| target/*/build/Release/*.node | バイナリ | ネイティブアドオン |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {addon_name}.node |
| 出力先 | target/*/build/Release/ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ argparseでコマンドライン引数を解析
2. 出力ディレクトリ決定
   └─ --out-dirまたはデフォルトを使用
3. ヘッダ生成（必要な場合）
   └─ --headers-dir未指定時はinstall.pyでヘッダを一時ディレクトリに生成
4. node.libコピー（Windows）
   └─ Windows環境ではnode.libをヘッダディレクトリにコピー
5. ビルド対象検出
   └─ binding.gypを持つディレクトリを検出
6. 並列ビルド
   └─ ThreadPoolExecutorで各アドオンをnode-gypでビルド
7. 結果集約
   └─ 全ビルドの成功/失敗を集約
8. 一時ディレクトリ削除
   └─ ヘッダを一時生成した場合は削除
```

### フローチャート

```mermaid
flowchart TD
    A[build_addons.py開始] --> B[引数解析]
    B --> C{headers-dir指定?}
    C -->|Yes| D[指定ディレクトリ使用]
    C -->|No| E[一時ディレクトリにヘッダ生成]
    D --> F{Windows?}
    E --> F
    F -->|Yes| G[node.libコピー]
    F -->|No| H[ビルド対象検出]
    G --> H
    H --> I[binding.gypを持つディレクトリを列挙]
    I --> J[ThreadPoolExecutorで並列ビルド]
    J --> K{全て成功?}
    K -->|Yes| L[成功終了]
    K -->|No| M[エラー出力]
    M --> N[失敗終了]
    L --> O{一時ディレクトリ?}
    N --> O
    O -->|Yes| P[一時ディレクトリ削除]
    O -->|No| Q[終了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ビルドエラー | node-gypが失敗 | エラーメッセージを確認して修正 |
| RuntimeError | 環境エラー | cygwin pythonで実行 | 標準Pythonを使用 |
| RuntimeError | 環境エラー | out dirが見つからない | ビルドを先に実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- 個別のアドオンディレクトリで`node-gyp rebuild`を手動実行して原因を特定
- --loglevel=infoで詳細なログを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百のアドオン |
| 目標処理時間 | 環境依存（数分〜数十分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ターゲットディレクトリでの複数同時実行は非推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各アドオンビルド開始時 | Building addon in {path} |
| エラーログ | ビルド失敗時 | Failed to build addon in {path} |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元 |

## 備考

- ThreadPoolExecutorでデフォルトのワーカー数で並列実行
- cygwin pythonはサポートされていない
- Windows環境ではnode.libをヘッダディレクトリにコピーする必要がある
- --headers-dirを指定しない場合、一時ディレクトリにヘッダを生成し、終了時に削除する
