# バッチ設計書 60-run-valgrind.py

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるValgrind実行スクリプト（run-valgrind.py）の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、Node.jsバイナリや関連ツールをValgrind（メモリデバッグツール）経由で実行し、メモリリークや不正なメモリアクセスを検出するPythonスクリプトである。Valgrindの実行結果を解析し、エラーが検出された場合は適切な終了コードを返す。

**業務上の目的・背景**：Node.jsはC++で実装されており、メモリ管理のバグ（リーク、バッファオーバーフロー、未初期化メモリの使用等）が発生する可能性がある。Valgrindを使用することで、これらの問題を早期に検出し、リリース前に修正できる。このスクリプトはValgrindの実行を標準化し、Node.js固有の設定（suppression file等）を自動適用する。

**バッチの実行タイミング**：手動でのメモリデバッグ時、またはCIパイプラインでのメモリチェック時に実行される。Linux環境専用。

**主要な処理内容**：
1. コマンドライン引数から実行対象ファイルを取得
2. 実行対象ファイルの存在確認
3. Valgrindコマンドラインを構築（suppression file、オプション指定）
4. サブプロセスでValgrindを実行
5. 実行結果（終了コード、エラー出力）を解析
6. エラー時はstderrに出力して非0終了

**前後の処理との関連**：単体で実行可能。tools/valgrind.suppにsuppression定義が存在することが前提。

**影響範囲**：読み取り専用で対象バイナリを実行するのみ。ファイルシステムへの永続的な変更なし。

## バッチ種別

テスト / デバッグ / メモリチェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動 / CI） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 / CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | Valgrindが動作するLinux環境が必要 |
| Python環境 | Python 2.7または3.x実行環境が必要 |
| Valgrind | valgrindがインストールされPATHに存在すること |
| valgrind.supp | tools/valgrind.suppが存在すること |

### 実行可否判定

実行対象ファイルが存在し、Valgrindが利用可能な場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| executable | string | Yes | - | 実行対象ファイル（sys.argv[1]）、NODE_ROOTからの相対パス |
| args | string[] | No | [] | 実行対象に渡す追加引数（sys.argv[2:]） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 実行対象ファイル | バイナリ | Valgrindで検査する実行ファイル |
| tools/valgrind.supp | テキスト | Valgrind suppression定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準エラー出力 | テキスト | Valgrindのエラー出力 |
| 終了コード | 整数 | 0=正常、非0=エラー検出 |

### 出力ファイル仕様

ファイル出力なし。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準エラー出力 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. NODE_ROOT計算
   └─ __file__から2階層上のディレクトリを取得
2. 引数チェック
   └─ sys.argv[1]が指定されているか確認
3. 実行対象パス構築
   └─ NODE_ROOT + sys.argv[1]
4. ファイル存在確認
   └─ path.existsで確認、なければエラー出力して終了
5. Valgrindコマンド構築
   └─ VALGRIND_ARGUMENTS + [executable, '--zero-fill-buffers'] + args
6. サブプロセス実行
   └─ subprocess.Popenでvalgrindを実行
7. 終了待機
   └─ process.wait()で終了を待つ
8. エラー出力取得
   └─ process.stderr.readlines()
9. 結果判定
   └─ code != 0 の場合はstderrに出力してsys.exit(code)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[NODE_ROOT計算]
    B --> C{引数あり?}
    C -->|No| D[エラー出力]
    D --> E[sys.exit 1]
    C -->|Yes| F[実行対象パス構築]
    F --> G{ファイル存在?}
    G -->|No| H[エラー出力]
    H --> I[sys.exit 1]
    G -->|Yes| J[Valgrindコマンド構築]
    J --> K[subprocess.Popen実行]
    K --> L[process.wait]
    L --> M[stderr取得]
    M --> N{code != 0?}
    N -->|Yes| O[stderr出力]
    O --> P[sys.exit code]
    N -->|No| Q[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 実行対象未指定 | 引数を指定して再実行 |
| 1 | ファイル不在 | 実行対象ファイルが存在しない | パスを確認 |
| 非0 | Valgrindエラー | メモリエラー検出 | エラー内容を確認して修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

Valgrindエラー検出時はstderrの内容を確認し、メモリ問題を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 対象プログラムの実行時間 x 10〜50倍（Valgrindオーバーヘッド） |
| メモリ使用量上限 | Valgrind + 対象プログラムに依存 |

## 排他制御

同時実行可能。ただしシステムリソース（CPU、メモリ）を大量に消費する可能性あり。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 引数エラー時 | Please provide an executable to analyze. |
| エラーログ | ファイル不在時 | Cannot find the file specified: {path} |
| エラーログ | Valgrindエラー時 | Valgrindのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0時 | コンソール出力 / CI |

## 備考

- Valgrindオプション:
  - `--error-exitcode=1`: エラー検出時に終了コード1を返す
  - `--smc-check=all-non-file`: 自己書き換えコードのチェック
  - `--suppressions=tools/valgrind.supp`: suppression file指定
  - `--gen-suppressions=all`: 新しいsuppressionを自動生成
- 実行対象には `--zero-fill-buffers` オプションが自動付与される
- Linux専用（ValgrindはLinuxのみサポート）
- V8プロジェクト由来のスクリプト（著作権表示参照）
- Python 2/3両対応（from __future__ import print_function使用）
