# バッチ設計書 61-sign.bat

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるWindows実行ファイル署名バッチ（sign.bat）の設計仕様を記載したものである。

### 本バッチの処理概要

sign.batは、Node.jsのWindows向けリリースにおいて、実行ファイル（.exe）やMSIインストーラーにデジタル署名を付与するためのバッチファイルである。2025年6月以降、Azure Trusted Signingを使用したコード署名に移行している。

**業務上の目的・背景**：Windows環境でNode.jsを配布する際、コード署名がない実行ファイルはWindows SmartScreenやセキュリティソフトウェアによってブロックされる可能性がある。ユーザーが安心してNode.jsをインストール・実行できるよう、Microsoftが信頼する証明書でデジタル署名を行う必要がある。Azure Trusted Signingを利用することで、セキュアで信頼性の高いコード署名を実現している。

**バッチの実行タイミング**：Node.jsの新バージョンリリース時、Windows向けバイナリ（node.exe）およびMSIインストーラーのビルド完了後に実行される。リリースCIパイプラインの一部として自動実行される。

**主要な処理内容**：
1. signtoolコマンドの存在確認（PATHに含まれているかチェック）
2. Azure Trusted Signing用の環境変数（AZURE_SIGN_DLIB_PATH、AZURE_SIGN_METADATA_PATH）の設定確認
3. signtoolを使用したデジタル署名の実行（SHA256ハッシュアルゴリズム、Microsoftタイムスタンプサーバー使用）
4. 署名結果の検証と成功/失敗メッセージの出力

**前後の処理との関連**：vcbuild.batによるビルド処理が完了した後に実行される。署名完了後はMSIインストーラーのパッケージング処理やリリースファイルのアップロード処理へと続く。

**影響範囲**：Windows向けNode.jsリリースバイナリ全体。署名に失敗した場合、リリースプロセスが中断され、ユーザーへの配布ができなくなる。

## バッチ種別

署名処理（コード署名・セキュリティ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース時（随時） |
| 実行時刻 | リリースビルド完了後 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | リリースCI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| signtoolの存在 | Windows SDKのsigntool.exeがPATHに含まれていること |
| AZURE_SIGN_DLIB_PATH | Azure Trusted SigningのDLIBパスが環境変数に設定されていること |
| AZURE_SIGN_METADATA_PATH | Azure Trusted Signingのメタデータパスが環境変数に設定されていること |
| 署名対象ファイル | 署名対象の実行ファイルまたはMSIが存在すること |

### 実行可否判定

1. signtoolコマンドがPATHに存在するかを確認（where signtool）
2. AZURE_SIGN_DLIB_PATH環境変数が設定されているかを確認
3. AZURE_SIGN_METADATA_PATH環境変数が設定されているかを確認
4. いずれかが欠けている場合はエラーコード1で終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %1 | ファイルパス | Yes | なし | 署名対象のファイルパス（.exeまたは.msi） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 署名対象ファイル | バイナリ（EXE/MSI） | デジタル署名を付与するWindows実行ファイルまたはインストーラー |
| AZURE_SIGN_DLIB_PATH | 環境変数 | Azure Trusted SigningのDLIBファイルへのパス |
| AZURE_SIGN_METADATA_PATH | 環境変数 | Azure Trusted Signingのメタデータファイルへのパス |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 署名済みファイル | バイナリ（EXE/MSI） | デジタル署名が付与された入力ファイル（インプレース更新） |
| 標準出力 | テキスト | 署名処理の成功/失敗メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力ファイルと同一（インプレース署名） |
| 出力先 | 入力ファイルと同一 |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. signtool存在確認
   └─ where signtoolでPATH内のsigntoolを検索
2. 環境変数チェック（AZURE_SIGN_DLIB_PATH）
   └─ 未設定の場合はエラーメッセージを出力して終了
3. 環境変数チェック（AZURE_SIGN_METADATA_PATH）
   └─ 未設定の場合はエラーメッセージを出力して終了
4. signtoolによる署名実行
   └─ SHA256ハッシュ、Microsoftタイムスタンプサーバー使用
5. 結果判定
   └─ 成功時: 成功メッセージ出力、終了コード0
   └─ 失敗時: 失敗メッセージ出力、終了コード1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{signtool存在確認}
    B -->|存在しない| C[エラー: signtool not found]
    C --> D[終了コード1で終了]
    B -->|存在する| E{AZURE_SIGN_DLIB_PATH設定確認}
    E -->|未設定| F[エラー: AZURE_SIGN_DLIB_PATH is not set]
    F --> D
    E -->|設定済み| G{AZURE_SIGN_METADATA_PATH設定確認}
    G -->|未設定| H[エラー: AZURE_SIGN_METADATA_PATH is not set]
    H --> D
    G -->|設定済み| I[signtool signコマンド実行]
    I --> J{署名成功?}
    J -->|成功| K[成功メッセージ出力]
    K --> L[終了コード0で終了]
    J -->|失敗| M[失敗メッセージ出力]
    M --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | signtoolがPATHに存在しない | Windows SDKをインストールし、signtoolにPATHを通す |
| 1 | 設定エラー | AZURE_SIGN_DLIB_PATHが未設定 | Azure Trusted Signing用のDLIBパスを環境変数に設定 |
| 1 | 設定エラー | AZURE_SIGN_METADATA_PATHが未設定 | Azure Trusted Signing用のメタデータパスを環境変数に設定 |
| 1 | 署名エラー | signtoolによる署名処理が失敗 | Azure認証情報、ネットワーク接続、ファイルアクセス権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. signtool未検出の場合: Windows SDK 10以降をインストールし、binフォルダをPATHに追加
3. 環境変数未設定の場合: リリースCI設定を確認し、Azure Trusted Signing用の環境変数を設定
4. 署名失敗の場合: Azure認証情報の有効期限、ネットワーク接続、対象ファイルのアクセス権限を確認
5. 問題解決後、バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（署名失敗時は元ファイルは変更されない） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル/実行 |
| 目標処理時間 | 60秒以内 |
| メモリ使用量上限 | N/A |

## 排他制御

同一ファイルに対する同時署名は不可。リリースCI環境では順次実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | signtool未検出時 | "signtool not found in PATH." |
| エラーログ | 環境変数未設定時 | "AZURE_SIGN_DLIB_PATH is not set." または "AZURE_SIGN_METADATA_PATH is not set." |
| 成功ログ | 署名成功時 | "Successfully signed {ファイル名} using signtool" |
| エラーログ | 署名失敗時 | "Could not sign {ファイル名} using signtool" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 署名失敗 | 1回 | リリース担当者 |
| 処理時間 | 300秒超過 | リリース担当者 |

## 備考

- 2025年6月以降、従来の証明書ベースの署名からAzure Trusted Signingに移行
- リリースCIマシンには事前にsigntoolとAzure Trusted Signing用の設定がPATHに含まれるよう構成されている
- タイムスタンプサーバーとしてMicrosoftのhttp://timestamp.acs.microsoft.comを使用
