# バッチ設計書 63-osx-notarize.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるmacOS向け公証（Notarization）スクリプト（osx-notarize.sh）の設計仕様を記載したものである。

### 本バッチの処理概要

osx-notarize.shは、macOS向けNode.jsパッケージファイル（.pkg）をAppleの公証サービスに提出し、Gatekeeperによる検証をパスできるようにするためのシェルスクリプトである。Xcode 13以降のnotarytoolを使用して公証処理を行い、完了後にstapler（ステープラー）で公証チケットをパッケージに埋め込む。

**業務上の目的・背景**：macOS Catalina（10.15）以降、Gatekeeperは公証（Notarization）されていないソフトウェアの実行をブロックする。Node.jsのPKGインストーラーをmacOSユーザーに配布するためには、Appleの公証サービスでマルウェアスキャンを受け、公証を取得する必要がある。公証を取得することで、ユーザーがインストール時に「開発元を検証できません」という警告を受けることなく、スムーズにインストールできるようになる。

**バッチの実行タイミング**：Node.jsの新バージョンリリース時、PKGインストーラーの作成・署名完了後に実行される。osx-productsign.shによるインストーラー署名の後に実行される。

**主要な処理内容**：
1. 公証用環境変数（NOTARIZATION_ID、NOTARIZATION_PASSWORD、NOTARIZATION_TEAM_ID）の存在確認
2. notarytoolコマンドの存在確認
3. xcrun notarytool submitによるパッケージの公証提出（--waitで完了を待機）
4. xcrun spctlによる署名検証（Gatekeeperが受け入れるか確認）
5. xcrun staplerによる公証チケットのパッケージへの埋め込み

**前後の処理との関連**：osx-codesign.shによるバイナリ署名、osx-productsign.shによるインストーラー署名の後に実行される。公証完了後はリリースファイルのアップロード処理へと続く。

**影響範囲**：macOS向けNode.js PKGインストーラー。公証に失敗した場合、Gatekeeperによりインストールがブロックされる可能性がある。

## バッチ種別

署名処理（公証・セキュリティ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース時（随時） |
| 実行時刻 | インストーラー署名完了後 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | リリースCI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| NOTARIZATION_ID環境変数 | Apple ID（公証サービス用）が設定されていること |
| NOTARIZATION_PASSWORD環境変数 | App-Specific Passwordが設定されていること |
| NOTARIZATION_TEAM_ID環境変数 | Apple Developer Team IDが設定されていること |
| notarytoolコマンド | Xcode 13以降がインストールされていること |
| Keychainプロファイル | NODE_RELEASE_PROFILEがKeychainに設定されていること |
| 署名済みPKGファイル | node-{pkgid}.pkgが存在すること |

### 実行可否判定

1. 第1引数（pkgid）が指定されているかを確認（未指定はエラー）
2. NOTARIZATION_ID環境変数が設定されているかを確認（未設定はスキップ）
3. NOTARIZATION_PASSWORD環境変数が設定されているかを確認（未設定はスキップ）
4. NOTARIZATION_TEAM_ID環境変数が設定されているかを確認（未設定はスキップ）
5. notarytoolコマンドが存在するかを確認（不在はエラー）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (pkgid) | 文字列 | Yes | なし | パッケージID（バージョン番号など、例: v20.0.0） |
| NOTARIZATION_ID | 環境変数 | No | なし | Apple ID |
| NOTARIZATION_PASSWORD | 環境変数 | No | なし | App-Specific Password |
| NOTARIZATION_TEAM_ID | 環境変数 | No | なし | Apple Developer Team ID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node-{pkgid}.pkg | PKG（macOSインストーラー） | 公証対象のNode.jsインストーラーパッケージ |
| Keychain | システムキーチェーン | NODE_RELEASE_PROFILEプロファイル（認証情報） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 公証済みPKG | PKG（macOSインストーラー） | 公証チケットが埋め込まれたnode-{pkgid}.pkg |
| 標準出力 | テキスト | 処理進捗メッセージ |
| 標準エラー出力 | テキスト | スキップ/エラーメッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | node-{pkgid}.pkg（変更なし） |
| 出力先 | カレントディレクトリ |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ pkgidが未指定の場合: Usageメッセージ出力後、終了コード1で終了
2. NOTARIZATION_ID環境変数チェック
   └─ 未設定の場合: スキップメッセージ出力後、終了コード0で終了
3. NOTARIZATION_PASSWORD環境変数チェック
   └─ 未設定の場合: スキップメッセージ出力後、終了コード0で終了
4. NOTARIZATION_TEAM_ID環境変数チェック
   └─ 未設定の場合: スキップメッセージ出力後、終了コード0で終了
5. notarytoolコマンド存在確認
   └─ 不在の場合: エラーメッセージ出力後、終了コード1で終了
6. xcrun notarytool submit実行
   └─ --keychain-profile: NODE_RELEASE_PROFILEを使用
   └─ --wait: 完了まで待機
   └─ 対象: node-{pkgid}.pkg
7. 提出結果チェック
   └─ 失敗の場合: エラーメッセージ出力後、終了コード1で終了
8. xcrun spctl検証
   └─ Gatekeeper署名検証を実行
   └─ 失敗の場合: エラーメッセージ出力後、終了コード1で終了
9. xcrun stapler staple実行
   └─ 公証チケットをパッケージに埋め込み
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B{pkgid引数あり?}
    B -->|なし| C[Usage表示]
    C --> D[終了コード1で終了]
    B -->|あり| E{NOTARIZATION_ID設定?}
    E -->|なし| F[スキップメッセージ]
    F --> G[終了コード0で終了]
    E -->|あり| H{NOTARIZATION_PASSWORD設定?}
    H -->|なし| F
    H -->|あり| I{NOTARIZATION_TEAM_ID設定?}
    I -->|なし| F
    I -->|あり| J{notarytoolコマンド存在?}
    J -->|なし| K[エラー: Notarytool not present]
    K --> D
    J -->|あり| L[notarytool submit実行]
    L --> M{提出成功?}
    M -->|失敗| N[エラー: Notarization failed]
    N --> D
    M -->|成功| O[spctl検証実行]
    O --> P{検証成功?}
    P -->|失敗| Q[エラー: Signature not accepted]
    Q --> D
    P -->|成功| R[stapler staple実行]
    R --> S[成功メッセージ]
    S --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | pkgidが未指定 | 第1引数にパッケージIDを指定 |
| 0 | 正常スキップ | NOTARIZATION_ID未設定 | 公証が不要な場合は正常。必要な場合は環境変数を設定 |
| 0 | 正常スキップ | NOTARIZATION_PASSWORD未設定 | 公証が不要な場合は正常。必要な場合は環境変数を設定 |
| 0 | 正常スキップ | NOTARIZATION_TEAM_ID未設定 | 公証が不要な場合は正常。必要な場合は環境変数を設定 |
| 1 | 環境エラー | notarytoolが存在しない | Xcode 13以降をインストール |
| 1 | 公証エラー | notarytool submitが失敗 | パッケージ署名、ネットワーク接続、認証情報を確認 |
| 1 | 検証エラー | spctl検証が失敗 | 署名・公証状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、原因を特定
2. notarytool未検出の場合: Xcode 13以降をインストール
3. 公証失敗の場合:
   - Apple Developerアカウントの状態を確認
   - App-Specific Passwordの有効性を確認
   - パッケージが正しく署名されているか確認
   - ネットワーク接続を確認
4. spctl検証失敗の場合: 署名と公証が正しく完了しているか確認
5. 問題解決後、バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル/実行 |
| 目標処理時間 | 10分以内（Appleサーバー応答時間による） |
| メモリ使用量上限 | N/A |

## 排他制御

同一パッケージに対する同時公証は不可。リリース環境では順次実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 処理開始時 | "Notarization process is done with Notarytool." |
| 情報ログ | 提出開始時 | "Submitting node-{pkgid}.pkg for notarization..." |
| 成功ログ | 提出成功時 | "Notarization node-{pkgid}.pkg submitted successfully." |
| エラーログ | 提出失敗時 | "Notarization node-{pkgid}.pkg failed." |
| 成功ログ | 検証成功時 | "Verification was successful." |
| エラーログ | 検証失敗時 | "error: Signature will not be accepted by Gatekeeper!" |
| 成功ログ | stapler成功時 | "Stapler was successful." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 公証失敗 | 1回 | リリース担当者 |
| 処理時間 | 15分超過 | リリース担当者 |

## 備考

- Xcode 13以降のnotarytoolを使用（altoolは非推奨）
- Keychainプロファイル（NODE_RELEASE_PROFILE）は事前に設定が必要
- 公証はAppleのサーバーで行われるため、処理時間はネットワーク状況とAppleサーバーの負荷に依存
- staplerで公証チケットを埋め込むことで、オフライン環境でもGatekeeperが公証を確認可能
