# バッチ設計書 64-osx-productsign.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるmacOS向けインストーラー署名スクリプト（osx-productsign.sh）の設計仕様を記載したものである。

### 本バッチの処理概要

osx-productsign.shは、macOS向けNode.jsパッケージインストーラー（.pkg）にApple Developer ID Installerによる署名を付与するためのシェルスクリプトである。productsignコマンドを使用してインストーラーパッケージに署名を行い、Gatekeeperによる検証をパスできるようにする。

**業務上の目的・背景**：macOSでは、PKGインストーラーもGatekeeperによる署名検証の対象となる。署名されていないインストーラーは、macOS Catalina以降でインストールがブロックされる可能性がある。Node.jsのPKGインストーラーに対してApple Developer ID Installer証明書で署名することで、ユーザーが安全にインストールできるようになる。この署名はosx-codesign.shによるバイナリ署名とは別に、インストーラーパッケージ自体に対して行われる。

**バッチの実行タイミング**：Node.jsの新バージョンリリース時、PKGインストーラーの作成後、osx-notarize.shによる公証処理の前に実行される。

**主要な処理内容**：
1. SIGN環境変数の存在確認（未設定の場合はスキップ）
2. productsignコマンドによるインストーラー署名の実行
3. 署名済みファイルの元ファイルへの置き換え

**前後の処理との関連**：PKGインストーラー作成処理の後に実行される。署名完了後はosx-notarize.shによる公証処理へと続く。

**影響範囲**：macOS向けNode.js PKGインストーラー。署名がない場合、Gatekeeperによりインストールがブロックされる可能性がある。

## バッチ種別

署名処理（インストーラー署名・セキュリティ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース時（随時） |
| 実行時刻 | PKGインストーラー作成後 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | リリースCI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SIGN環境変数 | Apple Developer ID Installer証明書の識別子が設定されていること |
| PKG環境変数 | 署名対象のPKGファイルパスが設定されていること |
| productsignコマンド | Xcodeコマンドラインツールがインストールされていること |
| 署名対象ファイル | $PKGで指定されたPKGファイルが存在すること |

### 実行可否判定

1. SIGN環境変数が設定されているかを確認
2. 未設定の場合は「Skipping codesign.」メッセージを出力してスキップ（正常終了）
3. 設定されている場合はproductsign処理を実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| SIGN | 環境変数 | No | なし | Apple Developer ID Installer証明書の識別子 |
| PKG | 環境変数 | Yes | なし | 署名対象のPKGファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $PKG | PKG（macOSインストーラー） | 署名対象のNode.jsインストーラーパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 署名済みPKG | PKG（macOSインストーラー） | 署名が付与された$PKGファイル |
| 標準エラー出力 | テキスト | スキップ時のメッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | $PKGと同一（上書き） |
| 出力先 | $PKGと同一 |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. SIGN環境変数チェック
   └─ 未設定の場合: メッセージ出力後、終了コード0で終了（スキップ）
2. productsignコマンド実行
   └─ --sign: SIGN環境変数の証明書識別子を使用
   └─ 入力: $PKG
   └─ 出力: $PKG-SIGNED（一時ファイル）
3. 署名済みファイルの置き換え
   └─ mv $PKG-SIGNED $PKG
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B{SIGN環境変数設定確認}
    B -->|未設定| C[Skipping codesign メッセージ出力]
    C --> D[終了コード0で終了]
    B -->|設定済み| E[productsign実行]
    E --> F[署名済みファイルを$PKG-SIGNEDとして出力]
    F --> G[mv $PKG-SIGNED $PKG]
    G --> H{処理成功?}
    H -->|成功| D
    H -->|失敗| I[エラーで終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | 正常スキップ | SIGN環境変数が未設定 | 署名が不要な場合は正常動作。署名が必要な場合はSIGN環境変数を設定 |
| 非0 | 署名エラー | productsignコマンドが失敗 | 証明書の有効性、Keychain設定、ファイルアクセス権限を確認 |
| 非0 | ファイルエラー | mvコマンドが失敗 | ディスク容量、ファイルアクセス権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. set -eにより、productsignまたはmvコマンド失敗時は即座にスクリプトが終了
2. エラーメッセージを確認し、原因を特定
3. 証明書が期限切れの場合: Apple Developer Programで更新
4. Keychainアクセスエラーの場合: security unlock-keychainでロック解除
5. ファイルが見つからない場合: $PKGパスの正確性を確認
6. ディスク容量不足の場合: 空き容量を確保

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（mvで置き換え前に失敗した場合は元ファイルは保持される） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル/実行 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | N/A |

## 排他制御

同一ファイルに対する同時署名は不可。リリース環境では順次実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| デバッグログ | 常時 | set -xによりすべてのコマンドが標準エラーに出力される |
| スキップログ | SIGN未設定時 | "No SIGN environment var.  Skipping codesign." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 署名失敗 | 1回 | リリース担当者 |

## 備考

- productsignコマンドはインストーラーパッケージ専用の署名コマンド（codesignとは異なる）
- Developer ID Installer証明書が必要（Developer ID Application証明書とは別）
- 署名済みファイルは一時ファイル（$PKG-SIGNED）として生成後、元ファイルを上書き
- osx-codesign.shによるバイナリ署名とは別に実行される（両方必要）
