# バッチ設計書 65-nodevars.bat

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるWindows向け環境変数設定バッチ（nodevars.bat）の設計仕様を記載したものである。

### 本バッチの処理概要

nodevars.batは、Windowsコマンドプロンプトにおいて、Node.jsとnpmを使用するための環境変数を設定するバッチファイルである。主にMSIインストーラーでインストールされたNode.jsの「Node.js command prompt」ショートカットから呼び出され、ユーザーがすぐにNode.jsを使用できる環境を整える。

**業務上の目的・背景**：Windowsユーザーがコマンドプロンプトでnode.exeやnpmを使用する際、PATHが正しく設定されていないとコマンドが見つからないエラーが発生する。このバッチはNode.jsインストールディレクトリとnpmグローバルパッケージのパスをPATHの先頭に追加し、確実にNode.jsが利用できる環境を提供する。また、インストールされたNode.jsのバージョンとアーキテクチャを表示することで、ユーザーに現在の環境を明示する。

**バッチの実行タイミング**：ユーザーが「Node.js command prompt」ショートカットをクリックした時、またはコマンドプロンプトで手動実行した時に実行される。

**主要な処理内容**：
1. PATHの先頭にnpmグローバルパッケージパス（%APPDATA%\npm）とNode.jsインストールディレクトリを追加
2. node.exeを実行してNode.jsのバージョン情報とアーキテクチャを取得
3. npm.cmdの存在確認
4. 環境設定完了メッセージの表示（npmの有無に応じて異なるメッセージ）
5. カレントディレクトリがNode.jsインストールディレクトリの場合、ホームディレクトリに移動

**前後の処理との関連**：MSIインストーラーによるNode.jsインストール後、「Node.js command prompt」ショートカットの起動時に呼び出される。ユーザーはこの環境設定が完了した状態でNode.js開発作業を開始できる。

**影響範囲**：現在のコマンドプロンプトセッションのPATH環境変数およびカレントディレクトリ。システム全体の環境変数は変更されない。

## バッチ種別

環境設定（開発環境セットアップ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ユーザー操作時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ユーザー手動実行 / Node.js command promptショートカット |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsインストール済み | node.exeがバッチと同じディレクトリに存在すること |
| Windowsコマンドプロンプト | cmd.exeまたは互換シェルで実行されること |

### 実行可否判定

特になし。常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| %~dp0（バッチファイルの場所） | ディレクトリパス | Node.jsインストールディレクトリの取得に使用 |
| %APPDATA% | 環境変数 | npmグローバルパッケージパスの構築に使用 |
| %HOMEDRIVE%%HOMEPATH% | 環境変数 | ホームディレクトリへの移動先 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| PATH環境変数 | 環境変数（セッション内） | npmパスとNode.jsパスが先頭に追加される |
| 標準出力 | テキスト | 環境設定完了メッセージ |
| カレントディレクトリ | ディレクトリ | ホームディレクトリに移動（条件付き） |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. エコー無効化
   └─ @echo off
2. PATH設定
   └─ %APPDATA%\npmとバッチファイルのディレクトリをPATHの先頭に追加
3. 遅延展開有効化とディレクトリ保存
   └─ setlocal enabledelayedexpansion
   └─ pushd でバッチファイルのディレクトリに移動
4. バージョン取得
   └─ node.exe -p -e "process.versions.node + ' (' + process.arch + ')'" を実行
   └─ 結果を version 変数に格納
5. メッセージ表示
   └─ npm.cmd が存在する場合: "Your environment has been set up for using Node.js {version} and npm."
   └─ npm.cmd が存在しない場合: "Your environment has been set up for using Node.js {version}."
6. ディレクトリ復元と遅延展開終了
   └─ popd, endlocal
7. ホームディレクトリへの移動（条件付き）
   └─ カレントディレクトリがNode.jsインストールディレクトリの場合のみ移動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[PATH設定: npm + node パスを先頭に追加]
    B --> C[バッチファイルのディレクトリに移動]
    C --> D[node.exe でバージョン情報を取得]
    D --> E{npm.cmd が存在?}
    E -->|あり| F[Node.js と npm の環境設定メッセージ表示]
    E -->|なし| G[Node.js のみの環境設定メッセージ表示]
    F --> H[元のディレクトリに戻る]
    G --> H
    H --> I{カレントディレクトリ = Node.jsディレクトリ?}
    I -->|はい| J[ホームディレクトリに移動]
    I -->|いいえ| K[バッチ終了]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | node.exe実行エラー | node.exeが見つからない、または破損 | Node.jsを再インストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. node.exeが見つからない場合: Node.jsを再インストール
2. PATH設定が反映されない場合: 新しいコマンドプロンプトを開いて再実行
3. npmが認識されない場合: npm.cmdの存在確認、npmの再インストール

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | N/A |

## 排他制御

なし。複数のコマンドプロンプトで同時実行可能（各セッションは独立）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 処理完了時 | "Your environment has been set up for using Node.js {version} and npm." または "Your environment has been set up for using Node.js {version}." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- Windows専用のバッチファイル
- MSIインストーラーでNode.jsをインストールすると、スタートメニューの「Node.js command prompt」ショートカットからこのバッチが呼び出される
- PATHの先頭に追加することで、他のNode.jsインストールよりもこのバージョンが優先される
- バージョン表示にはアーキテクチャ情報（x64, x86, arm64など）も含まれる
- カレントディレクトリがNode.jsインストールディレクトリの場合にホームに移動するのは、ユーザーが作業しやすい場所に移動するため
