# バッチ設計書 66-install_tools.bat

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるWindows向け開発ツールインストールバッチ（install_tools.bat）の設計仕様を記載したものである。

### 本バッチの処理概要

install_tools.batは、WindowsでNode.jsネイティブモジュールをコンパイルするために必要な開発ツール（Python、Visual Studio Build Tools）を自動インストールするバッチファイルである。Chocolateyパッケージマネージャーを使用してこれらのツールを一括インストールする。

**業務上の目的・背景**：Node.jsのネイティブモジュール（C++で書かれたモジュール）をWindowsでコンパイルするには、Pythonとnode-gypが使用するVisual Studio Build Toolsが必要である。これらのツールを手動でインストールするのは複雑で、初心者ユーザーにとってハードルが高い。このバッチはChocolateyを使用してこれらのツールを自動的にインストールし、ネイティブモジュールのビルド環境を簡単に構築できるようにする。MSIインストーラーのオプションとして提供され、インストール後にスタートメニューから実行できる。

**バッチの実行タイミング**：ユーザーがMSIインストール時に「Automatically install the necessary tools」オプションを選択した場合、またはインストール後にスタートメニューから手動実行した場合に実行される。

**主要な処理内容**：
1. スクリプトの説明と必要なディスク容量（約7 GiB）の表示
2. サードパーティソフトウェアのライセンスに関する注意事項の表示
3. 管理者権限でPowerShellを起動
4. Chocolateyのインストール
5. Chocolateyを使用してPythonとVisual Studio 2022 Build Toolsをインストール

**前後の処理との関連**：MSIインストーラーによるNode.jsインストールの後、オプションとして実行される。完了後、ユーザーはnode-gypを使用してネイティブモジュールをコンパイルできる環境が整う。

**影響範囲**：Windowsシステム全体。Chocolatey、Python、Visual Studio Build Toolsがシステムにインストールされる。約7 GiBのディスク容量が消費される。

## バッチ種別

環境設定（開発環境セットアップ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初回セットアップ時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ユーザー手動実行 / MSIインストーラーオプション |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows 10以降を推奨 |
| 管理者権限 | インストール処理に管理者権限が必要 |
| インターネット接続 | Chocolateyおよびパッケージのダウンロードに必要 |
| 十分なディスク容量 | 約7 GiB以上の空き容量が必要 |
| TLS 1.2対応 | Chocolateyダウンロードに必要 |

### 実行可否判定

1. ユーザーが2回のpauseでインストール続行を確認
2. 管理者権限がない場合、UAC（ユーザーアカウント制御）で昇格を要求

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://chocolatey.org/install.ps1 | PowerShellスクリプト | Chocolateyインストールスクリプト |
| Chocolateyリポジトリ | パッケージ | Python、Visual Studio Build Toolsパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| システム | インストール済みソフトウェア | Chocolatey、Python、Visual Studio Build Tools |
| 標準出力 | テキスト | インストール進捗と説明メッセージ |

### 出力ファイル仕様

本バッチは直接ファイルを出力しないが、以下のソフトウェアがシステムにインストールされる：

| 項目 | 内容 |
|-----|------|
| Chocolatey | C:\ProgramData\chocolatey |
| Python | Chocolateyのデフォルトインストールパス |
| Visual Studio Build Tools | C:\Program Files (x86)\Microsoft Visual Studio |

## 処理フロー

### 処理シーケンス

```
1. タイトル設定と画面クリア
   └─ title "Install Additional Tools for Node.js"
2. インストール説明の表示
   └─ 必要なツール、ディスク容量、注意事項を説明
   └─ pause でユーザー確認
3. サードパーティソフトウェアのライセンス説明
   └─ Chocolatey、Python、Visual Studioのライセンスについて説明
   └─ pause でユーザー確認
4. 管理者権限でPowerShell起動
   └─ Start-Process で RunAs を指定
5. TLS 1.2の有効化
   └─ [Net.ServicePointManager]::SecurityProtocol = Tls12
6. Chocolateyのインストール
   └─ iex でchocolatey.org/install.ps1を実行
7. パッケージのインストール
   └─ choco upgrade -y python visualstudio2022-workload-vctools
8. 完了待機
   └─ Read-Host でユーザーがEnterを押すまで待機
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[タイトル設定・画面クリア]
    B --> C[インストール説明表示]
    C --> D[pause: ユーザー確認1]
    D --> E[ライセンス説明表示]
    E --> F[pause: ユーザー確認2]
    F --> G[管理者権限でPowerShell起動]
    G --> H[TLS 1.2有効化]
    H --> I[Chocolateyインストール]
    I --> J[Python/VS Build Toolsインストール]
    J --> K[Read-Host: 完了待機]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| UAC拒否 | 権限エラー | ユーザーが管理者昇格を拒否 | 管理者権限で再実行 |
| ネットワークエラー | 接続エラー | インターネット接続がない | ネットワーク接続を確認して再実行 |
| ディスク容量不足 | ストレージエラー | 7 GiB以上の空き容量がない | ディスク容量を確保して再実行 |
| Chocolateyインストール失敗 | インストールエラー | スクリプトダウンロードまたは実行失敗 | 手動でChocolateyをインストール |
| パッケージインストール失敗 | インストールエラー | パッケージダウンロードまたはインストール失敗 | choco upgradeを手動で再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. Windows Updateが完全に適用されていることを確認
2. コンピュータを再起動
3. バッチを再実行
4. それでも失敗する場合は、手動インストール手順を参照：https://github.com/nodejs/node-gyp#on-windows

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（インストールは個別に行われるため、部分的にインストールされる可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 30分〜60分（ネットワーク速度による） |
| メモリ使用量上限 | N/A |

## 排他制御

同時に複数のインストーラーを実行しないこと。Visual Studio Build Toolsのインストーラーは排他ロックを取得する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 説明メッセージ | 処理開始時 | ツールの説明、必要な容量、注意事項 |
| ライセンスメッセージ | ユーザー確認前 | Chocolatey、Python、Visual Studioのライセンス情報 |
| インストールログ | インストール中 | Chocolateyおよびパッケージのインストール進捗 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- Windows専用のバッチファイル
- 管理者権限が必須
- インターネット接続が必須
- スクリプトはAS-ISで提供され、保証はない
- 参考URL:
  - https://github.com/nodejs/node-gyp#on-windows
  - https://chocolatey.org/packages/chocolatey
  - https://chocolatey.org/packages/python
  - https://chocolatey.org/packages/visualstudio2022-workload-vctools
- Visual Studio 2022のワークロード「vctools」には、C++コンパイラ、Windows SDK、CMakeなどが含まれる
- Microsoft/windows-dev-box-setup-scriptsを参考に作成されている
