# バッチ設計書 67-android-configure

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるAndroidビルド設定スクリプト（android-configure）の設計仕様を記載したものである。

### 本バッチの処理概要

android-configureは、Node.jsをAndroid向けにクロスコンパイルするための設定を行うラッパースクリプトである。シェルスクリプトとして起動され、適切なバージョンのPythonインタープリタを自動検出してandroid_configure.pyを実行する。

**業務上の目的・背景**：Node.jsは主にデスクトップおよびサーバー向けに開発されているが、Androidデバイス上での実行需要も存在する。Androidはx86、ARM、ARM64など複数のアーキテクチャをサポートしており、それぞれに対応したNode.jsバイナリをビルドする必要がある。このスクリプトはAndroid NDK（Native Development Kit）を使用してクロスコンパイル環境を設定し、Node.jsのconfigureスクリプトに適切なパラメータを渡す役割を果たす。

**バッチの実行タイミング**：開発者がAndroid向けにNode.jsをビルドする際に手動で実行される。通常のリリースプロセスには含まれない。

**主要な処理内容**：
1. 利用可能なPythonインタープリタ（Python 3.10〜3.14）を自動検出
2. 検出したPythonでスクリプト自身を再実行
3. Pythonバージョンの妥当性確認
4. android_configure.pyモジュールをインポートして実行

**前後の処理との関連**：このスクリプト実行後、android_configure.pyが呼び出され、実際のビルド設定が行われる。設定完了後はmakeコマンドでNode.jsをビルドできる。

**影響範囲**：Node.jsビルド設定。Androidクロスコンパイル環境の構築に影響する。

## バッチ種別

ビルド設定（クロスコンパイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発者による手動実行） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 開発者による手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3.10〜3.14 | 対応バージョンのPythonがインストールされていること |
| LinuxまたはmacOS | これらのOSでのみサポートされる |
| android_configure.py | 同一ディレクトリにandroid_configure.pyが存在すること |

### 実行可否判定

1. Python 3.10〜3.14のいずれかがシステムにインストールされているかを確認
2. インストールされていない場合はエラーメッセージを出力して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | コマンドライン引数 | No | なし | android_configure.pyに渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Pythonインタープリタ | 実行ファイル | python3.10〜python3.14のいずれか |
| android_configure.py | Pythonスクリプト | 実際の設定処理を行うスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Python検出メッセージ |
| 標準エラー出力 | テキスト | Pythonバージョンエラー時の使用可能なPythonコマンド |

### 出力ファイル仕様

本スクリプト自体はファイル出力を行わない（android_configure.pyが設定ファイルを生成）。

## 処理フロー

### 処理シーケンス

```
1. シェルスクリプトとして起動
   └─ /bin/sh で実行開始
2. Pythonインタープリタの検出
   └─ python3.14、python3.13、python3.12、python3.11、python3.10、python3、pythonの順で検索
   └─ 最初に見つかったものでスクリプトを再実行
3. Pythonとして再実行
   └─ Python検出メッセージを出力
   └─ バージョンが対応範囲内かチェック
4. バージョン確認
   └─ 対応範囲内: android_configureモジュールをインポート
   └─ 対応範囲外: エラーメッセージと利用可能なPythonコマンドを出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト起動 as シェル] --> B{python3.14 存在?}
    B -->|あり| C[python3.14で再実行]
    B -->|なし| D{python3.13 存在?}
    D -->|あり| E[python3.13で再実行]
    D -->|なし| F{python3.12 存在?}
    F -->|あり| G[python3.12で再実行]
    F -->|なし| H{他のPython検索継続}
    H --> I[見つかったPythonで再実行]
    C --> J[Pythonとして実行]
    E --> J
    G --> J
    I --> J
    J --> K[バージョン情報出力]
    K --> L{バージョン確認 3.10-3.14?}
    L -->|対応範囲内| M[import android_configure]
    L -->|対応範囲外| N[エラー: 使用可能なPython一覧を表示]
    N --> O[exit 1]
    M --> P[android_configure.pyの処理へ]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | バージョンエラー | 対応バージョンのPythonが見つからない | Python 3.10〜3.14をインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 対応バージョンのPythonをインストール
2. pyenvを使用している場合は、pyenvのshimsパス以外のPythonを使用
3. スクリプトが出力する推奨Pythonコマンドを手動で実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 1秒以内（Python検出のみ） |
| メモリ使用量上限 | N/A |

## 排他制御

なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | Python検出時 | "Node.js android configure: Found Python X.Y.Z..." |
| エラーログ | バージョン不適合時 | "Please use {対応Pythonバージョン一覧}." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- シェルスクリプトとPythonの多言語スクリプト（polyglot）として実装されている
- pyenvのshimsを避ける処理が含まれている（pyenv使用時の問題回避）
- Python 2系は非対応
- 対応Pythonバージョン: 3.10, 3.11, 3.12, 3.13, 3.14
- LinuxとmacOS（Darwin）のみサポート、Windowsは非対応
