# バッチ設計書 68-android_configure.py

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるAndroidビルド設定スクリプトPython版（android_configure.py）の設計仕様を記載したものである。

### 本バッチの処理概要

android_configure.pyは、Node.jsをAndroid向けにクロスコンパイルするための詳細なビルド設定を行うPythonスクリプトである。Android NDKのパスを設定し、ターゲットアーキテクチャに応じたツールチェーン設定を行い、Node.jsのconfigureスクリプトを実行する。

**業務上の目的・背景**：AndroidプラットフォームでNode.jsを実行するには、各ターゲットアーキテクチャ（ARM、ARM64、x86、x86_64）に対応したクロスコンパイルが必要である。このスクリプトはAndroid NDKのLLVMツールチェーンを使用してコンパイラ設定を行い、GYP（Generate Your Projects）ビルドシステムに必要な環境変数を設定する。また、Android固有のV8パッチを適用する機能も提供する。

**バッチの実行タイミング**：android-configureスクリプトから呼び出されるか、開発者が直接実行する。通常のリリースプロセスには含まれない。

**主要な処理内容**：
1. コマンドライン引数の解析（Android NDKパス、SDKバージョン、ターゲットアーキテクチャ）
2. 「patch」サブコマンドの場合、Android向けパッチを適用
3. ターゲットアーキテクチャに応じたDEST_CPUとTOOLCHAIN_PREFIXの設定
4. CC、CXX環境変数にLLVMクロスコンパイラのパスを設定
5. GYP_DEFINES環境変数にビルド設定を設定
6. Node.jsのconfigureスクリプトを実行

**前後の処理との関連**：android-configureラッパースクリプトから呼び出される。設定完了後はmakeコマンドでNode.jsをビルドできる。

**影響範囲**：Node.jsビルド設定ファイル、環境変数（CC、CXX、GYP_DEFINES、PATH）。

## バッチ種別

ビルド設定（クロスコンパイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発者による手動実行） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | android-configureスクリプト / 開発者による手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| LinuxまたはmacOS | これらのOSでのみサポートされる |
| Android NDK | Android NDKがインストールされていること |
| Android SDK バージョン24以上 | Android 7.0以上のSDKが必要 |
| patchコマンド（Linux） | パッチ適用時に必要 |
| configureスクリプト | Node.jsのconfigureスクリプトが存在すること |

### 実行可否判定

1. プラットフォームがLinuxまたはDarwin（macOS）であることを確認
2. 引数が「patch」の場合はパッチ適用モードで実行
3. それ以外の場合は引数が4つ（NDKパス、SDKバージョン、アーキテクチャ）であることを確認
4. NDKパスが存在し、空でないことを確認
5. SDKバージョンが24以上であることを確認
6. ターゲットアーキテクチャが対応しているものであることを確認

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 第1引数 | 文字列 | Yes | なし | "patch" またはAndroid NDKのパス |
| 第2引数 | 整数 | 条件付き | なし | Android SDKバージョン（patchモード以外で必須） |
| 第3引数 | 文字列 | 条件付き | なし | ターゲットアーキテクチャ（arm, arm64, aarch64, x86, x86_64） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Android NDK | ディレクトリ | NDKのツールチェーンを含むディレクトリ |
| android-patches/*.patch | パッチファイル | Android向けパッチファイル（patchモード時） |
| ./configure | シェルスクリプト | Node.jsのビルド設定スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 環境変数 | 設定 | CC、CXX、PATH、GYP_DEFINESが設定される |
| ビルド設定 | 設定ファイル | configureスクリプトにより生成 |
| 標準出力 | テキスト | 設定メッセージ、エラーメッセージ |

### 出力ファイル仕様

本スクリプトが直接生成するファイルはないが、configureスクリプトの実行により以下が生成される：

| 項目 | 内容 |
|-----|------|
| config.gypi | GYPビルド設定ファイル |
| config.mk | Makefile設定ファイル |

## 処理フロー

### 処理シーケンス

```
1. プラットフォーム確認
   └─ LinuxまたはDarwin以外はエラー終了
2. 引数解析
   └─ "patch"の場合: patch_android()を実行して終了
   └─ それ以外: NDKパス、SDKバージョン、アーキテクチャを解析
3. NDKパス検証
   └─ パスが存在しない、または空の場合はエラー終了
4. SDKバージョン検証
   └─ 24未満の場合はエラー終了
5. アーキテクチャ設定
   └─ arm: DEST_CPU=arm, TOOLCHAIN_PREFIX=armv7a-linux-androideabi
   └─ arm64/aarch64: DEST_CPU=arm64, TOOLCHAIN_PREFIX=aarch64-linux-android
   └─ x86: DEST_CPU=ia32, TOOLCHAIN_PREFIX=i686-linux-android
   └─ x86_64: DEST_CPU=x64, TOOLCHAIN_PREFIX=x86_64-linux-android
6. ツールチェーンパス設定
   └─ Linux: {NDK}/toolchains/llvm/prebuilt/linux-x86_64
   └─ macOS: {NDK}/toolchains/llvm/prebuilt/darwin-x86_64
7. 環境変数設定
   └─ PATH: ツールチェーンのbinディレクトリを追加
   └─ CC: {TOOLCHAIN_PREFIX}{SDK_VERSION}-clang
   └─ CXX: {TOOLCHAIN_PREFIX}{SDK_VERSION}-clang++
   └─ GYP_DEFINES: target_arch, v8_target_arch, android_target_arch, host_os, OS, android_ndk_path
8. configureスクリプト実行
   └─ --dest-cpu, --dest-os=android, --openssl-no-asm, --cross-compiling
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B{プラットフォーム確認}
    B -->|Windows| C[エラー: サポート外]
    B -->|Linux/macOS| D{引数 == 'patch'?}
    D -->|はい| E[patch_android実行]
    E --> F[終了]
    D -->|いいえ| G{引数数 == 4?}
    G -->|いいえ| H[Usage表示]
    H --> I[exit 1]
    G -->|はい| J{NDKパス有効?}
    J -->|いいえ| K[エラー: Invalid NDK path]
    K --> I
    J -->|はい| L{SDKバージョン >= 24?}
    L -->|いいえ| M[エラー: SDK version must be >= 24]
    M --> I
    L -->|はい| N{アーキテクチャ有効?}
    N -->|いいえ| O[エラー: Invalid architecture]
    O --> I
    N -->|はい| P[DEST_CPU/TOOLCHAIN_PREFIX設定]
    P --> Q[ツールチェーンパス設定]
    Q --> R[環境変数設定 CC/CXX/PATH/GYP_DEFINES]
    R --> S{configureスクリプト存在?}
    S -->|はい| T[./configure実行]
    S -->|いいえ| U[終了]
    T --> U
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | プラットフォームエラー | LinuxまたはmacOS以外で実行 | サポートされたプラットフォームで実行 |
| 1 | 引数エラー | 引数数が不正 | 正しい形式で引数を指定 |
| 1 | パスエラー | NDKパスが存在しない、または空 | 正しいNDKパスを指定 |
| 1 | バージョンエラー | SDKバージョンが24未満 | Android SDK 24以上を使用 |
| 1 | アーキテクチャエラー | サポート外のアーキテクチャを指定 | arm, arm64, aarch64, x86, x86_64のいずれかを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、原因を特定
2. NDKパスが正しいことを確認（NDKのバージョンによりパス構造が異なる場合あり）
3. SDKバージョンを24以上に設定
4. サポートされているアーキテクチャを指定

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 10秒以内（configure実行を除く） |
| メモリ使用量上限 | N/A |

## 排他制御

なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | パッチ適用時 | パッチ一覧、適用メッセージ |
| 情報ログ | 設定開始時 | "Configuring for {DEST_CPU}..." |
| エラーログ | 各種エラー時 | "Error: {エラーメッセージ}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- LinuxとmacOS（Darwin）のみサポート、Windowsは非対応
- 対応アーキテクチャ：arm（ARMv7）、arm64/aarch64（ARM64）、x86（32ビットx86）、x86_64（64ビットx86）
- Android SDK バージョン24以上が必要（Android 7.0 Nougat以降）
- patchサブコマンドはV8のtrap-handler.hに対するパッチを適用する（https://github.com/nodejs/node/issues/36287 関連）
- --openssl-no-asmオプションを使用してOpenSSLのアセンブリ最適化を無効化（クロスコンパイル時の互換性のため）
- NDKのLLVMツールチェーン（clang/clang++）を使用
- 将来のバージョンではパッチ一覧をJSONファイルで管理する予定（TODOコメントあり）
