# バッチ設計書 69-cpu.sh

## 概要

本ドキュメントは、Node.jsプロジェクトにおけるCPUベンチマーク用ガバナー管理スクリプト（cpu.sh）の設計仕様を記載したものである。

### 本バッチの処理概要

cpu.shは、LinuxシステムにおけるCPUガバナー（周波数制御ポリシー）を管理するシェルスクリプトである。ベンチマーク実行時にCPUを最大パフォーマンスで動作させるために「performance」モードに設定したり、ベンチマーク完了後にデフォルトの省電力モードに戻したりすることができる。

**業務上の目的・背景**：Node.jsの性能測定（ベンチマーク）を正確に行うには、CPUの周波数変動を最小化する必要がある。Linux標準のCPUガバナーは、負荷に応じて動的に周波数を変更するため、ベンチマーク結果にノイズが入る可能性がある。このスクリプトは、ベンチマーク実行時にCPUを最大周波数に固定し、一貫した性能測定を可能にする。また、ベンチマーク後には適切なガバナーに戻すことで、通常の省電力動作を維持できる。

**バッチの実行タイミング**：開発者がNode.jsのベンチマークを実行する前後に手動で実行される。

**主要な処理内容**：
1. 「fast」コマンド: 全CPUコアのガバナーを「performance」に設定
2. 「reset」コマンド: 全CPUコアのガバナーをシステムデフォルト（schedutil/ondemand/conservative/powersave）に戻す
3. 「get」コマンド: 全CPUコアの現在のガバナー設定を表示

**前後の処理との関連**：ベンチマークスクリプト実行前に「fast」を実行し、ベンチマーク完了後に「reset」を実行する。

**影響範囲**：Linuxシステムの全CPUコアのガバナー設定。システム全体の電力消費と発熱に影響する。

## バッチ種別

システム設定（パフォーマンスチューニング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発者による手動実行） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 開発者による手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux OS | Linuxのみサポート |
| root権限 | ガバナー変更にはroot権限が必要（通常sudo経由） |
| cpufreqサポート | /sys/devices/system/cpu/cpu*/cpufreq/が存在すること |

### 実行可否判定

1. Linuxであることを確認（それ以外は警告を表示）
2. root権限があることを確認（権限がない場合は警告を表示）
3. コマンド引数が有効であることを確認

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | 文字列 | Yes | なし | コマンド（fast/performance、reset/default、get/status） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /sys/devices/system/cpu/present | テキスト | 利用可能なCPUコア範囲 |
| /sys/devices/system/cpu/cpu*/cpufreq/scaling_available_governors | テキスト | 利用可能なガバナー一覧 |
| /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor | テキスト | 現在のガバナー設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor | テキスト | ガバナー設定（fast/resetコマンド時） |
| 標準出力 | テキスト | 処理メッセージ、ガバナー状態 |
| 標準エラー出力 | テキスト | 警告メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor |
| 出力先 | sysfs（カーネル仮想ファイルシステム） |
| 文字コード | ASCII |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境チェック
   └─ OS確認: Linux以外は警告を表示
   └─ 権限確認: root以外は警告を表示
2. CPUコア数の取得
   └─ /sys/devices/system/cpu/presentからMAXIDを取得
3. コマンド解析
   └─ fast/performance: performanceガバナーに設定
   └─ reset/default: デフォルトガバナーに設定（優先順: schedutil > ondemand > conservative > powersave）
   └─ get/status: 現在のガバナー設定を表示
   └─ それ以外: Usage表示
4. ガバナー設定（fast/reset時）
   └─ 全CPUコア（0〜MAXID）に対してechoでガバナー名を書き込み
5. 完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B{Linux?}
    B -->|いいえ| C[警告: Linux only]
    B -->|はい| D{root?}
    D -->|いいえ| E[警告: sudo推奨]
    C --> F[CPUコア数取得]
    D --> F
    E --> F
    F --> G{コマンド判定}
    G -->|fast/performance| H[全コアをperformanceに設定]
    G -->|reset/default| I[デフォルトガバナー取得]
    I --> J[全コアをデフォルトに設定]
    G -->|get/status| K[現在のガバナー表示]
    G -->|その他| L[Usage表示]
    H --> M[Done出力]
    J --> M
    K --> N[終了]
    L --> O[exit 1]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 警告 | プラットフォーム警告 | Linux以外で実行 | Linuxシステムで実行 |
| 警告 | 権限警告 | root以外で実行 | sudo付きで実行 |
| 1 | 引数エラー | 不正なコマンドを指定 | fast/reset/getのいずれかを指定 |
| 書き込みエラー | 権限エラー | ガバナー設定書き込み失敗 | root権限で再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. root権限で実行していることを確認（sudo ./benchmark/cpu.sh fast）
2. /sys/devices/system/cpu/cpu0/cpufreq/scaling_governorが存在することを確認
3. カーネルのcpufreqドライバが有効であることを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（一部のコアのみ設定変更された場合は手動で修正が必要） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | N/A |

## 排他制御

なし。複数のプロセスからの同時実行は推奨しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | Linux以外時 | "Warning: This script supports Linux only." |
| 警告ログ | 非root時 | "Warning: This script typically needs root access to modify CPU governor. Consider running it with sudo." |
| 情報ログ | ガバナー設定時 | "Setting governor for all CPU cores to \"{governor_name}\"..." |
| 情報ログ | ガバナー設定完了時 | "Done." |
| 警告ログ | fastモード時 | "Warning: The 'performance' mode locks the CPU at its highest speed." |
| 情報ログ | get時 | "Current governor status for all cores:" + 各コアのガバナー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- Linux専用スクリプト（macOS、Windowsは非対応）
- root権限が必要（sudo経由での実行を推奨）
- performanceモードはCPUを最大周波数に固定するため、発熱と電力消費が増加する
- ベンチマーク完了後は必ずresetコマンドでデフォルトに戻すことを推奨
- デフォルトガバナーの優先順位: schedutil > ondemand > conservative > powersave
- 対応コマンド:
  - fast / performance: 最大パフォーマンスモード
  - reset / default: デフォルトモードに戻す
  - get / status: 現在の状態を表示
