# バッチ設計書 7-test-npm-package.js

## 概要

本ドキュメントは、Node.jsプロジェクトのNPMパッケージテストスクリプト「tools/test-npm-package.js」の設計仕様を記載したものである。

### 本バッチの処理概要

test-npm-package.jsは、NPMパッケージを隔離された環境でテストするためのNode.jsスクリプトである。パッケージを一時ディレクトリにコピーし、独立した環境でnpm runコマンドを実行してテストを実行する。

**業務上の目的・背景**：Node.jsに同梱されるNPMパッケージ（deps/npm配下など）が正しく動作するかをテストする必要がある。test-npm-package.jsは、システムのnpm設定やキャッシュに影響されない隔離された環境でパッケージのテストを実行することで、再現性の高いテスト結果を提供する。一時ディレクトリを使用し、テスト終了後に自動的にクリーンアップを行う。

**バッチの実行タイミング**：テスト実行時、特にNPMパッケージの互換性テストが必要な場合に呼び出される。

**主要な処理内容**：
1. コマンドライン引数の解析
2. 一時ディレクトリの作成（ソースディレクトリのハッシュを使用）
3. パッケージの一時ディレクトリへのコピー
4. npm install/rebuild の実行（オプション）
5. npm run によるテストコマンドの実行
6. テスト終了後の一時ディレクトリの削除

**前後の処理との関連**：test.pyやMakefileから呼び出される。deps/npm/bin/npm-cli.jsを使用してnpmコマンドを実行する。

**影響範囲**：一時ディレクトリにのみ影響を与え、システム設定やグローバルnpm設定には影響しない。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（テスト時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | テストスクリプト / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsビルド済み | node実行ファイルが存在すること |
| deps/npm | deps/npm/bin/npm-cli.jsが存在すること |
| ソースディレクトリ | テスト対象のパッケージディレクトリが存在すること |

### 実行可否判定

- ソースディレクトリが指定されていない場合はエラー
- 認識できないオプションが指定された場合はエラー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| source | 文字列 | Yes | - | テスト対象パッケージのソースディレクトリ |
| test-arg | 文字列 | No | - | npm runに渡すテストコマンドと引数 |
| --install | フラグ | No | false | npm installを実行するか |
| --rebuild | フラグ | No | false | npm rebuildを実行するか |
| --logfile | 文字列 | No | - | stdout出力を書き込むログファイル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースディレクトリ | NPMパッケージ | テスト対象のパッケージディレクトリ |
| package.json | JSON | パッケージ設定とスクリプト定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | テスト実行結果 |
| stderr | テキスト | エラー出力 |
| logfile | テキスト | stdout出力のコピー（オプション） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | --logfileで指定（オプション） |
| 出力先 | 指定されたパス |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ parseArgs関数でコマンドライン引数を解析
2. 一時ディレクトリ作成
   └─ ソースディレクトリのMD5ハッシュを使用してユニークな一時ディレクトリを作成
3. 環境設定
   └─ npm_config_cache, npm_config_prefix, npm_config_tmp, npm_config_userconfigを設定
4. パッケージコピー
   └─ ソースディレクトリを一時ディレクトリにコピー（Windows: xcopy, Unix: cp -r）
5. npm rebuild実行（--rebuild時）
   └─ ネイティブモジュールの再ビルド
6. npm install実行（--install時）
   └─ 依存関係のインストール（--ignore-scripts, --no-save）
7. テスト実行
   └─ npm run <test-args>を--silentモードで実行
8. 出力処理
   └─ stdout/stderrをパイプ、logfileが指定されていればファイルにも出力
9. クリーンアップ
   └─ テスト終了時に一時ディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[test-npm-package.js開始] --> B[引数解析]
    B --> C{引数有効?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[一時ディレクトリ作成]
    E --> F[ソースをコピー]
    F --> G{--rebuild?}
    G -->|Yes| H[npm rebuild]
    G -->|No| I{--install?}
    H --> I
    I -->|Yes| J[npm install]
    I -->|No| K[npm run テスト実行]
    J --> K
    K --> L[stdout/stderrパイプ]
    L --> M{--logfile?}
    M -->|Yes| N[ログファイル出力]
    M -->|No| O[テスト終了待機]
    N --> O
    O --> P[一時ディレクトリ削除]
    P --> Q[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Error | 引数エラー | ソースディレクトリ未指定 | sourceディレクトリを指定 |
| Error | 引数エラー | 認識できないオプション | 正しいオプションを使用 |
| - | npm実行エラー | npm runが失敗 | パッケージのテストスクリプトを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- npm runの詳細出力を確認（--silentを外して再実行）
- 一時ディレクトリ内のパッケージ状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージ/実行 |
| 目標処理時間 | パッケージのテスト内容による |
| メモリ使用量上限 | 環境依存 |

## 排他制御

ソースディレクトリのMD5ハッシュを使用して一時ディレクトリ名を生成するため、同一ソースディレクトリでの並行実行を防止している。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| テスト出力 | テスト実行中 | npm runの出力 |
| ログファイル | テスト実行中 | stdoutの内容（--logfile指定時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元 |

## 備考

- 現在のNode.js実行ファイルとdeps/npm配下のnpmを使用してテストを実行する
- Windowsではxcopy.exe、Unixではcp -rを使用してパッケージをコピー
- npm installは--ignore-scriptsと--no-saveオプション付きで実行される
- 一時ディレクトリはtest/common/tmpdirモジュールを使用して管理される
- テスト終了時（exitイベント）に一時ディレクトリが自動的に削除される
