# バッチ設計書 9-license-builder.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのライセンスファイル生成スクリプト「tools/license-builder.sh」の設計仕様を記載したものである。

### 本バッチの処理概要

license-builder.shは、Node.jsに含まれる全ての依存ライブラリのライセンス情報を収集し、プロジェクトルートのLICENSEファイルを生成するシェルスクリプトである。ローカルファイルおよびリモートURL（curl）からライセンステキストを取得し、統一されたフォーマットで集約する。

**業務上の目的・背景**：Node.jsは多数のサードパーティライブラリ（V8、libuv、OpenSSL、npm等）を含んでいる。法的コンプライアンスのため、これら全てのライセンス情報を適切に開示する必要がある。license-builder.shは、各ライブラリのLICENSEファイルを自動的に収集し、統一されたフォーマットのLICENSEファイルを生成することで、ライセンス管理を自動化する。

**バッチの実行タイミング**：依存ライブラリの更新時、またはリリース準備時に実行される。

**主要な処理内容**：
1. LICENSEファイルのヘッダ部分を保持
2. 各依存ライブラリのライセンスファイルを読み込み
3. addlicense関数で統一フォーマットに整形
4. 全ライセンス情報を集約してLICENSEファイルを更新

**前後の処理との関連**：Makefileのupdate-licensesターゲットから呼び出される。生成されたLICENSEファイルはlicense2rtf.mjsによってRTF形式に変換される。

**影響範囲**：プロジェクトルートのLICENSEファイルに影響を与える。

## バッチ種別

ビルド・ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 依存ライブラリ更新時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | make update-licenses / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ICUインストール済み | deps/icu/ または deps/icu-small/ が存在すること |
| curl | リモートライセンス取得のためcurlが利用可能であること |
| 依存ライブラリ | deps/配下に依存ライブラリが存在すること |

### 実行可否判定

- ICUディレクトリが存在しない場合はエラー（configureでダウンロードが必要）
- ICUライセンスファイルが見つからない場合はエラー

## 入力仕様

### 入力パラメータ

本スクリプトはコマンドライン引数を取らない。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| LICENSE | テキスト | 既存のLICENSEファイル（ヘッダ部分） |
| deps/*/LICENSE | テキスト | 依存ライブラリのライセンス |
| リモートURL | テキスト | GitHub等からcurlで取得するライセンス |

### 取得するライセンス一覧

| ライブラリ | パス/URL |
|-----------|----------|
| Acorn | deps/acorn/acorn/LICENSE |
| c-ares | deps/cares/LICENSE.md |
| merve | deps/merve/LICENSE-MIT |
| ittapi | deps/v8/third_party/ittapi/LICENSES/BSD-3-Clause.txt |
| amaro | deps/amaro/LICENSE.md |
| swc | deps/amaro/dist/LICENSE |
| ICU | deps/icu/LICENSE または deps/icu-small/LICENSE |
| libuv | deps/uv/LICENSE + LICENSE-extra |
| LIEF | deps/LIEF/LICENSE |
| llhttp | deps/llhttp/LICENSE-MIT |
| corepack | deps/corepack/LICENSE.md |
| undici | deps/undici/LICENSE |
| postject | test/fixtures/postject-copy/node_modules/postject/LICENSE |
| OpenSSL | deps/openssl/openssl/LICENSE.txt |
| Punycode.js | GitHub（curl） |
| V8 | deps/v8/LICENSE |
| SipHash | deps/v8/third_party/siphash/halfsiphash.cc（抽出） |
| zlib | deps/zlib/zlib.h（抽出） |
| simdjson | deps/simdjson/LICENSE |
| simdutf | deps/v8/third_party/simdutf/LICENSE |
| ada | GitHub（curl） |
| minimatch | deps/minimatch/LICENSE.md |
| npm | deps/npm/LICENSE |
| GYP | tools/gyp/LICENSE |
| inspector_protocol | deps/inspector_protocol/LICENSE |
| jinja2 | tools/inspector_protocol/jinja2/LICENSE |
| markupsafe | tools/inspector_protocol/markupsafe/LICENSE |
| cpplint.py | tools/cpplint.py（抽出） |
| gypi_to_gn.py | tools/gypi_to_gn.py（抽出） |
| gtest | deps/googletest/LICENSE |
| nghttp2 | deps/nghttp2/COPYING |
| large_pages | src/large_pages/node_large_page.h（抽出） |
| caja | lib/internal/freeze_intrinsics.js（抽出） |
| brotli | deps/brotli/LICENSE |
| zstd | deps/zstd/LICENSE |
| HdrHistogram | deps/histogram/LICENSE.txt |
| node-heapdump | GitHub（curl） |
| rimraf | GitHub（curl） |
| uvwasi | deps/uvwasi/LICENSE |
| ngtcp2 | deps/ngtcp2/LICENSE_ngtcp2 |
| nghttp3 | deps/ngtcp2/LICENSE_nghttp3 |
| node-fs-extra | GitHub（curl） |
| on-exit-leak-free | GitHub（curl） |
| sonic-boom | GitHub（curl） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| LICENSE | テキスト | 集約されたライセンスファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | LICENSE |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

### 出力フォーマット

```
- {ライブラリ名}, located at {パス}, is licensed as follows:
  """
    {ライセンステキスト（インデント付き）}
  """
```

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ プロジェクトルートとファイルパスを設定
2. ヘッダ保持
   └─ 既存LICENSEファイルから「- 」で始まる行より前を保持
3. ICU確認
   └─ deps/icu/ または deps/icu-small/ の存在を確認
4. ライセンス収集
   └─ 各依存ライブラリのLICENSEファイルを読み込み
   └─ 必要に応じてsedで抽出・整形
   └─ 必要に応じてcurlでリモートから取得
5. addlicense関数で追加
   └─ 統一フォーマットで一時ファイルに追加
6. ファイル置換
   └─ 一時ファイルをLICENSEにリネーム
```

### フローチャート

```mermaid
flowchart TD
    A[license-builder.sh開始] --> B[パス設定]
    B --> C[LICENSEヘッダ保持]
    C --> D{ICU存在?}
    D -->|No| E[エラー：ICUなし]
    D -->|Yes| F[依存ライブラリループ]
    F --> G{ローカルファイル?}
    G -->|Yes| H[catで読み込み]
    G -->|No| I[curlで取得]
    H --> J[addlicenseで追加]
    I --> J
    J --> K{次のライブラリ?}
    K -->|Yes| F
    K -->|No| L[一時ファイルをLICENSEに置換]
    L --> M[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 前提条件エラー | ICUディレクトリなし | configure --with-intl=small-icu --download=icuを実行 |
| 1 | ファイル不在 | ICUライセンスファイルなし | ICUを正しくインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- curlでの取得失敗時は手動でライセンスを追加
- ファイルパスの変更時はスクリプトを更新

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約40ライブラリ |
| 目標処理時間 | 数秒〜数十秒（ネットワーク依存） |
| メモリ使用量上限 | 数MB |

## 排他制御

LICENSEファイルへの書き込みは一時ファイル経由でアトミックに行われる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 標準的なログ出力は行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元 |

## 備考

- set -eにより、エラー発生時は即座にスクリプトが終了する
- 一時ファイルは~LICENSE.$$というパターンで作成される
- ICUのバージョンによりLICENSEファイルのパスが異なる（57以降はLICENSE、56以前はlicense.html）
- 一部のライセンスはソースコードのヘッダコメントから抽出される（SipHash、zlib、cpplint.py等）
- curlで取得するライセンスは特定のコミットハッシュを指定している場合がある
- 最終的にmvコマンドで一時ファイルをLICENSEに置換（アトミック更新）
