---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-license2rtf.mjs.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/license2rtf.mjs` 1-303行目
- E-02: `バッチ一覧.csv` 11行目（license2rtf.mjsの説明）
- E-03: `tools/license2rtf.mjs` 9-33行目（LineSplitterクラス）
- E-04: `tools/license2rtf.mjs` 39-161行目（ParagraphParserクラス）
- E-05: `tools/license2rtf.mjs` 169-218行目（Unwrapperクラス）
- E-06: `tools/license2rtf.mjs` 220-232行目（rtfEscape関数）
- E-07: `tools/license2rtf.mjs` 237-290行目（RtfGeneratorクラス）
- E-08: `tools/license2rtf.mjs` 281-284行目（emitHeader - RTFヘッダ）
- E-09: `tools/license2rtf.mjs` 244-270行目（write - 段落変換）
- E-10: `tools/license2rtf.mjs` 295-302行目（pipelineでストリーム接続）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LICENSEをRTF形式に変換 | E-01, E-02 | ○ |
| C-02 | LineSplitterで行分割（CR/LF/CRLF対応） | E-03 (行17) | ○ |
| C-03 | ParagraphParserでライセンスブロック検出 | E-04 (行88-91: """検出) | ○ |
| C-04 | Unwrapperで折り返し解除（50文字未満保持） | E-05 (行185-191) | ○ |
| C-05 | RtfGeneratorでRTF形式出力 | E-07 | ○ |
| C-06 | フォントはTahoeを使用 | E-08 (行283) | ○ |
| C-07 | ライセンスブロック外は太字 | E-09 (行260-261, 265-266) | ○ |
| C-08 | ライセンスブロック内は右マージン240 | E-09 (行259: \\ri240) | ○ |
| C-09 | バックスラッシュ・中括弧をエスケープ | E-06 (行226) | ○ |
| C-10 | タブを\\tabに変換 | E-06 (行227) | ○ |
| C-11 | 制御文字を\\'XXに変換 | E-06 (行229) | ○ |
| C-12 | BOMを削除 | E-06 (行230) | ○ |
| C-13 | Unicode文字を\\uXXXX?に変換 | E-06 (行231) | ○ |
| C-14 | コードページ1252を使用 | E-08 (行282: ansicpg1252) | ○ |
| C-15 | pipelineでストリーム接続 | E-10 | ○ |
| C-16 | 標準入力をUTF-8で読み込み | E-01 (行292) | ○ |
| C-17 | リスト項目は\\fi-240でインデント | E-09 (行257) | ○ |
| C-18 | 段落後150twips（\\sa150） | E-09 (行253) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] RTFの出力がWindowsのMSIインストーラーで正しく表示されるか確認
- [ ] 特殊文字（Unicode文字等）が正しくエスケープされるか確認
- [ ] LICENSEファイルのフォーマット変更時に正しく処理されるか確認
