---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-commit-queue.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **実行スケジュールの詳細**：GitHub Actionsワークフロー定義ファイルが未確認
  2. **パフォーマンス要件**：想定処理件数・時間は推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/actions/commit-queue.sh`（ソースコード）
- E-02: `バッチ一覧.csv`（バッチ定義）
- E-03: ソースコード内のGitHub CLI（gh）コマンド使用箇所
- E-04: ソースコード内のjqコマンド使用箇所
- E-05: ソースコード内のgit node landコマンド使用箇所
- E-06: ソースコード内のGitHub API呼び出し箇所

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | commit-queueラベル付きPRを自動マージする | E-01 (L12-13, L49) | ○ |
| C-02 | request-ciラベルがある場合はスキップ | E-01 (L37-40) | ○ |
| C-03 | CI pending状態の場合はスキップ | E-01 (L43-46) | ○ |
| C-04 | commit-queue-squashでfixupAllモード | E-01 (L51-52) | ○ |
| C-05 | commit-queue-rebaseでリベースモード | E-01 (L53-54) | ○ |
| C-06 | それ以外はoneCommitMaxモード | E-01 (L55-57) | ○ |
| C-07 | git node landコマンドを使用 | E-01 (L59) | ○ |
| C-08 | GitHub APIでsquashマージ実行 | E-01 (L90-101) | ○ |
| C-09 | 失敗時にcommit-queue-failedラベル付与 | E-01 (L18) | ○ |
| C-10 | 失敗時にエラーコメントを投稿 | E-01 (L22-25) | ○ |
| C-11 | 成功時にLanded inコメントを投稿 | E-01 (L106) | ○ |
| C-12 | リベースモード時にPRをクローズ | E-01 (L108) | ○ |
| C-13 | git node land --abortで中断処理 | E-01 (L70) | ○ |
| C-14 | ボットアカウントでコミット | E-01 (L31-32) | ○ |
| C-15 | OWNER, REPOSITORYを引数で受け取る | E-01 (L5-7) | ○ |
| C-16 | set -xeでデバッグ・エラー停止 | E-01 (L3) | ○ |
| C-17 | outputファイルを一時ファイルとして使用 | E-01 (L59, L104) | ○ |
| C-18 | labels.jsonを一時ファイルとして使用 | E-01 (L35, L111) | ○ |
| C-19 | GITHUB_RUN_IDを使用してActionsURLを生成 | E-01 (L21) | ○ |
| C-20 | ghコマンドでラベル操作 | E-01 (L18, L49) | ○ |
| C-21 | jqでラベル判定 | E-01 (L37, L51, L53) | ○ |
| C-22 | git pushでリモートにプッシュ | E-01 (L79) | ○ |
| C-23 | GITHUB_SERVER_URL環境変数を使用 | E-01 (L21) | ○ |
| C-24 | 実行スケジュールはイベント駆動/定期実行 | **根拠なし** | △ |
| C-25 | 想定処理件数は1〜10 PR/実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GitHub Actionsワークフロー定義ファイル（.github/workflows/）が未確認のため、実行スケジュールの詳細が不明
  - 候補：`.github/workflows/commit-queue.yml` / `.github/workflows/auto-merge.yml`
- パフォーマンス要件は実測値ではなく推定値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードから確認済み
- 1: 中リスク - 実行スケジュールはワークフロー定義の確認が必要
- 0: 低リスク - エラー処理は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義ファイルで実行スケジュールを確認
- [ ] git-node CLIの前提条件（インストール方法）を確認
- [ ] 本番環境でのパフォーマンス実績を確認
- [ ] GITHUB_TOKEN権限の要件を確認
