---
generated_at: 2026-01-30 17:34:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-rebase.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/actions/rebase.sh`（ソースコード）
- E-02: `バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub GraphQL APIを使用してリベースする | E-01 (L6-11) | ○ |
| C-02 | gh pr viewでPR IDを取得 | E-01 (L6) | ○ |
| C-03 | updatePullRequestBranch mutationを使用 | E-01 (L8) | ○ |
| C-04 | updateMethod: REBASEを指定 | E-01 (L8) | ○ |
| C-05 | clientMutationIdを返却 | E-01 (L9) | ○ |
| C-06 | set -xeでデバッグ・エラー停止 | E-01 (L3) | ○ |
| C-07 | PR取得失敗時も継続（|| true） | E-01 (L6) | ○ |
| C-08 | 11行のシンプルなスクリプト | E-01（全体） | ○ |
| C-09 | 第1引数でPR識別子を受け取る | E-01 (L6) | ○ |
| C-10 | ghコマンドが必要 | E-01 (L6) | ○ |
| C-11 | gh api graphqlでmutation実行 | E-01 (L6) | ○ |
| C-12 | prIDパラメータを渡す | E-01 (L6) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（スクリプトがシンプルなため、全ての機能がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能はソースコードから確認済み
- 0: 低リスク - スクリプトが非常にシンプルでエラーの余地が少ない

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub GraphQL APIの権限要件を確認
- [ ] リベース失敗時の挙動を確認
- [ ] コンフリクト発生時の対処方法を確認
