---
generated_at: 2026-01-30 17:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-start-ci.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ncu-ciコマンドの詳細仕様**：外部ツールの詳細な動作は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/actions/start-ci.sh`（ソースコード）
- E-02: `バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | request-ciラベルが付与されたPRのCIを開始する | E-01 (L5, L9) | ○ |
| C-02 | request-ciラベルを削除する | E-01 (L9) | ○ |
| C-03 | ncu-ci runコマンドでCI実行を開始 | E-01 (L13) | ○ |
| C-04 | 失敗時にrequest-ci-failedラベルを付与 | E-01 (L18) | ○ |
| C-05 | 失敗時にエラーコメントを投稿 | E-01 (L21-25) | ○ |
| C-06 | GITHUB_SERVER_URL環境変数を使用 | E-01 (L21) | ○ |
| C-07 | GITHUB_REPOSITORY環境変数を使用 | E-01 (L21) | ○ |
| C-08 | GITHUB_RUN_ID環境変数を使用 | E-01 (L21) | ○ |
| C-09 | outputファイルに出力を記録 | E-01 (L13) | ○ |
| C-10 | outputファイルを削除 | E-01 (L12, L27) | ○ |
| C-11 | set -xeでデバッグ・エラー停止 | E-01 (L3) | ○ |
| C-12 | 複数PRをforループで順次処理 | E-01 (L8, L29) | ○ |
| C-13 | ghコマンドでラベル操作 | E-01 (L9, L18) | ○ |
| C-14 | ghコマンドでコメント投稿 | E-01 (L25) | ○ |
| C-15 | ci_started変数で成功/失敗を判定 | E-01 (L11, L13, L16) | ○ |
| C-16 | エラーコメントはHTML形式（detailsタグ） | E-01 (L22) | ○ |
| C-17 | catでoutputファイル内容を表示 | E-01 (L14) | ○ |
| C-18 | ncu-ciはJenkins等の外部CIを起動 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ncu-ciコマンドの内部実装・動作仕様が未確認
  - 候補：Node.js Commit Queue CI リポジトリ / 別ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードから確認済み
- 1: 中リスク - ncu-ciコマンドの詳細仕様は外部依存
- 0: 低リスク - エラー処理は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] ncu-ciコマンドのインストール方法と設定を確認
- [ ] 外部CIシステム（Jenkins等）へのアクセス権限を確認
- [ ] GITHUB_TOKEN権限の要件を確認
- [ ] GitHub Actionsワークフロー定義でトリガー条件を確認
