---
generated_at: 2026-01-30 17:38:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-review_backport.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/actions/review_backport.sh`（ソースコード）
- E-02: `バッチ一覧.csv`（バッチ定義）
- E-03: ソースコード内のコメント（L6-9: 使用方法説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バックポートPRとオリジナルPRの差分を比較する | E-01 (L29) | ○ |
| C-02 | 単一コミットPRのみサポート | E-01 (L9), E-03 | ○ |
| C-03 | 引数でバックポートPR URLを受け取る | E-01 (L3) | ○ |
| C-04 | 引数未指定時に使用方法を表示 | E-01 (L5-12) | ○ |
| C-05 | DIFF_CMD環境変数でdiffツールを指定可能 | E-01 (L8, L29) | ○ |
| C-06 | デフォルトdiffコマンドはdiff | E-01 (L29) | ○ |
| C-07 | mktempで一時ファイルを作成 | E-01 (L18-19) | ○ |
| C-08 | gh pr viewでコミット情報を取得 | E-01 (L20) | ○ |
| C-09 | jqでPR-URLを正規表現抽出 | E-01 (L20) | ○ |
| C-10 | curlで差分ファイルをダウンロード | E-01 (L25-26) | ○ |
| C-11 | curl -fオプションでエラー時失敗 | E-01 (L25-26) | ○ |
| C-12 | sedでインデックス行を正規化 | E-01 (L14) | ○ |
| C-13 | sedでハンク情報行を正規化 | E-01 (L14) | ○ |
| C-14 | 一時ファイルを削除 | E-01 (L30) | ○ |
| C-15 | set -exでデバッグ・エラー停止 | E-01 (L16) | ○ |
| C-16 | whileループでコミットを処理 | E-01 (L21-27) | ○ |
| C-17 | cutでコミットSHAを抽出 | E-01 (L22) | ○ |
| C-18 | cutでPR URLを抽出 | E-01 (L23) | ○ |
| C-19 | 使用例でlessへのパイプを示す | E-01 (L7), E-03 | ○ |
| C-20 | 使用例でcodiumの指定方法を示す | E-01 (L8), E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能はソースコードから確認済み
- 0: 低リスク - 読み取り専用処理のためリポジトリへの影響なし
- 0: 低リスク - 正規化ロジックはソースコードで明確

## 6) レビュアーチェックリスト（最小）
- [ ] 複数コミットPRへの対応が必要な場合の対処方法を確認
- [ ] sed正規化パターンが全てのケースをカバーしているか確認
- [ ] DIFF_CMDオプションの他の使用例を確認
