---
generated_at: 2026-01-30 17:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-create-release-proposal.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/actions/create-release-proposal.sh`（ソースコード）
- E-02: `バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リリース候補のPRを自動作成する | E-01 (L51-57) | ○ |
| C-02 | git node release --prepareでリリースコミット準備 | E-01 (L31) | ○ |
| C-03 | RELEASE_DATE引数が必須 | E-01 (L10-13) | ○ |
| C-04 | RELEASE_LINE引数が必須 | E-01 (L10-13) | ○ |
| C-05 | RELEASER引数でアサイニー指定 | E-01 (L8, L134) | ○ |
| C-06 | GITHUB_REPOSITORY環境変数が必須 | E-01 (L15-18) | ○ |
| C-07 | BOT_TOKEN環境変数が必須 | E-01 (L15-18) | ○ |
| C-08 | 依存コマンドの存在確認 | E-01 (L20-27) | ○ |
| C-09 | node, gh, git, git-node, awkが必要 | E-01 (L21) | ○ |
| C-10 | set -xeでデバッグ・エラー停止 | E-01 (L29) | ○ |
| C-11 | HEAD_BRANCHを取得 | E-01 (L33) | ○ |
| C-12 | HEAD_SHAを取得 | E-01 (L34) | ○ |
| C-13 | チェンジログからPR本文生成 | E-01 (L38-40) | ○ |
| C-14 | MAX_BODY_LENGTH=65536 | E-01 (L38) | ○ |
| C-15 | 長すぎる場合は省略 | E-01 (L40) | ○ |
| C-16 | REST APIでブランチ作成 | E-01 (L43-48) | ○ |
| C-17 | REST APIでドラフトPR作成 | E-01 (L51-57) | ○ |
| C-18 | draft=trueで作成 | E-01 (L57) | ○ |
| C-19 | ベースブランチはv{LINE}.x | E-01 (L57) | ○ |
| C-20 | GraphQL APIでコミットプッシュ | E-01 (L60-132) | ○ |
| C-21 | createCommitOnBranch mutationを使用 | E-01 (L82-100) | ○ |
| C-22 | ファイルをbase64エンコード | E-01 (L116) | ○ |
| C-23 | 削除ファイルにも対応 | E-01 (L67, L117) | ○ |
| C-24 | PR-URLをPR URLで置換 | E-01 (L65) | ○ |
| C-25 | releaseラベルを付与 | E-01 (L134) | ○ |
| C-26 | v{LINE}.xラベルを付与 | E-01 (L134) | ○ |
| C-27 | リリーサーをアサイン | E-01 (L134) | ○ |
| C-28 | GitHub API Version 2022-11-28を使用 | E-01 (L46, L55) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能はソースコードから確認済み
- 1: 中リスク - GraphQL APIの複雑な処理があるが、エラー時のロールバックは手動
- 0: 低リスク - 入力検証が適切に行われている

## 6) レビュアーチェックリスト（最小）
- [ ] BOT_TOKENの権限（repo権限）を確認
- [ ] git node release --prepareの前提条件を確認
- [ ] 既存ブランチとの衝突時の対処方法を確認
- [ ] GraphQL API失敗時の手動リカバリ手順を確認
